/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.block.anvilmagma;

import com.lothrazar.cyclic.base.FluidTankBase;
import com.lothrazar.cyclic.base.TileEntityBase;
import com.lothrazar.cyclic.block.anvilmagma.ContainerAnvilMagma;
import com.lothrazar.cyclic.fluid.FluidMagmaHolder;
import com.lothrazar.cyclic.registry.DataTags;
import com.lothrazar.cyclic.registry.TileRegistry;
import com.lothrazar.cyclic.util.UtilItemStack;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.fluid.Fluid;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public class TileAnvilMagma
extends TileEntityBase
implements INamedContainerProvider,
ITickableTileEntity {
    private static final int OUT = 1;
    private static final int IN = 0;
    public static final int CAPACITY = 64000;
    ItemStackHandler inventory = new ItemStackHandler(2){

        public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
            if (slot == 0) {
                return stack.isRepairable() && stack.func_77952_i() > 0;
            }
            if (slot == 1) {
                return stack.isRepairable() && stack.func_77952_i() == 0;
            }
            return true;
        }
    };
    private LazyOptional<IItemHandler> inventoryCap = LazyOptional.of(() -> this.inventory);
    public FluidTankBase tank = new FluidTankBase(this, 64000, this.isFluidValid());

    public TileAnvilMagma() {
        super(TileRegistry.anvil_magma);
        this.needsRedstone = 0;
    }

    public void func_73660_a() {
        if (this.requiresRedstone() && !this.isPowered()) {
            this.setLitProperty(false);
            return;
        }
        this.setLitProperty(true);
        ItemStack stack = this.inventory.getStackInSlot(0);
        if (stack.func_190926_b() || stack.func_77973_b().func_206844_a(DataTags.IMMUNE)) {
            return;
        }
        int repair = 100;
        boolean work = false;
        if (this.tank != null && this.tank.getFluidAmount() >= 100 && stack.isRepairable() && stack.func_77952_i() > 0) {
            work = true;
            this.tank.drain(100, IFluidHandler.FluidAction.EXECUTE);
        }
        if (work) {
            boolean done;
            UtilItemStack.repairItem(stack);
            boolean bl = done = stack.func_77952_i() == 0;
            if (done && this.inventory.getStackInSlot(1).func_190926_b()) {
                this.inventory.insertItem(1, stack.func_77946_l(), false);
                this.inventory.extractItem(0, stack.func_190916_E(), false);
            }
        }
    }

    public Predicate<FluidStack> isFluidValid() {
        return p -> {
            Fluid fluid = p.getFluid();
            return fluid == FluidMagmaHolder.STILL.get();
        };
    }

    public ITextComponent func_145748_c_() {
        return new StringTextComponent(this.func_200662_C().getRegistryName().func_110623_a());
    }

    @Nullable
    public Container createMenu(int i, PlayerInventory playerInventory, PlayerEntity playerEntity) {
        return new ContainerAnvilMagma(i, this.field_145850_b, this.field_174879_c, playerInventory, playerEntity);
    }

    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, Direction side) {
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.inventoryCap.cast();
        }
        if (cap == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return LazyOptional.of(() -> this.tank).cast();
        }
        return super.getCapability(cap, side);
    }

    @Override
    public void func_230337_a_(BlockState bs, CompoundNBT tag) {
        this.inventory.deserializeNBT(tag.func_74775_l("inv"));
        this.tank.readFromNBT(tag.func_74775_l("fluid"));
        super.func_230337_a_(bs, tag);
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT tag) {
        CompoundNBT fluid = new CompoundNBT();
        this.tank.writeToNBT(fluid);
        tag.func_218657_a("fluid", (INBT)fluid);
        tag.func_218657_a("inv", (INBT)this.inventory.serializeNBT());
        return super.func_189515_b(tag);
    }

    @Override
    public int getField(int id) {
        switch (Fields.values()[id]) {
            case REDSTONE: {
                return this.needsRedstone;
            }
            case TIMER: {
                return this.timer;
            }
        }
        return 0;
    }

    @Override
    public void setField(int field, int value) {
        switch (Fields.values()[field]) {
            case REDSTONE: {
                this.needsRedstone = value % 2;
                break;
            }
            case TIMER: {
                this.timer = value;
            }
        }
    }

    public FluidStack getFluid() {
        return this.tank == null ? FluidStack.EMPTY : this.tank.getFluid();
    }

    static enum Fields {
        TIMER,
        REDSTONE;

    }
}

