/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.block.cable.fluid;

import com.lothrazar.cyclic.block.cable.CableBase;
import com.lothrazar.cyclic.block.cable.DirectionNullable;
import com.lothrazar.cyclic.block.cable.EnumConnectType;
import com.lothrazar.cyclic.block.cable.ShapeCache;
import com.lothrazar.cyclic.block.cable.fluid.TileCableFluid;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class BlockCableFluid
extends CableBase {
    public BlockCableFluid(AbstractBlock.Properties properties) {
        super(properties.func_200943_b(0.5f));
    }

    @Override
    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult hit) {
        FluidStack fluid;
        int st;
        TileEntity ent;
        IFluidHandler handlerHere;
        if (!world.field_72995_K && (handlerHere = (IFluidHandler)(ent = world.func_175625_s(pos)).getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, null).orElse(null)) != null && handlerHere.getFluidInTank(0) != null && (st = (fluid = handlerHere.getFluidInTank(0)).getAmount()) > 0) {
            player.func_146105_b((ITextComponent)new TranslationTextComponent(st + " " + fluid.getDisplayName()), true);
        }
        return super.func_225533_a_(state, world, pos, player, hand, hit);
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return ShapeCache.getOrCreate(state, CableBase::createShape);
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    @Nullable
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new TileCableFluid();
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        super.func_206840_a(builder);
        builder.func_206894_a(new Property[]{UP, DOWN, NORTH, EAST, SOUTH, WEST, EXTR});
    }

    public void func_180633_a(World worldIn, BlockPos pos, BlockState stateIn, @Nullable LivingEntity placer, ItemStack stack) {
        stateIn = (BlockState)stateIn.func_206870_a((Property)EXTR, (Comparable)((Object)DirectionNullable.NONE));
        for (Direction d : Direction.values()) {
            IFluidHandler cap;
            TileEntity facingTile = worldIn.func_175625_s(pos.func_177972_a(d));
            IFluidHandler iFluidHandler = cap = facingTile == null ? null : (IFluidHandler)facingTile.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, d.func_176734_d()).orElse(null);
            if (cap == null) continue;
            stateIn = (BlockState)stateIn.func_206870_a((Property)FACING_TO_PROPERTY_MAP.get(d), (Comparable)((Object)EnumConnectType.INVENTORY));
        }
        worldIn.func_175656_a(pos, stateIn);
    }

    public BlockState func_196271_a(BlockState stateIn, Direction facing, BlockState facingState, IWorld world, BlockPos currentPos, BlockPos facingPos) {
        EnumProperty property = (EnumProperty)FACING_TO_PROPERTY_MAP.get(facing);
        if (((EnumConnectType)((Object)stateIn.func_177229_b((Property)property))).isBlocked()) {
            return stateIn;
        }
        if (BlockCableFluid.isFluid(stateIn, facing, facingState, world, currentPos, facingPos)) {
            return (BlockState)stateIn.func_206870_a((Property)property, (Comparable)((Object)EnumConnectType.INVENTORY));
        }
        return (BlockState)stateIn.func_206870_a((Property)property, (Comparable)((Object)EnumConnectType.NONE));
    }
}

