/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.block.collectitem;

import com.lothrazar.cyclic.base.TileEntityBase;
import com.lothrazar.cyclic.block.collectitem.ContainerItemCollector;
import com.lothrazar.cyclic.registry.TileRegistry;
import com.lothrazar.cyclic.util.UtilShape;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public class TileItemCollector
extends TileEntityBase
implements ITickableTileEntity,
INamedContainerProvider {
    private static final int MAX_SIZE = 11;
    ItemStackHandler inventory = new ItemStackHandler(18);
    private LazyOptional<IItemHandler> inventoryCap = LazyOptional.of(() -> this.inventory);
    private int radius = 8;

    public TileItemCollector() {
        super(TileRegistry.collectortile);
    }

    public void func_73660_a() {
        if (this.requiresRedstone() && !this.isPowered()) {
            this.setLitProperty(false);
            return;
        }
        this.setLitProperty(true);
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        AxisAlignedBB aabb = this.getRange();
        List list = this.field_145850_b.func_175647_a(ItemEntity.class, aabb, entity -> entity.func_70089_S());
        if (list.size() > 0) {
            ItemEntity stackEntity = (ItemEntity)list.get(this.field_145850_b.field_73012_v.nextInt(list.size()));
            ItemStack remainder = stackEntity.func_92059_d();
            for (int i = 0; i < this.inventory.getSlots() && !remainder.func_190926_b(); ++i) {
                remainder = this.inventory.insertItem(i, remainder, false);
            }
            stackEntity.func_92058_a(remainder);
            if (remainder.func_190926_b()) {
                stackEntity.func_70106_y();
            }
        }
    }

    public ITextComponent func_145748_c_() {
        return new StringTextComponent(this.func_200662_C().getRegistryName().func_110623_a());
    }

    @Nullable
    public Container createMenu(int i, PlayerInventory playerInventory, PlayerEntity playerEntity) {
        return new ContainerItemCollector(i, this.field_145850_b, this.field_174879_c, playerInventory, playerEntity);
    }

    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, Direction side) {
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.inventoryCap.cast();
        }
        return super.getCapability(cap, side);
    }

    @Override
    public void func_230337_a_(BlockState bs, CompoundNBT tag) {
        this.radius = tag.func_74762_e("radius");
        this.inventory.deserializeNBT(tag.func_74775_l("inv"));
        super.func_230337_a_(bs, tag);
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT tag) {
        tag.func_74768_a("radius", this.radius);
        tag.func_218657_a("inv", (INBT)this.inventory.serializeNBT());
        return super.func_189515_b(tag);
    }

    private BlockPos getTargetCenter() {
        return this.func_174877_v().func_177967_a(this.getCurrentFacing(), this.radius + 1);
    }

    public List<BlockPos> getShape() {
        return UtilShape.squareHorizontalHollow(this.getCurrentFacingPos(this.radius + 1), this.radius);
    }

    private AxisAlignedBB getRange() {
        BlockPos center = this.getTargetCenter();
        AxisAlignedBB aabb = new AxisAlignedBB((double)(center.func_177958_n() - this.radius), (double)center.func_177956_o(), (double)(center.func_177952_p() - this.radius), (double)(center.func_177958_n() + this.radius + 1), (double)(center.func_177956_o() + 2), (double)(center.func_177952_p() + this.radius + 1));
        return aabb;
    }

    @Override
    public void setField(int field, int value) {
        switch (Fields.values()[field]) {
            case REDSTONE: {
                this.setNeedsRedstone(value);
                break;
            }
            case RENDER: {
                this.render = value % 2;
                break;
            }
            case SIZE: {
                this.radius = value % 11;
            }
        }
    }

    @Override
    public int getField(int field) {
        switch (Fields.values()[field]) {
            case REDSTONE: {
                return this.needsRedstone;
            }
            case RENDER: {
                return this.render;
            }
            case SIZE: {
                return this.radius;
            }
        }
        return 0;
    }

    static enum Fields {
        REDSTONE,
        RENDER,
        SIZE;

    }
}

