/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.block.dice;

import com.lothrazar.cyclic.base.BlockBase;
import com.lothrazar.cyclic.block.dice.TileDice;
import com.lothrazar.cyclic.registry.SoundRegistry;
import com.lothrazar.cyclic.util.UtilBlockstates;
import com.lothrazar.cyclic.util.UtilSound;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.RenderTypeLookup;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.FluidState;
import net.minecraft.item.ItemStack;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockDisplayReader;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class BlockDice
extends BlockBase {
    private static final double BOUNDS = 1.0;
    private static final VoxelShape AABB = Block.func_208617_a((double)1.0, (double)1.0, (double)1.0, (double)15.0, (double)15.0, (double)15.0);

    public BlockDice(AbstractBlock.Properties properties) {
        super(properties.func_200943_b(1.8f).func_226896_b_());
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return AABB;
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    public boolean shouldDisplayFluidOverlay(BlockState state, IBlockDisplayReader world, BlockPos pos, FluidState fluidState) {
        return true;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void registerClient() {
        RenderTypeLookup.setRenderLayer((Block)this, (RenderType)RenderType.func_228641_d_());
    }

    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new TileDice();
    }

    public void func_180633_a(World world, BlockPos pos, BlockState state, @Nullable LivingEntity entity, ItemStack stack) {
        if (entity != null) {
            world.func_180501_a(pos, (BlockState)state.func_206870_a((Property)BlockStateProperties.field_208155_H, (Comparable)UtilBlockstates.getFacingFromEntityHorizontal(pos, entity)), 2);
        }
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{BlockStateProperties.field_208155_H});
    }

    @Override
    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult result) {
        TileEntity tile = world.func_175625_s(pos);
        if (hand == Hand.MAIN_HAND && tile instanceof TileDice) {
            ((TileDice)tile).startSpinning();
            if (world.field_72995_K) {
                UtilSound.playSound(pos, SoundRegistry.dice_mike_koenig);
            }
            return ActionResultType.SUCCESS;
        }
        return super.func_225533_a_(state, world, pos, player, hand, result);
    }

    public static Direction getRandom(Random rand) {
        int index = MathHelper.func_76136_a((Random)rand, (int)0, (int)(Direction.values().length - 1));
        return Direction.values()[index];
    }
}

