/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.block.endershelf;

import com.lothrazar.cyclic.block.endershelf.EnderShelfHelper;
import com.lothrazar.cyclic.block.endershelf.EnderShelfItemHandler;
import com.lothrazar.cyclic.block.endershelf.TileEnderShelf;
import com.lothrazar.cyclic.util.UtilEnchant;
import java.util.ArrayList;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.ItemStackHandler;

public class EnderControllerItemHandler
extends ItemStackHandler {
    private final TileEnderShelf controller;

    public EnderControllerItemHandler(TileEnderShelf controller) {
        super(1);
        this.controller = controller;
    }

    @Nonnull
    public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
        ItemStack remaining = ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)stack.func_190916_E());
        if (!(remaining = this.insertItemElsewhere(remaining, false, simulate)).func_190926_b()) {
            remaining = this.insertItemElsewhere(remaining, true, simulate);
        }
        return remaining;
    }

    private ItemStack insertItemElsewhere(ItemStack stack, boolean insertWhenEmpty, boolean simulate) {
        if (this.controller.func_145831_w() == null) {
            return stack;
        }
        for (BlockPos shelfPos : this.controller.getShelves()) {
            TileEntity te = this.controller.func_145831_w().func_175625_s(shelfPos);
            if (te == null || !EnderShelfHelper.isShelf(te.func_195044_w())) continue;
            TileEnderShelf shelf = (TileEnderShelf)te;
            stack = this.insertItemElsewhere(shelf, stack, insertWhenEmpty, simulate);
        }
        return stack;
    }

    private ItemStack insertItemElsewhere(TileEnderShelf shelf, ItemStack stack, boolean insertWhenEmpty, boolean simulate) {
        if (EnderShelfHelper.isController(shelf.func_195044_w())) {
            return stack;
        }
        EnderShelfItemHandler h = EnderShelfHelper.getShelfHandler(shelf);
        if (h == null) {
            return stack;
        }
        ArrayList<Integer> emptySlots = new ArrayList<Integer>();
        for (int i = 0; i < h.getSlots(); ++i) {
            ItemStack slotStack = h.getStackInSlot(i);
            if (slotStack.func_190926_b()) {
                emptySlots.add(i);
                continue;
            }
            if (!UtilEnchant.doBookEnchantmentsMatch(stack, slotStack) || slotStack.func_190916_E() == h.getStackLimit(i, stack)) continue;
            return h.insertItem(i, stack, simulate);
        }
        if (emptySlots.size() > 0 && insertWhenEmpty) {
            return h.insertItem((Integer)emptySlots.get(0), stack, simulate);
        }
        return stack;
    }

    @Nonnull
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        return this.extractItemElsewhere(amount, simulate);
    }

    private ItemStack extractItemElsewhere(int amount, boolean simulate) {
        if (this.controller.getShelves().size() == 0) {
            return ItemStack.field_190927_a;
        }
        if (this.controller.func_145831_w() != null) {
            int slot = -1;
            EnderShelfItemHandler handler = null;
            for (BlockPos extractPos : this.controller.getShelves()) {
                TileEntity te = this.controller.func_145831_w().func_175625_s(extractPos);
                handler = EnderShelfHelper.getShelfHandler(te);
                if (handler == null || (slot = handler.firstSlotWithItem()) == -1) continue;
                break;
            }
            if (slot != -1) {
                return handler.extractItem(slot, amount, simulate);
            }
        }
        return ItemStack.field_190927_a;
    }
}

