/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.block.generatorpeat;

import com.lothrazar.cyclic.base.TileEntityBase;
import com.lothrazar.cyclic.block.generatorpeat.ContainerGenerator;
import com.lothrazar.cyclic.capability.CustomEnergyStorage;
import com.lothrazar.cyclic.item.PeatItem;
import com.lothrazar.cyclic.registry.TileRegistry;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public class TilePeatGenerator
extends TileEntityBase
implements ITickableTileEntity,
INamedContainerProvider {
    private static final int BURNTIME = 40;
    ItemStackHandler inventory = new ItemStackHandler(1);
    CustomEnergyStorage energy = new CustomEnergyStorage(64000, 32000);
    private LazyOptional<IEnergyStorage> energyCap = LazyOptional.of(() -> this.energy);
    private LazyOptional<IItemHandler> inventoryCap = LazyOptional.of(() -> this.inventory);
    private int flowing = 1;
    private int fuelRate = 0;

    public TilePeatGenerator() {
        super(TileRegistry.peat_generator);
        this.setNeedsRedstone(0);
    }

    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, Direction side) {
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.inventoryCap.cast();
        }
        if (cap == CapabilityEnergy.ENERGY) {
            return this.energyCap.cast();
        }
        return super.getCapability(cap, side);
    }

    @Override
    public void func_230337_a_(BlockState bs, CompoundNBT tag) {
        this.setFlowing(tag.func_74762_e("flowing"));
        this.fuelRate = tag.func_74762_e("fuelRate");
        this.energy.deserializeNBT(tag.func_74775_l("energy"));
        this.inventory.deserializeNBT(tag.func_74775_l("inv"));
        super.func_230337_a_(bs, tag);
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT tag) {
        tag.func_74768_a("flowing", this.getFlowing());
        tag.func_74768_a("fuelRate", this.fuelRate);
        tag.func_218657_a("energy", (INBT)this.energy.serializeNBT());
        tag.func_218657_a("inv", (INBT)this.inventory.serializeNBT());
        return super.func_189515_b(tag);
    }

    private boolean isBurning() {
        return this.timer > 0;
    }

    public void func_73660_a() {
        this.syncEnergy();
        if (this.requiresRedstone() && !this.isPowered()) {
            return;
        }
        if (this.isFull()) {
            this.tickCableFlow();
            return;
        }
        if (this.isBurning() && this.fuelRate > 0) {
            --this.timer;
            this.addEnergy(this.fuelRate);
            this.tickCableFlow();
            return;
        }
        this.fuelRate = 0;
        ItemStack stack = this.inventory.getStackInSlot(0);
        if (stack.func_77973_b() instanceof PeatItem) {
            PeatItem peat = (PeatItem)stack.func_77973_b();
            int futureValue = this.energy.getEnergyStored() + peat.getPeatFuelValue();
            if (futureValue < this.energy.getMaxEnergyStored()) {
                this.fuelRate = peat.getPeatFuelValue();
                this.inventory.extractItem(0, 1, false);
                this.timer = 40;
            }
        }
        this.tickCableFlow();
    }

    private void tickCableFlow() {
        if (this.getFlowing() == 1) {
            List rawList = IntStream.rangeClosed(0, 5).boxed().collect(Collectors.toList());
            Collections.shuffle(rawList);
            for (Integer i : rawList) {
                Direction exportToSide = Direction.values()[i];
                this.moveEnergy(exportToSide, 32000);
            }
        }
    }

    public boolean isFull() {
        return this.energy.getEnergyStored() >= this.energy.getMaxEnergyStored();
    }

    private void addEnergy(int i) {
        this.energy.addEnergy(i);
    }

    public int getBurnTime() {
        return this.timer;
    }

    public void setBurnTime(int value) {
        this.timer = value;
    }

    public ITextComponent func_145748_c_() {
        return new StringTextComponent(this.func_200662_C().getRegistryName().func_110623_a());
    }

    @Nullable
    public Container createMenu(int i, PlayerInventory playerInventory, PlayerEntity playerEntity) {
        return new ContainerGenerator(i, this.field_145850_b, this.field_174879_c, playerInventory, playerEntity);
    }

    public int getFlowing() {
        return this.flowing;
    }

    public void setFlowing(int flowing) {
        this.flowing = flowing;
    }

    @Override
    public void setField(int field, int value) {
        switch (Fields.values()[field]) {
            case FLOWING: {
                this.flowing = value;
                break;
            }
            case REDSTONE: {
                this.setNeedsRedstone(value);
                break;
            }
            case RENDER: {
                this.render = value % 2;
                break;
            }
            case BURNTIME: {
                this.setBurnTime(value);
                break;
            }
        }
    }

    @Override
    public int getField(int field) {
        switch (Fields.values()[field]) {
            case FLOWING: {
                return this.flowing;
            }
            case REDSTONE: {
                return this.needsRedstone;
            }
            case RENDER: {
                return this.render;
            }
            case BURNTIME: {
                return this.timer;
            }
        }
        return 0;
    }

    static enum Fields {
        FLOWING,
        REDSTONE,
        RENDER,
        BURNTIME;

    }
}

