/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.block.solidifier;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.lothrazar.cyclic.ModCyclic;
import com.lothrazar.cyclic.base.TileEntityBase;
import com.lothrazar.cyclic.block.solidifier.TileSolidifier;
import com.lothrazar.cyclic.recipe.CyclicRecipe;
import com.lothrazar.cyclic.recipe.CyclicRecipeType;
import com.lothrazar.cyclic.util.UtilItemStack;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.fluid.Fluid;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.ShapedRecipe;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class RecipeSolidifier<TileEntityBase>
extends CyclicRecipe {
    private static final Set<String> HASHES = new HashSet<String>();
    public static final Set<RecipeSolidifier<?>> RECIPES = new HashSet();
    private ItemStack result = ItemStack.field_190927_a;
    private NonNullList<Ingredient> ingredients = NonNullList.func_191196_a();
    private FluidStack fluidInput;
    public static final SerializeSolidifier SERIALIZER = new SerializeSolidifier();

    private RecipeSolidifier(ResourceLocation id, Ingredient in, Ingredient inSecond, Ingredient inThird, FluidStack fluid, ItemStack result) {
        super(id);
        this.result = result;
        this.fluidInput = fluid;
        this.ingredients.add((Object)in);
        this.ingredients.add((Object)inSecond);
        this.ingredients.add((Object)inThird);
    }

    public boolean matches(TileEntityBase inv, World worldIn) {
        try {
            TileSolidifier tile = (TileSolidifier)inv;
            if (tile.getFluid() != null && tile.getFluid().getFluid() == this.fluidInput.getFluid()) {
                return this.matches(tile, 0) && this.matches(tile, 1) && this.matches(tile, 2);
            }
            return false;
        }
        catch (ClassCastException e) {
            return false;
        }
    }

    public boolean matches(TileSolidifier tile, int slot) {
        ItemStack current = tile.getStackInputSlot(slot);
        Ingredient ing = (Ingredient)this.ingredients.get(slot);
        for (ItemStack test : ing.func_193365_a()) {
            if (!UtilItemStack.matches(current, test)) continue;
            return true;
        }
        return false;
    }

    public NonNullList<Ingredient> func_192400_c() {
        return this.ingredients;
    }

    public ItemStack[] ingredientAt(int slot) {
        Ingredient ing = (Ingredient)this.ingredients.get(slot);
        return ing.func_193365_a();
    }

    @Override
    public ItemStack func_77571_b() {
        return this.result.func_77946_l();
    }

    @Override
    public FluidStack getRecipeFluid() {
        return this.fluidInput.copy();
    }

    public IRecipeType<?> func_222127_g() {
        return CyclicRecipeType.SOLID;
    }

    @Override
    public IRecipeSerializer<?> func_199559_b() {
        return SERIALIZER;
    }

    private static void addRecipe(RecipeSolidifier<?> r) {
        ResourceLocation id = r.func_199560_c();
        if (HASHES.contains(id.toString())) {
            ModCyclic.LOGGER.info("Warn: Duplicate solidifier recipe id " + id.toString());
        } else {
            RECIPES.add(r);
            HASHES.add(id.toString());
            ModCyclic.LOGGER.info("Recipe loaded " + id.toString());
        }
    }

    public static class SerializeSolidifier
    extends ForgeRegistryEntry<IRecipeSerializer<?>>
    implements IRecipeSerializer<RecipeSolidifier<? extends TileEntityBase>> {
        SerializeSolidifier() {
            this.setRegistryName(new ResourceLocation("cyclic", "solidifier"));
        }

        public RecipeSolidifier<? extends TileEntityBase> read(ResourceLocation recipeId, JsonObject json) {
            RecipeSolidifier r = null;
            try {
                Ingredient inputFirst = Ingredient.func_199802_a((JsonElement)JSONUtils.func_152754_s((JsonObject)json, (String)"inputTop"));
                Ingredient inputSecond = Ingredient.func_199802_a((JsonElement)JSONUtils.func_152754_s((JsonObject)json, (String)"inputMiddle"));
                Ingredient inputThird = Ingredient.func_199802_a((JsonElement)JSONUtils.func_152754_s((JsonObject)json, (String)"inputBottom"));
                ItemStack resultStack = ShapedRecipe.func_199798_a((JsonObject)JSONUtils.func_152754_s((JsonObject)json, (String)"result"));
                JsonObject mix = json.get("mix").getAsJsonObject();
                int count = mix.get("count").getAsInt();
                String fluidId = JSONUtils.func_151200_h((JsonObject)mix, (String)"fluid");
                ResourceLocation resourceLocation = new ResourceLocation(fluidId);
                Fluid fluid = (Fluid)ForgeRegistries.FLUIDS.getValue(resourceLocation);
                if (fluid == FluidStack.EMPTY.getFluid()) {
                    throw new IllegalArgumentException("Invalid fluid specified " + fluidId);
                }
                r = new RecipeSolidifier(recipeId, inputFirst, inputSecond, inputThird, new FluidStack(fluid, count), resultStack);
                RecipeSolidifier.addRecipe(r);
            }
            catch (Exception e) {
                ModCyclic.LOGGER.error("Error loading recipe" + recipeId, e);
            }
            return r;
        }

        public RecipeSolidifier read(ResourceLocation recipeId, PacketBuffer buffer) {
            RecipeSolidifier r = new RecipeSolidifier(recipeId, Ingredient.func_199566_b((PacketBuffer)buffer), Ingredient.func_199566_b((PacketBuffer)buffer), Ingredient.func_199566_b((PacketBuffer)buffer), FluidStack.readFromPacket((PacketBuffer)buffer), buffer.func_150791_c());
            RecipeSolidifier.addRecipe(r);
            return r;
        }

        public void write(PacketBuffer buffer, RecipeSolidifier recipe) {
            Ingredient zero = (Ingredient)recipe.ingredients.get(0);
            Ingredient one = (Ingredient)recipe.ingredients.get(1);
            Ingredient two = (Ingredient)recipe.ingredients.get(2);
            zero.func_199564_a(buffer);
            one.func_199564_a(buffer);
            two.func_199564_a(buffer);
            recipe.fluidInput.writeToPacket(buffer);
            buffer.func_150788_a(recipe.func_77571_b());
        }
    }
}

