/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.block.solidifier;

import com.lothrazar.cyclic.base.FluidTankBase;
import com.lothrazar.cyclic.base.TileEntityBase;
import com.lothrazar.cyclic.block.solidifier.ContainerSolidifier;
import com.lothrazar.cyclic.block.solidifier.RecipeSolidifier;
import com.lothrazar.cyclic.capability.CustomEnergyStorage;
import com.lothrazar.cyclic.capability.ItemStackHandlerWrapper;
import com.lothrazar.cyclic.registry.TileRegistry;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public class TileSolidifier
extends TileEntityBase
implements ITickableTileEntity,
INamedContainerProvider {
    public static final int TIMER_FULL = 100;
    public static final int MAX = 64000;
    public static final int CAPACITY = 64000;
    public static final int TRANSFER_FLUID_PER_TICK = 50;
    public static ForgeConfigSpec.IntValue POWERCONF;
    private RecipeSolidifier currentRecipe;
    FluidTankBase tank;
    ItemStackHandler inputSlots = new ItemStackHandler(3);
    ItemStackHandler outputSlot = new ItemStackHandler(1);
    private ItemStackHandlerWrapper inventory = new ItemStackHandlerWrapper(this.inputSlots, this.outputSlot);
    private final LazyOptional<IItemHandler> inventoryCap = LazyOptional.of(() -> this.inventory);
    CustomEnergyStorage energy = new CustomEnergyStorage(64000, 64000);
    private final LazyOptional<FluidTankBase> tankWrapper = LazyOptional.of(() -> this.tank);
    private final LazyOptional<IEnergyStorage> energyCap = LazyOptional.of(() -> this.energy);

    public TileSolidifier() {
        super(TileRegistry.solidifier);
        this.tank = new FluidTankBase(this, 64000, p -> true);
    }

    public void func_73660_a() {
        this.syncEnergy();
        this.findMatchingRecipe();
        if (this.currentRecipe == null) {
            return;
        }
        --this.timer;
        if (this.timer < 0) {
            this.timer = 0;
        }
        int cost = (Integer)POWERCONF.get();
        if (this.energy.getEnergyStored() < cost && cost > 0) {
            return;
        }
        if (this.timer == 0 && this.tryProcessRecipe()) {
            this.timer = 100;
            this.energy.extractEnergy(cost, false);
        }
    }

    @Override
    public void setField(int field, int value) {
        switch (Fields.values()[field]) {
            case TIMER: {
                this.timer = value;
                break;
            }
            case REDSTONE: {
                this.needsRedstone = value % 2;
                break;
            }
            case RENDER: {
                this.render = value % 2;
            }
        }
    }

    @Override
    public int getField(int field) {
        switch (Fields.values()[field]) {
            case TIMER: {
                return this.timer;
            }
            case REDSTONE: {
                return this.needsRedstone;
            }
            case RENDER: {
                return this.render;
            }
        }
        return 0;
    }

    public ITextComponent func_145748_c_() {
        return new StringTextComponent(this.func_200662_C().getRegistryName().func_110623_a());
    }

    @Nullable
    public Container createMenu(int i, PlayerInventory playerInventory, PlayerEntity playerEntity) {
        return new ContainerSolidifier(i, this.field_145850_b, this.field_174879_c, playerInventory, playerEntity);
    }

    @Override
    public void func_230337_a_(BlockState bs, CompoundNBT tag) {
        this.tank.readFromNBT(tag.func_74775_l("fluid"));
        this.energy.deserializeNBT(tag.func_74775_l("energy"));
        this.inputSlots.deserializeNBT(tag.func_74775_l("inv"));
        this.outputSlot.deserializeNBT(tag.func_74775_l("invoutput"));
        super.func_230337_a_(bs, tag);
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT tag) {
        CompoundNBT fluid = new CompoundNBT();
        this.tank.writeToNBT(fluid);
        tag.func_218657_a("fluid", (INBT)fluid);
        tag.func_218657_a("energy", (INBT)this.energy.serializeNBT());
        tag.func_218657_a("inv", (INBT)this.inputSlots.serializeNBT());
        tag.func_218657_a("invoutput", (INBT)this.outputSlot.serializeNBT());
        return super.func_189515_b(tag);
    }

    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, Direction side) {
        if (cap == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return this.tankWrapper.cast();
        }
        if (cap == CapabilityEnergy.ENERGY && (Integer)POWERCONF.get() > 0) {
            return this.energyCap.cast();
        }
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.inventoryCap.cast();
        }
        return super.getCapability(cap, side);
    }

    public FluidStack getFluid() {
        return this.tank == null ? FluidStack.EMPTY : this.tank.getFluid();
    }

    public float getCapacity() {
        return 64000.0f;
    }

    @Override
    public void setFluid(FluidStack fluid) {
        this.tank.setFluid(fluid);
    }

    private void findMatchingRecipe() {
        if (this.currentRecipe != null && this.currentRecipe.matches((TileEntityBase)this, this.field_145850_b)) {
            return;
        }
        this.currentRecipe = null;
        for (RecipeSolidifier<?> rec : RecipeSolidifier.RECIPES) {
            if (!rec.matches((TileEntityBase)this, this.field_145850_b)) continue;
            this.currentRecipe = rec;
            break;
        }
    }

    private boolean tryProcessRecipe() {
        FluidStack test = this.tank.drain(this.currentRecipe.getRecipeFluid(), IFluidHandler.FluidAction.SIMULATE);
        if (test.getAmount() == this.currentRecipe.getRecipeFluid().getAmount()) {
            if (!this.outputSlot.insertItem(0, this.currentRecipe.func_77571_b(), true).func_190926_b()) {
                return false;
            }
            this.inputSlots.getStackInSlot(0).func_190918_g(1);
            this.inputSlots.getStackInSlot(1).func_190918_g(1);
            this.inputSlots.getStackInSlot(2).func_190918_g(1);
            this.tank.drain(this.currentRecipe.getRecipeFluid(), IFluidHandler.FluidAction.EXECUTE);
            this.outputSlot.insertItem(0, this.currentRecipe.func_77571_b(), false);
            return true;
        }
        return false;
    }

    public ItemStack getStackInputSlot(int slot) {
        return this.inputSlots.getStackInSlot(slot);
    }

    static enum Fields {
        REDSTONE,
        TIMER,
        RENDER;

    }
}

