/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.block.tank;

import com.lothrazar.cyclic.block.tank.TileTank;
import com.lothrazar.cyclic.render.FluidTankRenderType;
import com.lothrazar.cyclic.util.UtilFluid;
import com.lothrazar.cyclic.util.UtilRender;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;

@OnlyIn(value=Dist.CLIENT)
public class RenderTank
extends TileEntityRenderer<TileTank> {
    public RenderTank(TileEntityRendererDispatcher d) {
        super(d);
    }

    public void render(TileTank tankHere, float v, MatrixStack matrix, IRenderTypeBuffer renderer, int light, int overlayLight) {
        IFluidHandler handler = (IFluidHandler)tankHere.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, null).orElse(null);
        if (handler == null || handler.getFluidInTank(0) == null) {
            return;
        }
        FluidStack fluid = handler.getFluidInTank(0);
        if (fluid.isEmpty()) {
            return;
        }
        IVertexBuilder buffer = renderer.getBuffer(FluidTankRenderType.resizableCuboid());
        matrix.func_227862_a_(1.0f, UtilFluid.getScale(tankHere.tank), 1.0f);
        UtilRender.renderObject(UtilFluid.getFluidModel(fluid, 1399), matrix, buffer, UtilRender.getColorARGB(fluid, 0.1f), UtilRender.calculateGlowLight(light, fluid));
    }
}

