/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.block.tankcask;

import com.lothrazar.cyclic.base.FluidTankBase;
import com.lothrazar.cyclic.base.TileEntityBase;
import com.lothrazar.cyclic.registry.TileRegistry;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.annotation.Nonnull;
import net.minecraft.block.BlockState;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.util.Direction;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class TileCask
extends TileEntityBase
implements ITickableTileEntity {
    private Map<Direction, Boolean> poweredSides;
    public static final int CAPACITY = 8000;
    public static final int TRANSFER_FLUID_PER_TICK = 4000;
    public FluidTankBase tank;
    private int flowing = 0;
    private List<Integer> rawList = IntStream.rangeClosed(0, 5).boxed().collect(Collectors.toList());

    public TileCask() {
        super(TileRegistry.cask);
        this.tank = new FluidTankBase(this, 8000, this.isFluidValid());
        this.poweredSides = new HashMap<Direction, Boolean>();
        for (Direction f : Direction.values()) {
            this.poweredSides.put(f, false);
        }
    }

    public Predicate<FluidStack> isFluidValid() {
        return p -> true;
    }

    @Override
    public void func_230337_a_(BlockState bs, CompoundNBT tag) {
        for (Direction f : Direction.values()) {
            this.poweredSides.put(f, tag.func_74767_n("flow_" + f.func_176742_j()));
        }
        this.flowing = tag.func_74762_e("flowing");
        this.tank.readFromNBT(tag.func_74775_l("fluid"));
        super.func_230337_a_(bs, tag);
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT tag) {
        for (Direction f : Direction.values()) {
            tag.func_74757_a("flow_" + f.func_176742_j(), this.poweredSides.get(f).booleanValue());
        }
        tag.func_74768_a("flowing", this.flowing);
        CompoundNBT fluid = new CompoundNBT();
        this.tank.writeToNBT(fluid);
        tag.func_218657_a("fluid", (INBT)fluid);
        return super.func_189515_b(tag);
    }

    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, Direction side) {
        if (cap == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return LazyOptional.of(() -> this.tank).cast();
        }
        return super.getCapability(cap, side);
    }

    @Override
    public int getField(int id) {
        switch (Fields.values()[id]) {
            case D: {
                return this.getSideField(Direction.DOWN);
            }
            case E: {
                return this.getSideField(Direction.EAST);
            }
            case N: {
                return this.getSideField(Direction.NORTH);
            }
            case S: {
                return this.getSideField(Direction.SOUTH);
            }
            case U: {
                return this.getSideField(Direction.UP);
            }
            case W: {
                return this.getSideField(Direction.WEST);
            }
            case FLOWING: {
                return this.flowing;
            }
        }
        return -1;
    }

    @Override
    public void setField(int field, int value) {
        switch (Fields.values()[field]) {
            case FLOWING: {
                this.flowing = value;
                break;
            }
            case D: {
                this.setSideField(Direction.DOWN, value % 2);
                break;
            }
            case E: {
                this.setSideField(Direction.EAST, value % 2);
                break;
            }
            case N: {
                this.setSideField(Direction.NORTH, value % 2);
                break;
            }
            case S: {
                this.setSideField(Direction.SOUTH, value % 2);
                break;
            }
            case U: {
                this.setSideField(Direction.UP, value % 2);
                break;
            }
            case W: {
                this.setSideField(Direction.WEST, value % 2);
            }
        }
    }

    public boolean getSideHasPower(Direction side) {
        return this.poweredSides.get(side);
    }

    public int getSideField(Direction side) {
        return this.getSideHasPower(side) ? 1 : 0;
    }

    public void setSideField(Direction side, int pow) {
        this.poweredSides.put(side, pow == 1);
    }

    @Override
    public void setFluid(FluidStack fluid) {
        this.tank.setFluid(fluid);
    }

    public void func_73660_a() {
        if (this.flowing > 0) {
            this.tickCableFlow();
        }
    }

    private void tickCableFlow() {
        Collections.shuffle(this.rawList);
        for (Integer i : this.rawList) {
            Direction exportToSide = Direction.values()[i];
            if (!this.poweredSides.get(exportToSide).booleanValue()) continue;
            this.moveFluids(exportToSide, 1000, (IFluidHandler)this.tank);
        }
    }

    static enum Fields {
        FLOWING,
        N,
        E,
        S,
        W,
        U,
        D;

    }
}

