/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.enchant;

import com.google.gson.JsonObject;
import com.lothrazar.cyclic.base.EnchantBase;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentType;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Inventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipe;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.conditions.ILootCondition;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.loot.GlobalLootModifierSerializer;
import net.minecraftforge.common.loot.LootModifier;
import net.minecraftforge.items.ItemHandlerHelper;

public class EnchantAutoSmelt
extends EnchantBase {
    public static final String ID = "auto_smelt";
    public static ForgeConfigSpec.BooleanValue CFG;

    public EnchantAutoSmelt(Enchantment.Rarity rarityIn, EnchantmentType typeIn, EquipmentSlotType ... slots) {
        super(rarityIn, typeIn, slots);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @Override
    public boolean isEnabled() {
        return (Boolean)CFG.get();
    }

    public int func_77325_b() {
        return 1;
    }

    public boolean func_77326_a(Enchantment ench) {
        return ench != Enchantments.field_185306_r && ench != Enchantments.field_185308_t && super.func_77326_a(ench);
    }

    public static class Serializer
    extends GlobalLootModifierSerializer<EnchantAutoSmeltModifier> {
        public EnchantAutoSmeltModifier read(ResourceLocation name, JsonObject json, ILootCondition[] conditionsIn) {
            return new EnchantAutoSmeltModifier(conditionsIn);
        }

        public JsonObject write(EnchantAutoSmeltModifier instance) {
            return null;
        }
    }

    private static class EnchantAutoSmeltModifier
    extends LootModifier {
        public EnchantAutoSmeltModifier(ILootCondition[] conditionsIn) {
            super(conditionsIn);
        }

        @Nonnull
        public List<ItemStack> doApply(List<ItemStack> originalLoot, LootContext context) {
            ArrayList<ItemStack> newLoot = new ArrayList<ItemStack>();
            originalLoot.forEach(stack -> {
                Optional optional = context.func_202879_g().func_199532_z().func_215371_a(IRecipeType.field_222150_b, (IInventory)new Inventory(new ItemStack[]{stack}), (World)context.func_202879_g());
                if (optional.isPresent()) {
                    ItemStack smeltedItemStack = ((FurnaceRecipe)optional.get()).func_77571_b();
                    if (!smeltedItemStack.func_190926_b()) {
                        smeltedItemStack = ItemHandlerHelper.copyStackWithSize((ItemStack)smeltedItemStack, (int)(stack.func_190916_E() * smeltedItemStack.func_190916_E()));
                        newLoot.add(smeltedItemStack);
                    } else {
                        newLoot.add((ItemStack)stack);
                    }
                } else {
                    newLoot.add((ItemStack)stack);
                }
            });
            return newLoot;
        }
    }
}

