/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.event;

import com.lothrazar.cyclic.base.ItemEntityInteractable;
import com.lothrazar.cyclic.block.cable.CableWrench;
import com.lothrazar.cyclic.block.cable.WrenchActionType;
import com.lothrazar.cyclic.block.scaffolding.ItemScaffolding;
import com.lothrazar.cyclic.item.AntimatterEvaporatorWandItem;
import com.lothrazar.cyclic.item.builder.BuilderActionType;
import com.lothrazar.cyclic.item.builder.BuilderItem;
import com.lothrazar.cyclic.item.carrot.ItemHorseEnder;
import com.lothrazar.cyclic.item.datacard.ShapeCard;
import com.lothrazar.cyclic.item.heart.HeartItem;
import com.lothrazar.cyclic.item.storagebag.StorageBagItem;
import com.lothrazar.cyclic.registry.BlockRegistry;
import com.lothrazar.cyclic.registry.PotionRegistry;
import com.lothrazar.cyclic.registry.SoundRegistry;
import com.lothrazar.cyclic.util.UtilChat;
import com.lothrazar.cyclic.util.UtilItemStack;
import com.lothrazar.cyclic.util.UtilSound;
import com.lothrazar.cyclic.util.UtilWorld;
import java.util.Set;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.attributes.ModifiableAttributeInstance;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.player.BonemealEvent;
import net.minecraftforge.event.entity.player.EntityItemPickupEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.entity.player.SleepingLocationCheckEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class ItemEvents {
    @SubscribeEvent
    public void onPlayerCloneDeath(PlayerEvent.Clone event) {
        AttributeModifier healthModifier;
        ModifiableAttributeInstance original = event.getOriginal().func_110148_a(Attributes.field_233818_a_);
        if (original != null && (healthModifier = original.func_111127_a(HeartItem.ID)) != null) {
            event.getPlayer().func_110148_a(Attributes.field_233818_a_).func_233769_c_(healthModifier);
        }
    }

    @SubscribeEvent
    public void onEntityUpdate(LivingEvent.LivingUpdateEvent event) {
        LivingEntity liv = event.getEntityLiving();
        if (liv.getPersistentData().func_74764_b("cyclic_carrot_ender") && liv.getPersistentData().func_74762_e("cyclic_carrot_ender") > 0) {
            if (liv.func_70090_H() && !liv.func_70648_aU() && liv.func_70086_ai() < liv.func_205010_bg() && !liv.func_70644_a(Effects.field_76427_o)) {
                liv.func_195064_c(new EffectInstance(Effects.field_76427_o, 1200, 4));
                liv.func_195064_c(new EffectInstance((Effect)PotionRegistry.PotionEffects.swimspeed, 1200, 1));
                ItemHorseEnder.onSuccess(liv);
            }
            if (liv.func_70027_ad() && !liv.func_70644_a(Effects.field_76426_n)) {
                liv.func_195064_c(new EffectInstance(Effects.field_76426_n, 1200, 4));
                liv.func_70066_B();
                ItemHorseEnder.onSuccess(liv);
            }
            if (liv.field_70143_R > 12.0f && !liv.func_70644_a(Effects.field_204839_B)) {
                liv.func_195064_c(new EffectInstance(Effects.field_204839_B, 1200, 4));
                ItemHorseEnder.onSuccess(liv);
            }
            if (liv.func_110143_aJ() < 6.0f && !liv.func_70644_a(Effects.field_76444_x)) {
                liv.func_195064_c(new EffectInstance(Effects.field_76444_x, 1200, 4));
                liv.func_195064_c(new EffectInstance(Effects.field_76429_m, 1200, 4));
                ItemHorseEnder.onSuccess(liv);
            }
        }
    }

    @SubscribeEvent
    public void onBonemealEvent(BonemealEvent event) {
        BlockPos pos;
        World world = event.getWorld();
        if (world.func_180495_p(pos = event.getPos()).func_177230_c() == Blocks.field_196661_l && world.func_175623_d(pos.func_177984_a())) {
            world.func_175656_a(pos.func_177984_a(), BlockRegistry.flower_cyan.func_176223_P());
            event.setResult(Event.Result.ALLOW);
        } else if (world.func_180495_p(pos).func_177230_c() == BlockRegistry.flower_cyan) {
            event.setResult(Event.Result.ALLOW);
            if (world.field_73012_v.nextDouble() < 0.5) {
                UtilItemStack.drop(world, pos, new ItemStack((IItemProvider)BlockRegistry.flower_cyan));
            }
        }
    }

    @SubscribeEvent
    public void onBedCheck(SleepingLocationCheckEvent event) {
        PlayerEntity p;
        if (event.getEntity() instanceof PlayerEntity && (p = (PlayerEntity)event.getEntity()).getPersistentData().func_74767_n("cyclic_sleeping")) {
            event.setResult(Event.Result.ALLOW);
        }
    }

    @SubscribeEvent
    public void onRightClickBlock(PlayerInteractEvent.RightClickBlock event) {
        if (event.getItemStack().func_190926_b()) {
            return;
        }
        if (event.getItemStack().func_77973_b() instanceof ItemScaffolding && event.getPlayer().func_213453_ef()) {
            this.scaffoldHit(event);
        }
    }

    private void scaffoldHit(PlayerInteractEvent.RightClickBlock event) {
        ItemScaffolding item = (ItemScaffolding)event.getItemStack().func_77973_b();
        Direction opp = event.getFace().func_176734_d();
        BlockPos dest = UtilWorld.nextReplaceableInDirection(event.getWorld(), event.getPos(), opp, 16, item.func_179223_d());
        if (event.getWorld().func_175623_d(dest)) {
            event.getWorld().func_175656_a(dest, item.func_179223_d().func_176223_P());
            ItemStack stac = event.getPlayer().func_184586_b(event.getHand());
            UtilItemStack.shrink(event.getPlayer(), stac);
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onEntityInteractEvent(PlayerInteractEvent.EntityInteract event) {
        if (event.getItemStack().func_77973_b() instanceof ItemEntityInteractable) {
            ItemEntityInteractable item = (ItemEntityInteractable)event.getItemStack().func_77973_b();
            item.interactWith(event);
        }
    }

    @SubscribeEvent
    public void onHit(PlayerInteractEvent.LeftClickBlock event) {
        BlockState target;
        PlayerEntity player = event.getPlayer();
        ItemStack held = player.func_184586_b(event.getHand());
        if (held.func_190926_b()) {
            return;
        }
        World world = player.func_130014_f_();
        if (held.func_77973_b() instanceof ShapeCard && player.func_213453_ef()) {
            target = world.func_180495_p(event.getPos());
            ShapeCard.setBlockState(held, target);
            UtilChat.sendStatusMessage(player, target.func_177230_c().func_149739_a());
        }
        if (held.func_77973_b() instanceof BuilderItem) {
            if (BuilderActionType.getTimeout(held) > 0) {
                return;
            }
            BuilderActionType.setTimeout(held);
            event.setCanceled(true);
            if (player.func_213453_ef()) {
                target = world.func_180495_p(event.getPos());
                BuilderActionType.setBlockState(held, target);
                UtilChat.sendStatusMessage(player, target.func_177230_c().func_149739_a());
            } else {
                if (!world.field_72995_K) {
                    BuilderActionType.toggle(held);
                }
                UtilSound.playSound((LivingEntity)player, SoundRegistry.tool_mode);
                UtilChat.sendStatusMessage(player, UtilChat.lang(BuilderActionType.getName(held)));
            }
        }
        if (held.func_77973_b() instanceof CableWrench && WrenchActionType.getTimeout(held) == 0) {
            if (!world.field_72995_K) {
                WrenchActionType.toggle(held);
            }
            UtilSound.playSound((LivingEntity)player, SoundRegistry.tool_mode);
            WrenchActionType.setTimeout(held);
            UtilChat.sendStatusMessage(player, UtilChat.lang(WrenchActionType.getName(held)));
        }
        if (held.func_77973_b() instanceof AntimatterEvaporatorWandItem) {
            AntimatterEvaporatorWandItem.toggleMode(player, held);
        }
    }

    @SubscribeEvent
    public void onPlayerPickup(EntityItemPickupEvent event) {
        if (event.getEntityLiving() instanceof PlayerEntity) {
            PlayerEntity player = (PlayerEntity)event.getEntityLiving();
            ItemStack stack = event.getItem().func_92059_d();
            ItemStack resultStack = stack.func_77946_l();
            Set<Integer> bagSlots = StorageBagItem.getAllBagSlots(player);
            for (Integer i : bagSlots) {
                ItemStack bag = player.field_71071_by.func_70301_a(i.intValue());
                switch (StorageBagItem.getPickupMode(bag)) {
                    case EVERYTHING: {
                        resultStack = StorageBagItem.tryInsert(bag, resultStack);
                        break;
                    }
                    case FILTER: {
                        resultStack = StorageBagItem.tryFilteredInsert(bag, resultStack);
                        break;
                    }
                }
                if (resultStack != ItemStack.field_190927_a) continue;
                break;
            }
            if (resultStack != null) {
                event.getItem().func_92058_a(resultStack);
            }
            if (resultStack != null && resultStack.func_190916_E() != stack.func_190916_E()) {
                event.setResult(Event.Result.ALLOW);
            } else {
                event.setResult(Event.Result.DEFAULT);
            }
        }
    }
}

