/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.item.builder;

import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.NBTUtil;

public enum BuilderActionType {
    SINGLE,
    X3,
    X5,
    X7,
    X9,
    X91,
    X19;

    public static final String NBTBLOCKSTATE = "blockstate";
    private static final String NBT = "ActionType";
    private static final String NBTTIMEOUT = "timeout";

    public static int getTimeout(ItemStack wand) {
        return wand.func_196082_o().func_74762_e(NBTTIMEOUT);
    }

    public static void setTimeout(ItemStack wand) {
        wand.func_196082_o().func_74768_a(NBTTIMEOUT, 15);
    }

    public static void tickTimeout(ItemStack wand) {
        CompoundNBT tags = wand.func_196082_o();
        int t = tags.func_74762_e(NBTTIMEOUT);
        if (t > 0) {
            wand.func_196082_o().func_74768_a(NBTTIMEOUT, t - 1);
        }
    }

    public static int get(ItemStack wand) {
        if (wand.func_190926_b()) {
            return 0;
        }
        CompoundNBT tags = wand.func_196082_o();
        return tags.func_74762_e(NBT);
    }

    public static String getName(ItemStack wand) {
        try {
            CompoundNBT tags = wand.func_196082_o();
            return "tool.action." + BuilderActionType.values()[tags.func_74762_e(NBT)].toString().toLowerCase();
        }
        catch (Exception e) {
            return "tool.action." + SINGLE.toString().toLowerCase();
        }
    }

    public static void toggle(ItemStack wand) {
        CompoundNBT tags = wand.func_196082_o();
        int type = tags.func_74762_e(NBT);
        if (++type >= BuilderActionType.values().length) {
            type = SINGLE.ordinal();
        }
        tags.func_74768_a(NBT, type);
        wand.func_77982_d(tags);
    }

    public static void setBlockState(ItemStack wand, BlockState target) {
        CompoundNBT encoded = NBTUtil.func_190009_a((BlockState)target);
        wand.func_196082_o().func_218657_a(NBTBLOCKSTATE, (INBT)encoded);
    }

    @Nullable
    public static BlockState getBlockState(ItemStack wand) {
        if (!wand.func_196082_o().func_74764_b(NBTBLOCKSTATE)) {
            return null;
        }
        return NBTUtil.func_190008_d((CompoundNBT)wand.func_196082_o().func_74775_l(NBTBLOCKSTATE));
    }
}

