/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.item.equipment;

import com.lothrazar.cyclic.base.IHasClickToggle;
import com.lothrazar.cyclic.util.UtilChat;
import com.lothrazar.cyclic.util.UtilNBT;
import com.lothrazar.cyclic.util.UtilPlayer;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ArmorItem;
import net.minecraft.item.IArmorMaterial;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class GlowingHelmetItem
extends ArmorItem
implements IHasClickToggle {
    public static final String NBT_GLOW = "cyclicmagic_glow";
    public static final String NBT_STATUS = "onoff";

    public GlowingHelmetItem(IArmorMaterial materialIn, EquipmentSlotType slot, Item.Properties builderIn) {
        super(materialIn, slot, builderIn);
    }

    public void onArmorTick(ItemStack stack, World world, PlayerEntity player) {
        boolean isTurnedOn = this.isOn(stack);
        GlowingHelmetItem.removeNightVision(player, isTurnedOn);
        if (isTurnedOn) {
            this.addNightVision(player);
        }
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        tooltip.add((ITextComponent)new TranslationTextComponent(UtilChat.lang(this.func_77658_a() + ".tooltip")));
        String onoff = this.isOn(stack) ? "on" : "off";
        TranslationTextComponent t = new TranslationTextComponent(UtilChat.lang("item.cantoggle.tooltip.info") + " " + UtilChat.lang("item.cantoggle.tooltip." + onoff));
        t.func_240699_a_(TextFormatting.DARK_GRAY);
        tooltip.add((ITextComponent)t);
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
    }

    private void addNightVision(PlayerEntity player) {
        player.func_195064_c(new EffectInstance(Effects.field_76439_r, 400, 0));
    }

    public static void removeNightVision(PlayerEntity player, boolean hidden) {
        player.getPersistentData().func_74757_a(NBT_GLOW, hidden);
        player.func_184596_c(Effects.field_76439_r);
    }

    private void checkIfHelmOff(PlayerEntity player) {
        Item itemInSlot = UtilPlayer.getItemArmorSlot(player, EquipmentSlotType.HEAD);
        if (itemInSlot == this) {
            GlowingHelmetItem.removeNightVision(player, false);
        }
    }

    @Override
    public void toggle(PlayerEntity player, ItemStack held) {
        CompoundNBT tags = UtilNBT.getItemStackNBT(held);
        int vnew = this.isOn(held) ? 0 : 1;
        tags.func_74768_a(NBT_STATUS, vnew);
    }

    @Override
    public boolean isOn(ItemStack held) {
        CompoundNBT tags = UtilNBT.getItemStackNBT(held);
        if (!tags.func_74764_b(NBT_STATUS)) {
            return true;
        }
        return tags.func_74762_e(NBT_STATUS) == 1;
    }

    @SubscribeEvent
    public void onEntityUpdate(LivingEvent.LivingUpdateEvent event) {
        if (event.getEntity().field_70170_p.func_82737_E() % 20L == 0L && event.getEntityLiving() != null) {
            PlayerEntity player = (PlayerEntity)event.getEntityLiving();
            this.checkIfHelmOff(player);
        }
    }
}

