/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.item.transporter;

import com.lothrazar.cyclic.base.ItemBase;
import com.lothrazar.cyclic.item.transporter.PacketChestSack;
import com.lothrazar.cyclic.registry.ItemRegistry;
import com.lothrazar.cyclic.registry.PacketRegistry;
import com.lothrazar.cyclic.util.UtilChat;
import com.lothrazar.cyclic.util.UtilItemStack;
import com.lothrazar.cyclic.util.UtilPlaceBlocks;
import com.lothrazar.cyclic.util.UtilSound;
import com.lothrazar.cyclic.util.UtilString;
import java.util.List;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeConfigSpec;

public class TileTransporterEmptyItem
extends ItemBase {
    public static ForgeConfigSpec.ConfigValue<List<String>> IGNORELIST;

    public TileTransporterEmptyItem(Item.Properties prop) {
        super(prop);
    }

    public ActionResultType func_195939_a(ItemUseContext context) {
        PlayerEntity player = context.func_195999_j();
        BlockPos pos = context.func_195995_a();
        World world = context.func_195991_k();
        TileEntity tile = world.func_175625_s(pos);
        BlockState state = world.func_180495_p(pos);
        if (state == null || tile == null || state.func_177230_c() == null || state.func_177230_c().getRegistryName() == null) {
            UtilChat.sendStatusMessage(player, "chest_sack.error.null");
            return ActionResultType.FAIL;
        }
        ResourceLocation blockId = state.func_177230_c().getRegistryName();
        if (UtilString.isInList((List)IGNORELIST.get(), blockId)) {
            UtilChat.sendStatusMessage(player, "chest_sack.error.config");
            return ActionResultType.FAIL;
        }
        UtilSound.playSound((Entity)player, pos, SoundEvents.field_187686_e);
        if (world.field_72995_K) {
            PacketRegistry.INSTANCE.sendToServer((Object)new PacketChestSack(pos));
        }
        return ActionResultType.SUCCESS;
    }

    public static void gatherTileEntity(BlockPos pos, PlayerEntity player, World world, TileEntity tile) {
        if (tile == null) {
            return;
        }
        BlockState state = world.func_180495_p(pos);
        if (state.func_185903_a(player, (IBlockReader)world, pos) <= 0.0f) {
            return;
        }
        CompoundNBT tileData = new CompoundNBT();
        tile.func_189515_b(tileData);
        CompoundNBT itemData = new CompoundNBT();
        itemData.func_74778_a("blockname", state.func_177230_c().func_149739_a());
        itemData.func_218657_a("tile", (INBT)tileData);
        itemData.func_74778_a("block", state.func_177230_c().getRegistryName().toString());
        itemData.func_218657_a("blockstate", (INBT)NBTUtil.func_190009_a((BlockState)state));
        Hand hand = Hand.MAIN_HAND;
        ItemStack held = player.func_184586_b(hand);
        if (held == null || !(held.func_77973_b() instanceof TileTransporterEmptyItem)) {
            hand = Hand.OFF_HAND;
            held = player.func_184586_b(hand);
        }
        if (held != null && held.func_190916_E() > 0 && held.func_77973_b() instanceof TileTransporterEmptyItem) {
            if (!UtilPlaceBlocks.destroyBlock(world, pos)) {
                UtilChat.sendStatusMessage(player, "chest_sack.error.pickup");
                world.func_175656_a(pos, state);
                return;
            }
            ItemStack drop = new ItemStack((IItemProvider)ItemRegistry.tile_transporter);
            drop.func_77982_d(itemData);
            UtilItemStack.drop(world, player.func_233580_cy_(), drop);
            if (!player.func_184812_l_() && held.func_190916_E() > 0) {
                held.func_190918_g(1);
                if (held.func_190916_E() == 0) {
                    held = ItemStack.field_190927_a;
                    player.func_184611_a(hand, ItemStack.field_190927_a);
                }
            }
        }
    }
}

