/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.net;

import com.lothrazar.cyclic.base.PacketBase;
import com.lothrazar.cyclic.data.CraftingActionEnum;
import com.lothrazar.cyclic.data.IContainerCraftingAction;
import java.util.HashSet;
import java.util.Iterator;
import java.util.function.Supplier;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.IItemProvider;
import net.minecraftforge.fml.network.NetworkEvent;

public class PacketCraftAction
extends PacketBase {
    private CraftingActionEnum action;

    public PacketCraftAction(CraftingActionEnum s) {
        this.action = s;
    }

    public static PacketCraftAction decode(PacketBuffer buf) {
        return new PacketCraftAction(CraftingActionEnum.values()[buf.readInt()]);
    }

    public static void encode(PacketCraftAction msg, PacketBuffer buf) {
        buf.writeInt(msg.action.ordinal());
    }

    public static void handle(PacketCraftAction message, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerPlayerEntity sender = ((NetworkEvent.Context)ctx.get()).getSender();
            if (sender.field_71070_bA instanceof IContainerCraftingAction) {
                IContainerCraftingAction c = (IContainerCraftingAction)sender.field_71070_bA;
                PacketCraftAction.performAction(c, (PlayerEntity)sender, message.action);
            }
        });
        message.done(ctx);
    }

    private static void performAction(IContainerCraftingAction c, PlayerEntity player, CraftingActionEnum action) {
        switch (action) {
            case EMPTY: {
                for (int i = 1; i <= 9; ++i) {
                    c.transferStack(player, i);
                }
                c.getCraftResult().func_174888_l();
                break;
            }
            case SPREAD: {
                PacketCraftAction.balanceLargestSlot(c, false);
                break;
            }
            case SPREADMATCH: {
                PacketCraftAction.balanceLargestSlot(c, true);
            }
        }
    }

    private static void balanceLargestSlot(IContainerCraftingAction c, boolean onlyExisting) {
        ItemStack biggest = ItemStack.field_190927_a;
        int foundSlot = -1;
        for (int i = 0; i <= 8; ++i) {
            ItemStack tmp = c.getCraftMatrix().func_70301_a(i);
            if (tmp.func_190926_b() || tmp.func_190916_E() <= biggest.func_190916_E()) continue;
            foundSlot = i;
            biggest = tmp;
        }
        if (biggest.func_190926_b()) {
            return;
        }
        HashSet<Integer> slotTargest = new HashSet<Integer>();
        int totalQuantity = 0;
        for (int i = 0; i <= 8; ++i) {
            ItemStack tmp = c.getCraftMatrix().func_70301_a(i);
            if (tmp.func_190926_b() && !onlyExisting) {
                slotTargest.add(i);
            }
            if (!Container.func_195929_a((ItemStack)tmp, (ItemStack)biggest)) continue;
            slotTargest.add(i);
            totalQuantity += tmp.func_190916_E();
        }
        int slotsUsedForBalancing = slotTargest.size();
        int avg = totalQuantity / slotsUsedForBalancing;
        int remainder = totalQuantity % slotsUsedForBalancing;
        if (avg == 0) {
            return;
        }
        Iterator iterator = slotTargest.iterator();
        while (iterator.hasNext()) {
            int slot = (Integer)iterator.next();
            int size = slot == foundSlot ? avg + remainder : avg;
            c.getCraftMatrix().func_70299_a(slot, new ItemStack((IItemProvider)biggest.func_77973_b(), size));
        }
    }
}

