/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.mysticalagriculture.block;

import com.blakebr0.mysticalagriculture.lib.ModTooltips;
import com.blakebr0.mysticalagriculture.tileentity.EssenceFurnaceTileEntity;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.AbstractFurnaceBlock;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.Stats;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class EssenceFurnaceBlock
extends AbstractFurnaceBlock {
    private final FurnaceTier tier;

    public EssenceFurnaceBlock(FurnaceTier tier) {
        super(AbstractBlock.Properties.func_200950_a((AbstractBlock)Blocks.field_150460_al));
        this.tier = tier;
    }

    protected void func_220089_a(World world, BlockPos pos, PlayerEntity player) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof EssenceFurnaceTileEntity) {
            player.func_213829_a((INamedContainerProvider)((EssenceFurnaceTileEntity)tile));
            player.func_195066_a(Stats.field_188061_aa);
        }
    }

    public TileEntity func_196283_a_(IBlockReader world) {
        return this.tier.getNewTileEntity();
    }

    public void func_180633_a(World world, BlockPos pos, BlockState state, LivingEntity entity, ItemStack stack) {
    }

    public void func_196243_a(BlockState state, World world, BlockPos pos, BlockState newState, boolean isMoving) {
        TileEntity tile;
        if (state.func_177230_c() != newState.func_177230_c() && (tile = world.func_175625_s(pos)) instanceof EssenceFurnaceTileEntity) {
            EssenceFurnaceTileEntity furnace = (EssenceFurnaceTileEntity)tile;
            InventoryHelper.func_180175_a((World)world, (BlockPos)pos, (IInventory)furnace);
        }
        super.func_196243_a(state, world, pos, newState, isMoving);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_190948_a(ItemStack stack, IBlockReader world, List<ITextComponent> tooltip, ITooltipFlag flag) {
        double cookingSpeedDifference = 200.0 * this.tier.getCookTimeMultiplier();
        double cookingSpeedValue = Math.ceil((200.0 - cookingSpeedDifference) / cookingSpeedDifference * 100.0) + 100.0;
        IFormattableTextComponent cookingSpeed = new StringTextComponent(String.valueOf((int)cookingSpeedValue)).func_240702_b_("%");
        double burnTimeDifference = 1600.0 * this.tier.getBurnTimeMultiplier() / cookingSpeedDifference;
        double burnTimeValue = Math.ceil((burnTimeDifference - 8.0) / 8.0 * 100.0) + 100.0;
        IFormattableTextComponent fuelEfficiency = new StringTextComponent(String.valueOf((int)burnTimeValue)).func_240702_b_("%");
        tooltip.add((ITextComponent)ModTooltips.COOKING_SPEED.args(new Object[]{cookingSpeed}).build());
        tooltip.add((ITextComponent)ModTooltips.FUEL_EFFICIENCY.args(new Object[]{fuelEfficiency}).build());
    }

    public static enum FurnaceTier {
        INFERIUM("inferium", 0.84, 0.84, EssenceFurnaceTileEntity.Inferium::new),
        PRUDENTIUM("prudentium", 0.625, 0.84, EssenceFurnaceTileEntity.Prudentium::new),
        TERTIUM("tertium", 0.4, 0.68, EssenceFurnaceTileEntity.Tertium::new),
        IMPERIUM("imperium", 0.145, 0.5, EssenceFurnaceTileEntity.Imperium::new),
        SUPREMIUM("supremium", 0.025, 0.2, EssenceFurnaceTileEntity.Supremium::new);

        private final String name;
        private final double cookTimeMultiplier;
        private final double burnTimeMultiplier;
        private final Supplier<EssenceFurnaceTileEntity> tileEntitySupplier;

        private FurnaceTier(String name, double cookTimeMultiplier, double burnTimeMultiplier, Supplier<EssenceFurnaceTileEntity> tileEntitySupplier) {
            this.name = name;
            this.cookTimeMultiplier = cookTimeMultiplier;
            this.burnTimeMultiplier = burnTimeMultiplier;
            this.tileEntitySupplier = tileEntitySupplier;
        }

        public String getName() {
            return this.name;
        }

        public double getCookTimeMultiplier() {
            return this.cookTimeMultiplier;
        }

        public double getBurnTimeMultiplier() {
            return this.burnTimeMultiplier;
        }

        public EssenceFurnaceTileEntity getNewTileEntity() {
            return this.tileEntitySupplier.get();
        }
    }
}

