/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.mysticalagriculture.crafting.ingredient;

import com.blakebr0.mysticalagriculture.api.util.MobSoulUtils;
import com.blakebr0.mysticalagriculture.init.ModItems;
import com.blakebr0.mysticalagriculture.init.ModRecipeSerializers;
import com.blakebr0.mysticalagriculture.item.SoulJarItem;
import com.blakebr0.mysticalagriculture.registry.MobSoulTypeRegistry;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntComparators;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.stream.Stream;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.RecipeItemHelper;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.common.crafting.IIngredientSerializer;

public class FilledSoulJarIngredient
extends Ingredient {
    private ItemStack[] stacks;
    private IntList stacksPacked;

    public FilledSoulJarIngredient() {
        super(Stream.of(new Ingredient.IItemList[0]));
    }

    public ItemStack[] func_193365_a() {
        if (this.stacks == null) {
            this.stacks = this.getAllFilledJarStacks();
        }
        return this.stacks;
    }

    public IntList func_194139_b() {
        if (this.stacksPacked == null) {
            if (this.stacks == null) {
                this.stacks = this.getAllFilledJarStacks();
            }
            this.stacksPacked = new IntArrayList(this.stacks.length);
            Arrays.stream(this.stacks).forEach(s -> this.stacksPacked.add(RecipeItemHelper.func_194113_b((ItemStack)s)));
            this.stacksPacked.sort((Comparator)IntComparators.NATURAL_COMPARATOR);
        }
        return this.stacksPacked;
    }

    public boolean test(ItemStack stack) {
        if (stack != null) {
            if (this.stacks == null) {
                this.stacks = this.getAllFilledJarStacks();
            }
            return stack.func_77973_b() instanceof SoulJarItem && MobSoulUtils.getSouls(stack) > 0.0;
        }
        return false;
    }

    public boolean func_203189_d() {
        return !(this.stacks != null && this.stacks.length != 0 || this.stacksPacked != null && !this.stacksPacked.isEmpty());
    }

    public JsonElement func_200304_c() {
        JsonArray json = new JsonArray();
        JsonObject obj = new JsonObject();
        obj.addProperty("item", "mysticalagriculture:soul_jar");
        json.add((JsonElement)obj);
        return json;
    }

    protected void invalidate() {
        this.stacks = null;
        this.stacksPacked = null;
    }

    public boolean isSimple() {
        return false;
    }

    private ItemStack[] getAllFilledJarStacks() {
        return (ItemStack[])MobSoulTypeRegistry.getInstance().getMobSoulTypes().stream().map(type -> MobSoulUtils.getFilledSoulJar(type, (Item)ModItems.SOUL_JAR.get())).toArray(ItemStack[]::new);
    }

    public IIngredientSerializer<? extends Ingredient> getSerializer() {
        return ModRecipeSerializers.FILLED_SOUL_JAR_INGREDIENT;
    }

    public static class Serializer
    implements IIngredientSerializer<FilledSoulJarIngredient> {
        public FilledSoulJarIngredient parse(PacketBuffer buffer) {
            return new FilledSoulJarIngredient();
        }

        public FilledSoulJarIngredient parse(JsonObject json) {
            return new FilledSoulJarIngredient();
        }

        public void write(PacketBuffer buffer, FilledSoulJarIngredient ingredient) {
        }
    }
}

