/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.mysticalagriculture.crafting.recipe;

import com.blakebr0.cucumber.crafting.ISpecialRecipe;
import com.blakebr0.mysticalagriculture.api.crafting.IReprocessorRecipe;
import com.blakebr0.mysticalagriculture.api.crafting.RecipeTypes;
import com.blakebr0.mysticalagriculture.init.ModRecipeSerializers;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.ShapedRecipe;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class ReprocessorRecipe
implements ISpecialRecipe,
IReprocessorRecipe {
    private final ResourceLocation recipeId;
    private final NonNullList<Ingredient> inputs;
    private final ItemStack output;

    public ReprocessorRecipe(ResourceLocation recipeId, Ingredient input, ItemStack output) {
        this.recipeId = recipeId;
        this.inputs = NonNullList.func_193580_a((Object)Ingredient.field_193370_a, (Object[])new Ingredient[]{input});
        this.output = output;
    }

    public ItemStack getCraftingResult(IItemHandler inventory) {
        return this.output.func_77946_l();
    }

    public boolean func_194133_a(int width, int height) {
        return true;
    }

    public ItemStack func_77571_b() {
        return this.output;
    }

    public NonNullList<Ingredient> func_192400_c() {
        return this.inputs;
    }

    public ResourceLocation func_199560_c() {
        return this.recipeId;
    }

    public IRecipeSerializer<ReprocessorRecipe> func_199559_b() {
        return ModRecipeSerializers.REPROCESSOR;
    }

    public IRecipeType<? extends IReprocessorRecipe> func_222127_g() {
        return RecipeTypes.REPROCESSOR;
    }

    public boolean matches(IItemHandler inventory, int startIndex, int endIndex) {
        ItemStack stack = inventory.getStackInSlot(0);
        return ((Ingredient)this.inputs.get(0)).test(stack);
    }

    public static class Serializer
    extends ForgeRegistryEntry<IRecipeSerializer<?>>
    implements IRecipeSerializer<ReprocessorRecipe> {
        public ReprocessorRecipe read(ResourceLocation recipeId, JsonObject json) {
            JsonObject ingredient = json.getAsJsonObject("input");
            Ingredient input = Ingredient.func_199802_a((JsonElement)ingredient);
            ItemStack output = ShapedRecipe.func_199798_a((JsonObject)json.getAsJsonObject("result"));
            return new ReprocessorRecipe(recipeId, input, output);
        }

        public ReprocessorRecipe read(ResourceLocation recipeId, PacketBuffer buffer) {
            Ingredient input = Ingredient.func_199566_b((PacketBuffer)buffer);
            ItemStack output = buffer.func_150791_c();
            return new ReprocessorRecipe(recipeId, input, output);
        }

        public void write(PacketBuffer buffer, ReprocessorRecipe recipe) {
            ((Ingredient)recipe.inputs.get(0)).func_199564_a(buffer);
            buffer.func_150788_a(recipe.output);
        }
    }
}

