/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.mysticalagriculture.handler;

import com.blakebr0.mysticalagriculture.api.soul.IMobSoulType;
import com.blakebr0.mysticalagriculture.api.soul.ISoulSiphoningItem;
import com.blakebr0.mysticalagriculture.api.util.MobSoulUtils;
import com.blakebr0.mysticalagriculture.item.SoulJarItem;
import com.blakebr0.mysticalagriculture.registry.MobSoulTypeRegistry;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Hand;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public final class MobSoulHandler {
    @SubscribeEvent
    public void onLivingDeath(LivingDeathEvent event) {
        PlayerEntity player;
        ItemStack heldStack;
        Item held;
        Entity source = event.getSource().func_76346_g();
        if (source instanceof PlayerEntity && (held = (heldStack = (player = (PlayerEntity)source).func_184586_b(Hand.MAIN_HAND)).func_77973_b()) instanceof ISoulSiphoningItem) {
            List<ItemStack> soulJars;
            LivingEntity entity = event.getEntityLiving();
            ISoulSiphoningItem soulSiphoningItem = (ISoulSiphoningItem)held;
            IMobSoulType mobSoulType = MobSoulTypeRegistry.getInstance().getMobSoulTypeByEntity(entity);
            if (mobSoulType != null && !(soulJars = this.getSoulJars(player)).isEmpty()) {
                ItemStack firstEmptyJar = ItemStack.field_190927_a;
                double soulsRemaining = soulSiphoningItem.getSiphonAmount(heldStack, entity);
                for (ItemStack stack : soulJars) {
                    IMobSoulType type = MobSoulUtils.getType(stack);
                    if (type == null && firstEmptyJar.func_190926_b()) {
                        firstEmptyJar = stack;
                        continue;
                    }
                    if (type == null || type != mobSoulType || !((soulsRemaining = MobSoulUtils.addSoulsToJar(stack, mobSoulType, soulsRemaining)) <= 0.0)) continue;
                    break;
                }
                if (!firstEmptyJar.func_190926_b() && soulsRemaining > 0.0) {
                    MobSoulUtils.addSoulsToJar(firstEmptyJar, mobSoulType, soulsRemaining);
                }
            }
        }
    }

    private List<ItemStack> getSoulJars(PlayerEntity player) {
        return player.field_71071_by.field_70462_a.stream().filter(s -> s.func_77973_b() instanceof SoulJarItem).collect(Collectors.toList());
    }
}

