/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client;

import mekanism.client.MekKeyHandler;
import mekanism.client.MekanismClient;
import mekanism.client.sound.SoundHandler;
import mekanism.common.Mekanism;
import mekanism.common.MekanismLang;
import mekanism.common.inventory.container.ModuleTweakerContainer;
import mekanism.common.item.interfaces.IModeItem;
import mekanism.common.network.PacketModeChange;
import mekanism.common.network.PacketOpenGui;
import mekanism.common.registries.MekanismSounds;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.client.util.InputMappings;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.client.settings.IKeyConflictContext;
import net.minecraftforge.client.settings.KeyConflictContext;
import net.minecraftforge.client.settings.KeyModifier;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.client.registry.ClientRegistry;

public class MekanismKeyHandler
extends MekKeyHandler {
    public static final KeyBinding handModeSwitchKey = new KeyBinding(MekanismLang.KEY_HAND_MODE.getTranslationKey(), (IKeyConflictContext)KeyConflictContext.IN_GAME, InputMappings.Type.KEYSYM, 78, MekanismLang.MEKANISM.getTranslationKey());
    public static final KeyBinding headModeSwitchKey = new KeyBinding(MekanismLang.KEY_HEAD_MODE.getTranslationKey(), (IKeyConflictContext)KeyConflictContext.IN_GAME, InputMappings.Type.KEYSYM, 86, MekanismLang.MEKANISM.getTranslationKey());
    public static final KeyBinding chestModeSwitchKey = new KeyBinding(MekanismLang.KEY_CHEST_MODE.getTranslationKey(), (IKeyConflictContext)KeyConflictContext.IN_GAME, InputMappings.Type.KEYSYM, 71, MekanismLang.MEKANISM.getTranslationKey());
    public static final KeyBinding feetModeSwitchKey = new KeyBinding(MekanismLang.KEY_FEET_MODE.getTranslationKey(), (IKeyConflictContext)KeyConflictContext.IN_GAME, InputMappings.Type.KEYSYM, 66, MekanismLang.MEKANISM.getTranslationKey());
    public static final KeyBinding detailsKey = new KeyBinding(MekanismLang.KEY_DETAILS_MODE.getTranslationKey(), (IKeyConflictContext)KeyConflictContext.GUI, InputMappings.Type.KEYSYM, 340, MekanismLang.MEKANISM.getTranslationKey());
    public static final KeyBinding descriptionKey = new KeyBinding(MekanismLang.KEY_DESCRIPTION_MODE.getTranslationKey(), (IKeyConflictContext)KeyConflictContext.GUI, KeyModifier.SHIFT, InputMappings.Type.KEYSYM, 78, MekanismLang.MEKANISM.getTranslationKey());
    public static final KeyBinding moduleTweakerKey = new KeyBinding(MekanismLang.KEY_MODULE_TWEAKER.getTranslationKey(), (IKeyConflictContext)KeyConflictContext.IN_GAME, InputMappings.Type.KEYSYM, 92, MekanismLang.MEKANISM.getTranslationKey());
    public static final KeyBinding boostKey = new KeyBinding(MekanismLang.KEY_BOOST.getTranslationKey(), (IKeyConflictContext)KeyConflictContext.IN_GAME, InputMappings.Type.KEYSYM, 341, MekanismLang.MEKANISM.getTranslationKey());
    public static final KeyBinding hudKey = new KeyBinding(MekanismLang.KEY_HUD.getTranslationKey(), (IKeyConflictContext)KeyConflictContext.IN_GAME, InputMappings.Type.KEYSYM, 72, MekanismLang.MEKANISM.getTranslationKey());
    private static final MekKeyHandler.Builder BINDINGS = new MekKeyHandler.Builder(9).addBinding(handModeSwitchKey, false).addBinding(headModeSwitchKey, false).addBinding(chestModeSwitchKey, false).addBinding(feetModeSwitchKey, false).addBinding(detailsKey, false).addBinding(descriptionKey, false).addBinding(moduleTweakerKey, false).addBinding(boostKey, false).addBinding(hudKey, false);

    public MekanismKeyHandler() {
        super(BINDINGS);
        ClientRegistry.registerKeyBinding((KeyBinding)handModeSwitchKey);
        ClientRegistry.registerKeyBinding((KeyBinding)headModeSwitchKey);
        ClientRegistry.registerKeyBinding((KeyBinding)chestModeSwitchKey);
        ClientRegistry.registerKeyBinding((KeyBinding)feetModeSwitchKey);
        ClientRegistry.registerKeyBinding((KeyBinding)detailsKey);
        ClientRegistry.registerKeyBinding((KeyBinding)descriptionKey);
        ClientRegistry.registerKeyBinding((KeyBinding)moduleTweakerKey);
        ClientRegistry.registerKeyBinding((KeyBinding)boostKey);
        ClientRegistry.registerKeyBinding((KeyBinding)hudKey);
        MinecraftForge.EVENT_BUS.addListener(this::onTick);
    }

    private void onTick(InputEvent.KeyInputEvent event) {
        this.keyTick();
    }

    @Override
    public void keyDown(KeyBinding kb, boolean isRepeat) {
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        if (player == null) {
            return;
        }
        if (kb == handModeSwitchKey) {
            if (IModeItem.isModeItem((PlayerEntity)player, EquipmentSlotType.MAINHAND, false)) {
                Mekanism.packetHandler.sendToServer(new PacketModeChange(EquipmentSlotType.MAINHAND, player.func_225608_bj_()));
            } else if (!IModeItem.isModeItem((PlayerEntity)player, EquipmentSlotType.MAINHAND) && IModeItem.isModeItem((PlayerEntity)player, EquipmentSlotType.OFFHAND)) {
                Mekanism.packetHandler.sendToServer(new PacketModeChange(EquipmentSlotType.OFFHAND, player.func_225608_bj_()));
            }
        } else if (kb == headModeSwitchKey) {
            if (IModeItem.isModeItem((PlayerEntity)player, EquipmentSlotType.HEAD)) {
                Mekanism.packetHandler.sendToServer(new PacketModeChange(EquipmentSlotType.HEAD, player.func_225608_bj_()));
                SoundHandler.playSound(MekanismSounds.HYDRAULIC);
            }
        } else if (kb == chestModeSwitchKey) {
            if (IModeItem.isModeItem((PlayerEntity)player, EquipmentSlotType.CHEST)) {
                Mekanism.packetHandler.sendToServer(new PacketModeChange(EquipmentSlotType.CHEST, player.func_225608_bj_()));
                SoundHandler.playSound(MekanismSounds.HYDRAULIC);
            }
        } else if (kb == feetModeSwitchKey) {
            if (IModeItem.isModeItem((PlayerEntity)player, EquipmentSlotType.FEET)) {
                Mekanism.packetHandler.sendToServer(new PacketModeChange(EquipmentSlotType.FEET, player.func_225608_bj_()));
                SoundHandler.playSound(MekanismSounds.HYDRAULIC);
            }
        } else if (kb == moduleTweakerKey) {
            if (ModuleTweakerContainer.hasTweakableItem((PlayerEntity)player)) {
                Mekanism.packetHandler.sendToServer(new PacketOpenGui(PacketOpenGui.GuiType.MODULE_TWEAKER));
            }
        } else if (kb == boostKey) {
            MekanismClient.updateKey(kb, 2);
        } else if (kb == hudKey) {
            MekanismClient.renderHUD = !MekanismClient.renderHUD;
        }
    }

    @Override
    public void keyUp(KeyBinding kb) {
        if (kb == boostKey) {
            MekanismClient.updateKey(kb, 2);
        }
    }
}

