/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.Arrays;
import java.util.Collections;
import javax.annotation.Nonnull;
import mekanism.api.text.EnumColor;
import mekanism.client.gui.GuiMekanism;
import mekanism.client.gui.GuiMekanismTile;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.GuiInnerScreen;
import mekanism.client.gui.element.bar.GuiBar;
import mekanism.client.gui.element.bar.GuiVerticalRateBar;
import mekanism.client.gui.element.gauge.GaugeType;
import mekanism.client.gui.element.gauge.GuiFluidGauge;
import mekanism.client.gui.element.gauge.GuiGasGauge;
import mekanism.client.gui.element.tab.GuiBoilerTab;
import mekanism.client.gui.element.tab.GuiHeatTab;
import mekanism.common.MekanismLang;
import mekanism.common.config.MekanismConfig;
import mekanism.common.content.boiler.BoilerMultiblockData;
import mekanism.common.inventory.container.tile.MekanismTileContainer;
import mekanism.common.tile.multiblock.TileEntityBoilerCasing;
import mekanism.common.util.HeatUtils;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.UnitDisplayUtils;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.util.text.ITextComponent;

public class GuiThermoelectricBoiler
extends GuiMekanismTile<TileEntityBoilerCasing, MekanismTileContainer<TileEntityBoilerCasing>> {
    public GuiThermoelectricBoiler(MekanismTileContainer<TileEntityBoilerCasing> container, PlayerInventory inv, ITextComponent title) {
        super(container, inv, title);
        this.dynamicSlots = true;
        this.field_146999_f += 40;
        this.field_238745_s_ += 2;
        this.field_238743_q_ = 5;
    }

    @Override
    public void func_231160_c_() {
        super.func_231160_c_();
        this.func_230480_a_(new GuiInnerScreen((IGuiWrapper)this, 60, 23, 96, 40, () -> {
            BoilerMultiblockData multiblock = (BoilerMultiblockData)((TileEntityBoilerCasing)this.tile).getMultiblock();
            return Arrays.asList(MekanismLang.TEMPERATURE.translate(MekanismUtils.getTemperatureDisplay(multiblock.getTotalTemperature(), UnitDisplayUtils.TemperatureUnit.KELVIN, true)), MekanismLang.BOIL_RATE.translate(GuiThermoelectricBoiler.formatInt(multiblock.lastBoilRate)), MekanismLang.MAX_BOIL_RATE.translate(GuiThermoelectricBoiler.formatInt(multiblock.lastMaxBoil)));
        }));
        this.func_230480_a_(new GuiBoilerTab((IGuiWrapper)this, (TileEntityBoilerCasing)this.tile, GuiBoilerTab.BoilerTab.STAT));
        this.func_230480_a_(new GuiVerticalRateBar(this, new GuiBar.IBarInfoHandler(){

            @Override
            public ITextComponent getTooltip() {
                return MekanismLang.BOIL_RATE.translate(GuiMekanism.formatInt(((BoilerMultiblockData)((TileEntityBoilerCasing)GuiThermoelectricBoiler.this.tile).getMultiblock()).lastBoilRate));
            }

            @Override
            public double getLevel() {
                BoilerMultiblockData multiblock = (BoilerMultiblockData)((TileEntityBoilerCasing)GuiThermoelectricBoiler.this.tile).getMultiblock();
                return Math.min(1.0, (double)multiblock.lastBoilRate / (double)multiblock.lastMaxBoil);
            }
        }, 44, 13));
        this.func_230480_a_(new GuiVerticalRateBar(this, new GuiBar.IBarInfoHandler(){

            @Override
            public ITextComponent getTooltip() {
                return MekanismLang.MAX_BOIL_RATE.translate(GuiMekanism.formatInt(((BoilerMultiblockData)((TileEntityBoilerCasing)GuiThermoelectricBoiler.this.tile).getMultiblock()).lastMaxBoil));
            }

            @Override
            public double getLevel() {
                BoilerMultiblockData multiblock = (BoilerMultiblockData)((TileEntityBoilerCasing)GuiThermoelectricBoiler.this.tile).getMultiblock();
                return Math.min(1.0, (double)multiblock.lastMaxBoil * HeatUtils.getWaterThermalEnthalpy() / ((double)multiblock.superheatingElements * MekanismConfig.general.superheatingHeatTransfer.get()));
            }
        }, 164, 13));
        this.func_230480_a_(new GuiGasGauge(() -> ((BoilerMultiblockData)((TileEntityBoilerCasing)this.tile).getMultiblock()).superheatedCoolantTank, () -> ((BoilerMultiblockData)((TileEntityBoilerCasing)this.tile).getMultiblock()).getGasTanks(null), GaugeType.STANDARD, this, 6, 13).setLabel((ITextComponent)MekanismLang.BOILER_HEATED_COOLANT_TANK.translateColored(EnumColor.ORANGE, new Object[0])));
        this.func_230480_a_(new GuiFluidGauge(() -> ((BoilerMultiblockData)((TileEntityBoilerCasing)this.tile).getMultiblock()).waterTank, () -> ((BoilerMultiblockData)((TileEntityBoilerCasing)this.tile).getMultiblock()).getFluidTanks(null), GaugeType.STANDARD, this, 26, 13).setLabel((ITextComponent)MekanismLang.BOILER_WATER_TANK.translateColored(EnumColor.INDIGO, new Object[0])));
        this.func_230480_a_(new GuiGasGauge(() -> ((BoilerMultiblockData)((TileEntityBoilerCasing)this.tile).getMultiblock()).steamTank, () -> ((BoilerMultiblockData)((TileEntityBoilerCasing)this.tile).getMultiblock()).getGasTanks(null), GaugeType.STANDARD, this, 172, 13).setLabel((ITextComponent)MekanismLang.BOILER_STEAM_TANK.translateColored(EnumColor.GRAY, new Object[0])));
        this.func_230480_a_(new GuiGasGauge(() -> ((BoilerMultiblockData)((TileEntityBoilerCasing)this.tile).getMultiblock()).cooledCoolantTank, () -> ((BoilerMultiblockData)((TileEntityBoilerCasing)this.tile).getMultiblock()).getGasTanks(null), GaugeType.STANDARD, this, 192, 13).setLabel((ITextComponent)MekanismLang.BOILER_COOLANT_TANK.translateColored(EnumColor.AQUA, new Object[0])));
        this.func_230480_a_(new GuiHeatTab(() -> {
            ITextComponent environment = MekanismUtils.getTemperatureDisplay(((BoilerMultiblockData)((TileEntityBoilerCasing)this.tile).getMultiblock()).lastEnvironmentLoss, UnitDisplayUtils.TemperatureUnit.KELVIN, false);
            return Collections.singletonList(MekanismLang.DISSIPATED_RATE.translate(environment));
        }, this));
    }

    @Override
    protected void drawForegroundText(@Nonnull MatrixStack matrix, int mouseX, int mouseY) {
        this.drawTitleText(matrix, (ITextComponent)MekanismLang.BOILER.translate(new Object[0]), this.field_238743_q_);
        this.drawString(matrix, this.field_213127_e.func_145748_c_(), this.field_238744_r_, this.field_238745_s_, this.titleTextColor());
        super.drawForegroundText(matrix, mouseX, mouseY);
    }
}

