/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui.element.filter;

import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mekanism.api.text.ILangEntry;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.filter.GuiFilter;
import mekanism.client.jei.interfaces.IJEIGhostTarget;
import mekanism.client.sound.SoundHandler;
import mekanism.common.MekanismLang;
import mekanism.common.content.filter.IItemStackFilter;
import mekanism.common.tile.base.TileEntityMekanism;
import mekanism.common.util.StackUtils;
import net.minecraft.item.ItemStack;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.text.ITextComponent;

public abstract class GuiItemStackFilter<FILTER extends IItemStackFilter<FILTER>, TILE extends TileEntityMekanism>
extends GuiFilter<FILTER, TILE> {
    protected GuiItemStackFilter(IGuiWrapper gui, int x, int y, int width, int height, TILE tile, FILTER origFilter) {
        super(gui, x, y, width, height, (ITextComponent)MekanismLang.ITEM_FILTER.translate(new Object[0]), tile, origFilter);
    }

    @Override
    protected List<ITextComponent> getScreenText() {
        List<ITextComponent> list = super.getScreenText();
        if (((IItemStackFilter)this.filter).hasFilter()) {
            list.add(((IItemStackFilter)this.filter).getItemStack().func_200301_q());
        }
        return list;
    }

    @Override
    protected ILangEntry getNoFilterSaveError() {
        return MekanismLang.ITEM_FILTER_NO_ITEM;
    }

    @Override
    @Nonnull
    protected List<ItemStack> getRenderStacks() {
        ItemStack stack = ((IItemStackFilter)this.filter).getItemStack();
        return stack.func_190926_b() ? Collections.emptyList() : Collections.singletonList(stack);
    }

    @Override
    @Nullable
    protected IJEIGhostTarget.IGhostItemConsumer getGhostHandler() {
        return ingredient -> this.setFilterStack(StackUtils.size((ItemStack)ingredient, 1));
    }

    @Override
    public boolean func_231044_a_(double mouseX, double mouseY, int button) {
        return GuiItemStackFilter.mouseClickSlot(this.getGuiObj(), button, mouseX, mouseY, this.relativeX + 8, this.relativeY + this.getSlotOffset() + 1, NOT_EMPTY, this::setFilterStack) || super.func_231044_a_(mouseX, mouseY, button);
    }

    private void setFilterStack(@Nonnull ItemStack stack) {
        ((IItemStackFilter)this.filter).setItemStack(stack);
        this.slotDisplay.updateStackList();
        SoundHandler.playSound(SoundEvents.field_187909_gi);
    }
}

