/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui.element.filter;

import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mekanism.api.text.ILangEntry;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.filter.GuiFilter;
import mekanism.client.jei.interfaces.IJEIGhostTarget;
import mekanism.client.sound.SoundHandler;
import mekanism.common.MekanismLang;
import mekanism.common.base.TagCache;
import mekanism.common.content.filter.IMaterialFilter;
import mekanism.common.tile.base.TileEntityMekanism;
import mekanism.common.util.StackUtils;
import net.minecraft.item.ItemStack;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.text.ITextComponent;

public abstract class GuiMaterialFilter<FILTER extends IMaterialFilter<FILTER>, TILE extends TileEntityMekanism>
extends GuiFilter<FILTER, TILE> {
    protected GuiMaterialFilter(IGuiWrapper gui, int x, int y, int width, int height, TILE tile, FILTER origFilter) {
        super(gui, x, y, width, height, (ITextComponent)MekanismLang.MATERIAL_FILTER.translate(new Object[0]), tile, origFilter);
        if (((IMaterialFilter)this.filter).hasFilter()) {
            this.slotDisplay.updateStackList();
        }
    }

    @Override
    protected List<ITextComponent> getScreenText() {
        List<ITextComponent> list = super.getScreenText();
        if (((IMaterialFilter)this.filter).hasFilter()) {
            list.add((ITextComponent)MekanismLang.MATERIAL_FILTER_DETAILS.translate(new Object[0]));
            list.add(((IMaterialFilter)this.filter).getMaterialItem().func_200301_q());
        }
        return list;
    }

    @Override
    protected ILangEntry getNoFilterSaveError() {
        return MekanismLang.ITEM_FILTER_NO_ITEM;
    }

    @Override
    @Nonnull
    protected List<ItemStack> getRenderStacks() {
        if (((IMaterialFilter)this.filter).hasFilter()) {
            return TagCache.getMaterialStacks(((IMaterialFilter)this.filter).getMaterialItem());
        }
        return Collections.emptyList();
    }

    @Override
    @Nullable
    protected IJEIGhostTarget.IGhostBlockItemConsumer getGhostHandler() {
        return ingredient -> this.setFilterStack(StackUtils.size((ItemStack)ingredient, 1));
    }

    @Override
    public boolean func_231044_a_(double mouseX, double mouseY, int button) {
        return GuiMaterialFilter.mouseClickSlot(this.getGuiObj(), button, mouseX, mouseY, this.relativeX + 8, this.relativeY + this.getSlotOffset() + 1, NOT_EMPTY_BLOCK, this::setFilterStack) || super.func_231044_a_(mouseX, mouseY, button);
    }

    private void setFilterStack(@Nonnull ItemStack stack) {
        ((IMaterialFilter)this.filter).setMaterialItem(stack);
        this.slotDisplay.updateStackList();
        SoundHandler.playSound(SoundEvents.field_187909_gi);
    }
}

