/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui.element.scroll;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.GuiRelativeElement;
import mekanism.client.gui.element.scroll.GuiScrollBar;
import mekanism.client.render.MekanismRenderer;
import mekanism.common.inventory.ISlotClickHandler;
import mekanism.common.util.MekanismUtils;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.util.ResourceLocation;

public class GuiSlotScroll
extends GuiRelativeElement {
    private static final ResourceLocation SLOTS = MekanismUtils.getResource(MekanismUtils.ResourceType.GUI_SLOT, "slots.png");
    private static final ResourceLocation SLOTS_DARK = MekanismUtils.getResource(MekanismUtils.ResourceType.GUI_SLOT, "slots_dark.png");
    private final GuiScrollBar scrollBar;
    private final int xSlots;
    private final int ySlots;
    private final Supplier<List<ISlotClickHandler.IScrollableSlot>> slotList;
    private final ISlotClickHandler clickHandler;

    public GuiSlotScroll(IGuiWrapper gui, int x, int y, int xSlots, int ySlots, Supplier<List<ISlotClickHandler.IScrollableSlot>> slotList, ISlotClickHandler clickHandler) {
        super(gui, x, y, xSlots * 18 + 18, ySlots * 18);
        this.xSlots = xSlots;
        this.ySlots = ySlots;
        this.slotList = slotList;
        this.clickHandler = clickHandler;
        this.scrollBar = new GuiScrollBar(gui, this.relativeX + xSlots * 18 + 4, y, ySlots * 18, () -> this.getSlotList() == null ? 0 : (int)Math.ceil((double)this.getSlotList().size() / (double)xSlots), () -> ySlots);
        this.addChild(this.scrollBar);
    }

    @Override
    public void drawBackground(@Nonnull MatrixStack matrix, int mouseX, int mouseY, float partialTicks) {
        super.drawBackground(matrix, mouseX, mouseY, partialTicks);
        GuiSlotScroll.minecraft.field_71446_o.func_110577_a(this.getSlotList() == null ? SLOTS_DARK : SLOTS);
        GuiSlotScroll.func_238463_a_((MatrixStack)matrix, (int)this.field_230690_l_, (int)this.field_230691_m_, (float)0.0f, (float)0.0f, (int)(this.xSlots * 18), (int)(this.ySlots * 18), (int)288, (int)288);
        List<ISlotClickHandler.IScrollableSlot> list = this.getSlotList();
        if (list != null) {
            int slot;
            int slotStart = this.scrollBar.getCurrentSelection() * this.xSlots;
            int max = this.xSlots * this.ySlots;
            for (int i = 0; i < max && (slot = slotStart + i) < list.size(); ++i) {
                int slotX = this.field_230690_l_ + i % this.xSlots * 18;
                int slotY = this.field_230691_m_ + i / this.xSlots * 18;
                this.renderSlot(matrix, list.get(slot), slotX, slotY);
            }
        }
    }

    @Override
    public void renderForeground(MatrixStack matrix, int mouseX, int mouseY) {
        super.renderForeground(matrix, mouseX, mouseY);
        int xAxis = mouseX - this.guiObj.getLeft();
        int yAxis = mouseY - this.guiObj.getTop();
        int slotX = (xAxis - this.relativeX) / 18;
        int slotY = (yAxis - this.relativeY) / 18;
        if (slotX >= 0 && slotY >= 0 && slotX < this.xSlots && slotY < this.ySlots) {
            int slotStartX = this.relativeX + slotX * 18 + 1;
            int slotStartY = this.relativeY + slotY * 18 + 1;
            if (xAxis >= slotStartX && xAxis < slotStartX + 16 && yAxis >= slotStartY && yAxis < slotStartY + 16) {
                GuiSlotScroll.func_238467_a_((MatrixStack)matrix, (int)slotStartX, (int)slotStartY, (int)(slotStartX + 16), (int)(slotStartY + 16), (int)-2130706433);
                MekanismRenderer.resetColor();
            }
        }
    }

    @Override
    public void func_230443_a_(@Nonnull MatrixStack matrix, int xAxis, int yAxis) {
        ISlotClickHandler.IScrollableSlot slot = this.getSlot(xAxis, yAxis, this.relativeX, this.relativeY);
        if (slot != null) {
            this.renderSlotTooltip(matrix, slot, xAxis, yAxis);
        }
    }

    public boolean func_231043_a_(double mouseX, double mouseY, double delta) {
        return this.scrollBar.adjustScroll(delta) || super.func_231043_a_(mouseX, mouseY, delta);
    }

    public boolean func_231048_c_(double mouseX, double mouseY, int button) {
        super.func_231048_c_(mouseX, mouseY, button);
        ISlotClickHandler.IScrollableSlot slot = this.getSlot(mouseX, mouseY, this.field_230690_l_, this.field_230691_m_);
        this.clickHandler.onClick(slot, button, Screen.func_231173_s_(), GuiSlotScroll.minecraft.field_71439_g.field_71071_by.func_70445_o());
        return true;
    }

    private ISlotClickHandler.IScrollableSlot getSlot(double mouseX, double mouseY, int relativeX, int relativeY) {
        List<ISlotClickHandler.IScrollableSlot> list = this.getSlotList();
        if (list == null) {
            return null;
        }
        int slotX = (int)((mouseX - (double)relativeX) / 18.0);
        int slotY = (int)((mouseY - (double)relativeY) / 18.0);
        int slotStartX = relativeX + slotX * 18 + 1;
        int slotStartY = relativeY + slotY * 18 + 1;
        if (mouseX < (double)slotStartX || mouseX >= (double)(slotStartX + 16) || mouseY < (double)slotStartY || mouseY >= (double)(slotStartY + 16)) {
            return null;
        }
        if (slotX < 0 || slotY < 0 || slotX >= this.xSlots || slotY >= this.ySlots) {
            return null;
        }
        int slot = (slotY + this.scrollBar.getCurrentSelection()) * this.xSlots + slotX;
        if (slot >= list.size()) {
            return null;
        }
        return list.get(slot);
    }

    private void renderSlot(MatrixStack matrix, ISlotClickHandler.IScrollableSlot slot, int slotX, int slotY) {
        if (slot.getItem() == null || slot.getItem().getStack() == null || slot.getItem().getStack().func_190926_b()) {
            return;
        }
        this.guiObj.renderItemWithOverlay(matrix, slot.getItem().getStack(), slotX + 1, slotY + 1, 1.0f, "");
        if (slot.getCount() > 1L) {
            this.renderSlotText(matrix, this.getCountText(slot.getCount()), slotX + 1, slotY + 1);
        }
    }

    private void renderSlotTooltip(MatrixStack matrix, ISlotClickHandler.IScrollableSlot slot, int slotX, int slotY) {
        if (slot.getItem() == null || slot.getItem().getStack() == null || slot.getItem().getStack().func_190926_b()) {
            return;
        }
        this.guiObj.renderItemTooltip(matrix, slot.getItem().getStack(), slotX, slotY);
    }

    private void renderSlotText(MatrixStack matrix, String text, int x, int y) {
        matrix.func_227860_a_();
        MekanismRenderer.resetColor();
        float scale = 0.6f;
        float yAdd = 4.0f - scale * 8.0f / 2.0f;
        matrix.func_227861_a_((double)((float)(x + 16) - (float)this.getFont().func_78256_a(text) * scale), (double)((float)(y + 9) + yAdd), 200.0);
        matrix.func_227862_a_(scale, scale, scale);
        IRenderTypeBuffer.Impl buffer = IRenderTypeBuffer.func_228455_a_((BufferBuilder)Tessellator.func_178181_a().func_178180_c());
        this.getFont().func_228079_a_(text, 0.0f, 0.0f, 0xFFFFFF, true, matrix.func_227866_c_().func_227870_a_(), (IRenderTypeBuffer)buffer, false, 0, 0xF000F0);
        buffer.func_228461_a_();
        matrix.func_227865_b_();
    }

    private String getCountText(long count) {
        if (count <= 1L) {
            return null;
        }
        if (count < 10000L) {
            return Long.toString(count);
        }
        if (count < 10000000L) {
            return Double.toString(Math.round((double)count / 1000.0)) + "K";
        }
        if (count < 10000000000L) {
            return Double.toString(Math.round((double)count / 1000000.0)) + "M";
        }
        if (count < 10000000000000L) {
            return Double.toString(Math.round((double)count / 1.0E9)) + "B";
        }
        return ">10T";
    }

    private List<ISlotClickHandler.IScrollableSlot> getSlotList() {
        return this.slotList.get();
    }
}

