/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui.qio;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nonnull;
import mekanism.api.text.EnumColor;
import mekanism.client.gui.GuiMekanism;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.GuiConfirmationDialog;
import mekanism.client.gui.element.button.ColorButton;
import mekanism.client.gui.element.button.MekanismButton;
import mekanism.client.gui.element.button.TranslationButton;
import mekanism.client.gui.element.scroll.GuiTextScrollList;
import mekanism.client.gui.element.slot.GuiSlot;
import mekanism.client.gui.element.slot.SlotType;
import mekanism.client.gui.element.text.BackgroundType;
import mekanism.client.gui.element.text.GuiTextField;
import mekanism.client.gui.element.text.InputValidator;
import mekanism.common.MekanismLang;
import mekanism.common.content.qio.QIOFrequency;
import mekanism.common.lib.frequency.Frequency;
import mekanism.common.util.text.OwnerDisplay;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public abstract class GuiQIOFrequencySelect<CONTAINER extends Container>
extends GuiMekanism<CONTAINER> {
    private MekanismButton publicButton;
    private MekanismButton privateButton;
    private MekanismButton setButton;
    private MekanismButton deleteButton;
    private GuiTextScrollList scrollList;
    private GuiTextField frequencyField;
    private boolean privateMode;
    private boolean init = false;

    public GuiQIOFrequencySelect(CONTAINER container, PlayerInventory inv, ITextComponent title) {
        super(container, inv, title);
        this.field_147000_g -= 6;
        this.field_238743_q_ = 5;
    }

    @Override
    public void func_231160_c_() {
        super.func_231160_c_();
        this.scrollList = new GuiTextScrollList(this, 27, 39, 122, 42);
        this.func_230480_a_(this.scrollList);
        this.publicButton = new TranslationButton(this, this.field_147003_i + 27, this.field_147009_r + 17, 60, 20, MekanismLang.PUBLIC, () -> {
            this.privateMode = false;
            this.updateButtons();
        });
        this.func_230480_a_(this.publicButton);
        this.privateButton = new TranslationButton(this, this.field_147003_i + 89, this.field_147009_r + 17, 60, 20, MekanismLang.PRIVATE, () -> {
            this.privateMode = true;
            this.updateButtons();
        });
        this.func_230480_a_(this.privateButton);
        this.setButton = new TranslationButton(this, this.field_147003_i + 27, this.field_147009_r + 120, 50, 18, MekanismLang.BUTTON_SET, () -> {
            int selection = this.scrollList.getSelection();
            if (selection != -1) {
                Frequency freq = this.privateMode ? (Frequency)this.getPrivateFrequencies().get(selection) : (Frequency)this.getPublicFrequencies().get(selection);
                this.setFrequency(freq.getName());
            }
            this.updateButtons();
        });
        this.func_230480_a_(this.setButton);
        this.deleteButton = new TranslationButton(this, this.field_147003_i + 79, this.field_147009_r + 120, 50, 18, MekanismLang.BUTTON_DELETE, () -> GuiConfirmationDialog.show(this, (ITextComponent)MekanismLang.FREQUENCY_DELETE_CONFIRM.translate(new Object[0]), () -> {
            int selection = this.scrollList.getSelection();
            if (selection != -1) {
                Frequency freq = this.privateMode ? (Frequency)this.getPrivateFrequencies().get(selection) : (Frequency)this.getPublicFrequencies().get(selection);
                this.sendRemoveFrequency(freq.getIdentity());
                this.scrollList.clearSelection();
            }
            this.updateButtons();
        }, GuiConfirmationDialog.DialogType.DANGER));
        this.func_230480_a_(this.deleteButton);
        this.func_230480_a_(new GuiSlot(SlotType.NORMAL, this, 131, 120).setRenderAboveSlots());
        this.func_230480_a_(new ColorButton((IGuiWrapper)this, this.field_147003_i + 132, this.field_147009_r + 121, 16, 16, () -> {
            QIOFrequency frequency = this.getFrequency();
            return frequency == null ? null : frequency.getColor();
        }, () -> this.sendColorUpdate(0), () -> this.sendColorUpdate(1)));
        this.frequencyField = new GuiTextField(this, 50, 106, 98, 11);
        this.func_230480_a_(this.frequencyField);
        this.frequencyField.setMaxStringLength(16);
        this.frequencyField.setBackground(BackgroundType.INNER_SCREEN);
        this.frequencyField.setEnterHandler(this::setFrequency);
        this.frequencyField.setInputValidator(InputValidator.or(InputValidator.DIGIT, InputValidator.LETTER, InputValidator.FREQUENCY_CHARS));
        this.frequencyField.addCheckmarkButton(this::setFrequency);
        this.updateButtons();
    }

    public void setFrequency(String freq) {
        if (!freq.isEmpty()) {
            this.sendSetFrequency(new Frequency.FrequencyIdentity(freq, !this.privateMode));
        }
    }

    public ITextComponent getSecurity(Frequency freq) {
        if (freq.isPublic()) {
            return MekanismLang.PUBLIC.translate(new Object[0]);
        }
        return MekanismLang.PRIVATE.translateColored(EnumColor.DARK_RED, new Object[0]);
    }

    private void updateButtons() {
        if (this.getOwnerUsername() == null) {
            return;
        }
        ArrayList<String> text = new ArrayList<String>();
        if (this.privateMode) {
            for (Frequency frequency : this.getPrivateFrequencies()) {
                text.add(frequency.getName());
            }
        } else {
            for (Frequency frequency : this.getPublicFrequencies()) {
                text.add(frequency.getName() + " (" + frequency.getClientOwner() + ")");
            }
        }
        this.scrollList.setText(text);
        if (this.privateMode) {
            this.publicButton.field_230693_o_ = true;
            this.privateButton.field_230693_o_ = false;
        } else {
            this.publicButton.field_230693_o_ = false;
            this.privateButton.field_230693_o_ = true;
        }
        if (this.scrollList.hasSelection()) {
            Frequency freq = this.privateMode ? (Frequency)this.getPrivateFrequencies().get(this.scrollList.getSelection()) : (Frequency)this.getPublicFrequencies().get(this.scrollList.getSelection());
            QIOFrequency qIOFrequency = this.getFrequency();
            this.setButton.field_230693_o_ = qIOFrequency == null || !qIOFrequency.equals(freq);
            UUID ownerUUID = this.getOwnerUUID();
            this.deleteButton.field_230693_o_ = ownerUUID != null && ownerUUID.equals(freq.getOwner());
        } else {
            this.setButton.field_230693_o_ = false;
            this.deleteButton.field_230693_o_ = false;
        }
    }

    @Override
    public void func_231023_e_() {
        QIOFrequency frequency;
        super.func_231023_e_();
        if (!this.init && (frequency = this.getFrequency()) != null) {
            this.init = true;
            this.privateMode = frequency.isPrivate();
        }
        this.updateButtons();
    }

    @Override
    public boolean func_231044_a_(double mouseX, double mouseY, int button) {
        this.updateButtons();
        return super.func_231044_a_(mouseX, mouseY, button);
    }

    private void setFrequency() {
        this.setFrequency(this.frequencyField.getText());
        this.frequencyField.setText("");
        this.updateButtons();
    }

    @Override
    protected void drawForegroundText(@Nonnull MatrixStack matrix, int mouseX, int mouseY) {
        this.drawTitleText(matrix, (ITextComponent)MekanismLang.QIO_FREQUENCY_SELECT.translate(new Object[0]), this.field_238743_q_);
        this.drawString(matrix, OwnerDisplay.of(this.getOwnerUUID(), this.getOwnerUsername()).getTextComponent(), 8, 143, this.titleTextColor());
        TranslationTextComponent frequencyComponent = MekanismLang.FREQUENCY.translate(new Object[0]);
        this.drawString(matrix, (ITextComponent)frequencyComponent, 32, 84, this.titleTextColor());
        TranslationTextComponent securityComponent = MekanismLang.SECURITY.translate("");
        this.drawString(matrix, (ITextComponent)securityComponent, 32, 94, this.titleTextColor());
        QIOFrequency frequency = this.getFrequency();
        int frequencyOffset = this.getStringWidth((ITextComponent)frequencyComponent) + 1;
        if (frequency == null) {
            this.drawString(matrix, (ITextComponent)MekanismLang.NONE.translateColored(EnumColor.DARK_RED, new Object[0]), 32 + frequencyOffset, 84, this.subheadingTextColor());
            this.drawString(matrix, (ITextComponent)MekanismLang.NONE.translateColored(EnumColor.DARK_RED, new Object[0]), 32 + this.getStringWidth((ITextComponent)securityComponent), 94, this.subheadingTextColor());
        } else {
            this.drawTextScaledBound(matrix, frequency.getName(), 32 + frequencyOffset, 84.0f, this.subheadingTextColor(), this.field_146999_f - 32 - frequencyOffset - 4);
            this.drawString(matrix, this.getSecurity(frequency), 32 + this.getStringWidth((ITextComponent)securityComponent), 94, this.subheadingTextColor());
        }
        this.drawTextScaledBound(matrix, (ITextComponent)MekanismLang.SET.translate(new Object[0]), 27.0f, 107.0f, this.titleTextColor(), 20.0f);
        super.drawForegroundText(matrix, mouseX, mouseY);
    }

    public abstract void sendSetFrequency(Frequency.FrequencyIdentity var1);

    public abstract void sendRemoveFrequency(Frequency.FrequencyIdentity var1);

    public abstract void sendColorUpdate(int var1);

    public abstract QIOFrequency getFrequency();

    public abstract String getOwnerUsername();

    public abstract UUID getOwnerUUID();

    public abstract List<QIOFrequency> getPublicFrequencies();

    public abstract List<QIOFrequency> getPrivateFrequencies();
}

