/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.jei;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mekanism.api.chemical.Chemical;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.math.MathUtils;
import mekanism.api.text.EnumColor;
import mekanism.api.text.TextComponentUtil;
import mekanism.client.render.MekanismRenderer;
import mekanism.common.MekanismLang;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.ingredients.IIngredientRenderer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.WorldVertexBufferUploader;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;

public class ChemicalStackRenderer<STACK extends ChemicalStack<?>>
implements IIngredientRenderer<STACK> {
    private static final NumberFormat nf = NumberFormat.getIntegerInstance();
    protected static final int TEX_WIDTH = 16;
    protected static final int TEX_HEIGHT = 16;
    private static final int MIN_CHEMICAL_HEIGHT = 1;
    private final long capacityMb;
    private final TooltipMode tooltipMode;
    private final int width;
    private final int height;
    @Nullable
    private final IDrawable overlay;

    public ChemicalStackRenderer() {
        this(1000L, TooltipMode.ITEM_LIST, 16, 16, null);
    }

    public ChemicalStackRenderer(long capacityMb, int width, int height) {
        this(capacityMb, TooltipMode.SHOW_AMOUNT, width, height, null);
    }

    public ChemicalStackRenderer(long capacityMb, boolean showCapacity, int width, int height, @Nullable IDrawable overlay) {
        this(capacityMb, showCapacity ? TooltipMode.SHOW_AMOUNT_AND_CAPACITY : TooltipMode.SHOW_AMOUNT, width, height, overlay);
    }

    private ChemicalStackRenderer(long capacityMb, TooltipMode tooltipMode, int width, int height, @Nullable IDrawable overlay) {
        this.capacityMb = capacityMb;
        this.tooltipMode = tooltipMode;
        this.width = width;
        this.height = height;
        this.overlay = overlay;
    }

    public void render(@Nonnull MatrixStack matrix, int xPosition, int yPosition, @Nullable STACK stack) {
        if (stack == null || ((ChemicalStack)stack).isEmpty()) {
            return;
        }
        RenderSystem.enableBlend();
        RenderSystem.enableAlphaTest();
        this.drawChemical(matrix, xPosition, yPosition, stack);
        if (this.overlay != null) {
            matrix.func_227860_a_();
            matrix.func_227861_a_(0.0, 0.0, 200.0);
            this.overlay.draw(matrix, xPosition, yPosition);
            matrix.func_227865_b_();
        }
        RenderSystem.disableAlphaTest();
        RenderSystem.disableBlend();
    }

    private void drawChemical(MatrixStack matrix, int xPosition, int yPosition, @Nonnull STACK stack) {
        int desiredHeight = MathUtils.clampToInt((double)this.height * (double)((ChemicalStack)stack).getAmount() / (double)this.capacityMb);
        if (desiredHeight < 1) {
            desiredHeight = 1;
        }
        if (desiredHeight > this.height) {
            desiredHeight = this.height;
        }
        Object chemical = ((ChemicalStack)stack).getType();
        this.drawTiledSprite(matrix, xPosition, yPosition, this.width, desiredHeight, this.height, (Chemical<?>)chemical);
    }

    private void drawTiledSprite(MatrixStack matrix, int xPosition, int yPosition, int desiredWidth, int desiredHeight, int yOffset, @Nonnull Chemical<?> chemical) {
        if (desiredWidth == 0 || desiredHeight == 0) {
            return;
        }
        Matrix4f matrix4f = matrix.func_227866_c_().func_227870_a_();
        MekanismRenderer.color(chemical);
        TextureAtlasSprite sprite = MekanismRenderer.getSprite(chemical.getIcon());
        MekanismRenderer.bindTexture(AtlasTexture.field_110575_b);
        int xTileCount = desiredWidth / 16;
        int xRemainder = desiredWidth - xTileCount * 16;
        int yTileCount = desiredHeight / 16;
        int yRemainder = desiredHeight - yTileCount * 16;
        int yStart = yPosition + yOffset;
        int zLevel = 100;
        float uMin = sprite.func_94209_e();
        float uMax = sprite.func_94212_f();
        float vMin = sprite.func_94206_g();
        float vMax = sprite.func_94210_h();
        float uDif = uMax - uMin;
        float vDif = vMax - vMin;
        BufferBuilder vertexBuffer = Tessellator.func_178181_a().func_178180_c();
        vertexBuffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        block0: for (int xTile = 0; xTile <= xTileCount; ++xTile) {
            int width;
            int n = width = xTile == xTileCount ? xRemainder : 16;
            if (width == 0) break;
            int x = xPosition + xTile * 16;
            int maskRight = 16 - width;
            int shiftedX = x + 16 - maskRight;
            float uMaxLocal = uMax - uDif * (float)maskRight / 16.0f;
            for (int yTile = 0; yTile <= yTileCount; ++yTile) {
                int height;
                int n2 = height = yTile == yTileCount ? yRemainder : 16;
                if (height == 0) continue block0;
                int y = yStart - (yTile + 1) * 16;
                int maskTop = 16 - height;
                float vMaxLocal = vMax - vDif * (float)maskTop / 16.0f;
                vertexBuffer.func_227888_a_(matrix4f, (float)x, (float)(y + 16), (float)zLevel).func_225583_a_(uMin, vMaxLocal).func_181675_d();
                vertexBuffer.func_227888_a_(matrix4f, (float)shiftedX, (float)(y + 16), (float)zLevel).func_225583_a_(uMaxLocal, vMaxLocal).func_181675_d();
                vertexBuffer.func_227888_a_(matrix4f, (float)shiftedX, (float)(y + maskTop), (float)zLevel).func_225583_a_(uMaxLocal, vMin).func_181675_d();
                vertexBuffer.func_227888_a_(matrix4f, (float)x, (float)(y + maskTop), (float)zLevel).func_225583_a_(uMin, vMin).func_181675_d();
            }
        }
        vertexBuffer.func_178977_d();
        WorldVertexBufferUploader.func_181679_a((BufferBuilder)vertexBuffer);
        MekanismRenderer.resetColor();
    }

    public List<ITextComponent> getTooltip(@Nonnull STACK stack, ITooltipFlag tooltipFlag) {
        Object chemical = ((ChemicalStack)stack).getType();
        if (((Chemical)chemical).isEmptyType()) {
            return Collections.emptyList();
        }
        ArrayList<ITextComponent> tooltip = new ArrayList<ITextComponent>();
        tooltip.add((ITextComponent)TextComponentUtil.build(chemical));
        IFormattableTextComponent component = null;
        if (this.tooltipMode == TooltipMode.SHOW_AMOUNT_AND_CAPACITY) {
            component = MekanismLang.JEI_AMOUNT_WITH_CAPACITY.translateColored(EnumColor.GRAY, nf.format(((ChemicalStack)stack).getAmount()), nf.format(this.capacityMb));
        } else if (this.tooltipMode == TooltipMode.SHOW_AMOUNT) {
            component = MekanismLang.GENERIC_MB.translateColored(EnumColor.GRAY, nf.format(((ChemicalStack)stack).getAmount()));
        }
        if (component != null) {
            tooltip.add((ITextComponent)component);
        }
        return tooltip;
    }

    public FontRenderer getFontRenderer(Minecraft minecraft, @Nonnull STACK stack) {
        return minecraft.field_71466_p;
    }

    static enum TooltipMode {
        SHOW_AMOUNT,
        SHOW_AMOUNT_AND_CAPACITY,
        ITEM_LIST;

    }
}

