/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.render;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mekanism.api.MekanismAPI;
import mekanism.api.chemical.Chemical;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.text.EnumColor;
import mekanism.api.tier.BaseTier;
import mekanism.client.SpecialColors;
import mekanism.client.model.baked.DigitalMinerBakedModel;
import mekanism.client.render.ModelRenderer;
import mekanism.client.render.RenderResizableCuboid;
import mekanism.client.render.RenderTickHandler;
import mekanism.client.render.data.FluidRenderData;
import mekanism.client.render.data.ValveRenderData;
import mekanism.client.render.item.block.RenderFluidTankItem;
import mekanism.client.render.lib.ColorAtlas;
import mekanism.client.render.tileentity.RenderDigitalMiner;
import mekanism.client.render.tileentity.RenderFluidTank;
import mekanism.client.render.tileentity.RenderTeleporter;
import mekanism.client.render.transmitter.RenderLogisticalTransporter;
import mekanism.client.render.transmitter.RenderMechanicalPipe;
import mekanism.client.render.transmitter.RenderTransmitterBase;
import mekanism.common.Mekanism;
import mekanism.common.lib.Color;
import mekanism.common.lib.multiblock.IValveHandler;
import mekanism.common.lib.transmitter.TransmissionType;
import mekanism.common.util.EnumUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.fluid.Fluid;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.client.model.obj.OBJLoader;
import net.minecraftforge.client.model.obj.OBJModel;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.IForgeRegistry;

@Mod.EventBusSubscriber(modid="mekanism", value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.MOD)
public class MekanismRenderer {
    public static final int FULL_LIGHT = 0xF000F0;
    public static OBJModel contentsModel;
    public static TextureAtlasSprite energyIcon;
    public static TextureAtlasSprite heatIcon;
    public static TextureAtlasSprite whiteIcon;
    public static TextureAtlasSprite redstoneTorch;
    public static TextureAtlasSprite redstonePulse;
    public static final Map<TransmissionType, TextureAtlasSprite> overlays;

    public static TextureAtlasSprite getBaseFluidTexture(@Nonnull Fluid fluid, @Nonnull FluidType type) {
        ResourceLocation spriteLocation = type == FluidType.STILL ? fluid.getAttributes().getStillTexture() : fluid.getAttributes().getFlowingTexture();
        return MekanismRenderer.getSprite(spriteLocation);
    }

    public static TextureAtlasSprite getFluidTexture(@Nonnull FluidStack fluidStack, @Nonnull FluidType type) {
        Fluid fluid = fluidStack.getFluid();
        ResourceLocation spriteLocation = type == FluidType.STILL ? fluid.getAttributes().getStillTexture(fluidStack) : fluid.getAttributes().getFlowingTexture(fluidStack);
        return MekanismRenderer.getSprite(spriteLocation);
    }

    public static TextureAtlasSprite getChemicalTexture(@Nonnull Chemical<?> chemical) {
        return MekanismRenderer.getSprite(chemical.getIcon());
    }

    public static TextureAtlasSprite getSprite(ResourceLocation spriteLocation) {
        return (TextureAtlasSprite)Minecraft.func_71410_x().func_228015_a_(AtlasTexture.field_110575_b).apply(spriteLocation);
    }

    public static void prepFlowing(Model3D model, @Nonnull FluidStack fluid) {
        TextureAtlasSprite still = MekanismRenderer.getFluidTexture(fluid, FluidType.STILL);
        TextureAtlasSprite flowing = MekanismRenderer.getFluidTexture(fluid, FluidType.FLOWING);
        model.setTextures(still, still, flowing, flowing, flowing, flowing);
    }

    public static void renderObject(@Nullable Model3D object, @Nonnull MatrixStack matrix, IVertexBuilder buffer, int argb, int light, int overlay) {
        if (object != null) {
            RenderResizableCuboid.INSTANCE.renderCube(object, matrix, buffer, argb, light, overlay);
        }
    }

    public static void renderValves(MatrixStack matrix, IVertexBuilder buffer, Set<IValveHandler.ValveData> valves, FluidRenderData data, BlockPos pos, int glow, int overlay) {
        for (IValveHandler.ValveData valveData : valves) {
            matrix.func_227860_a_();
            matrix.func_227861_a_((double)(valveData.location.func_177958_n() - pos.func_177958_n()), (double)(valveData.location.func_177956_o() - pos.func_177956_o()), (double)(valveData.location.func_177952_p() - pos.func_177952_p()));
            MekanismRenderer.renderObject(ModelRenderer.getValveModel(ValveRenderData.get(data, valveData)), matrix, buffer, data.getColorARGB(), glow, overlay);
            matrix.func_227865_b_();
        }
    }

    public static void bindTexture(ResourceLocation texture) {
        Minecraft.func_71410_x().field_71446_o.func_110577_a(texture);
    }

    public static void resetColor() {
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public static float getRed(int color) {
        return (float)(color >> 16 & 0xFF) / 255.0f;
    }

    public static float getGreen(int color) {
        return (float)(color >> 8 & 0xFF) / 255.0f;
    }

    public static float getBlue(int color) {
        return (float)(color & 0xFF) / 255.0f;
    }

    public static float getAlpha(int color) {
        return (float)(color >> 24 & 0xFF) / 255.0f;
    }

    public static void color(int color) {
        RenderSystem.color4f((float)MekanismRenderer.getRed(color), (float)MekanismRenderer.getGreen(color), (float)MekanismRenderer.getBlue(color), (float)MekanismRenderer.getAlpha(color));
    }

    public static void color(ColorAtlas.ColorRegistryObject colorRO) {
        MekanismRenderer.color(colorRO.get());
    }

    public static void color(Color color) {
        RenderSystem.color4f((float)color.rf(), (float)color.gf(), (float)color.bf(), (float)color.af());
    }

    public static void color(@Nonnull FluidStack fluid) {
        if (!fluid.isEmpty()) {
            MekanismRenderer.color(fluid.getFluid().getAttributes().getColor(fluid));
        }
    }

    public static void color(@Nonnull ChemicalStack<?> chemicalStack) {
        if (!chemicalStack.isEmpty()) {
            MekanismRenderer.color(chemicalStack.getType());
        }
    }

    public static void color(@Nonnull Chemical<?> chemical) {
        if (!chemical.isEmptyType()) {
            int color = chemical.getTint();
            RenderSystem.color3f((float)MekanismRenderer.getRed(color), (float)MekanismRenderer.getGreen(color), (float)MekanismRenderer.getBlue(color));
        }
    }

    public static void color(@Nonnull BaseTier tier) {
        MekanismRenderer.color(tier.getColor());
    }

    public static void color(@Nullable EnumColor color) {
        MekanismRenderer.color(color, 1.0f);
    }

    public static void color(@Nullable EnumColor color, float alpha) {
        MekanismRenderer.color(color, alpha, 1.0f);
    }

    public static void color(@Nullable EnumColor color, float alpha, float multiplier) {
        if (color != null) {
            RenderSystem.color4f((float)(color.getColor(0) * multiplier), (float)(color.getColor(1) * multiplier), (float)(color.getColor(2) * multiplier), (float)alpha);
        }
    }

    public static int getColorARGB(EnumColor color, float alpha) {
        return MekanismRenderer.getColorARGB(color.getRgbCode()[0], color.getRgbCode()[1], color.getRgbCode()[2], alpha);
    }

    public static int getColorARGB(@Nonnull FluidStack fluidStack) {
        return fluidStack.getFluid().getAttributes().getColor(fluidStack);
    }

    public static int getColorARGB(@Nonnull FluidStack fluidStack, float fluidScale) {
        if (fluidStack.isEmpty()) {
            return -1;
        }
        int color = MekanismRenderer.getColorARGB(fluidStack);
        if (fluidStack.getFluid().getAttributes().isGaseous(fluidStack)) {
            return MekanismRenderer.getColorARGB(MekanismRenderer.getRed(color), MekanismRenderer.getGreen(color), MekanismRenderer.getBlue(color), Math.min(1.0f, fluidScale + 0.2f));
        }
        return color;
    }

    public static int getColorARGB(@Nonnull ChemicalStack<?> stack, float scale, boolean gaseous) {
        if (stack.isEmpty()) {
            return -1;
        }
        int color = stack.getChemicalTint();
        return MekanismRenderer.getColorARGB(MekanismRenderer.getRed(color), MekanismRenderer.getGreen(color), MekanismRenderer.getBlue(color), gaseous ? Math.min(1.0f, scale + 0.2f) : 1.0f);
    }

    public static int getColorARGB(float red, float green, float blue, float alpha) {
        return MekanismRenderer.getColorARGB((int)(255.0f * red), (int)(255.0f * green), (int)(255.0f * blue), alpha);
    }

    public static int getColorARGB(int red, int green, int blue, float alpha) {
        if (alpha < 0.0f) {
            alpha = 0.0f;
        } else if (alpha > 1.0f) {
            alpha = 1.0f;
        }
        int argb = (int)(255.0f * alpha) << 24;
        argb |= red << 16;
        argb |= green << 8;
        return argb |= blue;
    }

    public static int calculateGlowLight(int light, @Nonnull FluidStack fluid) {
        return fluid.isEmpty() ? light : MekanismRenderer.calculateGlowLight(light, fluid.getFluid().getAttributes().getLuminosity(fluid));
    }

    public static int calculateGlowLight(int light, int glow) {
        if (glow >= 15) {
            return 0xF000F0;
        }
        int blockLight = LightTexture.func_228450_a_((int)light);
        int skyLight = LightTexture.func_228454_b_((int)light);
        return LightTexture.func_228451_a_((int)Math.max(blockLight, glow), (int)Math.max(skyLight, glow));
    }

    public static void renderColorOverlay(MatrixStack matrix, int x, int y, int width, int height, int color) {
        float r = (float)(color >> 24 & 0xFF) / 255.0f;
        float g = (float)(color >> 16 & 0xFF) / 255.0f;
        float b = (float)(color >> 8 & 0xFF) / 255.0f;
        float a = (float)(color & 0xFF) / 255.0f;
        RenderSystem.disableTexture();
        RenderSystem.enableBlend();
        RenderSystem.disableAlphaTest();
        RenderSystem.defaultBlendFunc();
        RenderSystem.shadeModel((int)7425);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181706_f);
        Matrix4f matrix4f = matrix.func_227866_c_().func_227870_a_();
        bufferbuilder.func_227888_a_(matrix4f, (float)width, (float)y, 0.0f).func_227885_a_(r, g, b, a).func_181675_d();
        bufferbuilder.func_227888_a_(matrix4f, (float)x, (float)y, 0.0f).func_227885_a_(r, g, b, a).func_181675_d();
        bufferbuilder.func_227888_a_(matrix4f, (float)x, (float)height, 0.0f).func_227885_a_(r, g, b, a).func_181675_d();
        bufferbuilder.func_227888_a_(matrix4f, (float)width, (float)height, 0.0f).func_227885_a_(r, g, b, a).func_181675_d();
        tessellator.func_78381_a();
        RenderSystem.shadeModel((int)7424);
        RenderSystem.disableBlend();
        RenderSystem.enableAlphaTest();
        RenderSystem.enableTexture();
    }

    public static float getPartialTick() {
        return Minecraft.func_71410_x().func_184121_ak();
    }

    public static void rotate(MatrixStack matrix, Direction facing, float north, float south, float west, float east) {
        switch (facing) {
            case NORTH: {
                matrix.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(north));
                break;
            }
            case SOUTH: {
                matrix.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(south));
                break;
            }
            case WEST: {
                matrix.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(west));
                break;
            }
            case EAST: {
                matrix.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(east));
            }
        }
    }

    @SubscribeEvent
    public static void onModelBake(ModelBakeEvent event) {
        try {
            contentsModel = OBJLoader.INSTANCE.loadModel(new OBJModel.ModelSettings(RenderTransmitterBase.MODEL_LOCATION, true, false, true, true, null));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @SubscribeEvent
    public static void onStitch(TextureStitchEvent.Pre event) {
        if (!event.getMap().func_229223_g_().equals((Object)AtlasTexture.field_110575_b)) {
            return;
        }
        for (TransmissionType type : EnumUtils.TRANSMISSION_TYPES) {
            event.addSprite(Mekanism.rl("block/overlay/" + type.getTransmission() + "_overlay"));
        }
        event.addSprite(Mekanism.rl("block/overlay/overlay_white"));
        event.addSprite(Mekanism.rl("liquid/energy"));
        event.addSprite(Mekanism.rl("liquid/heat"));
        event.addSprite(Mekanism.rl("icon/redstone_control_pulse"));
        event.addSprite(Mekanism.rl("entity/armor/blank"));
        event.addSprite(Mekanism.rl("entity/armor/mekasuit_player"));
        event.addSprite(Mekanism.rl("entity/armor/mekasuit_armor_body"));
        event.addSprite(Mekanism.rl("entity/armor/mekasuit_armor_helmet"));
        event.addSprite(Mekanism.rl("entity/armor/mekasuit_armor_exoskeleton"));
        event.addSprite(Mekanism.rl("entity/armor/mekasuit_gravitational_modulator"));
        event.addSprite(Mekanism.rl("entity/armor/mekasuit_armor_modules"));
        event.addSprite(Mekanism.rl("entity/armor/mekatool"));
        DigitalMinerBakedModel.preStitch(event);
        MekanismRenderer.addChemicalSprites(event, MekanismAPI.gasRegistry());
        MekanismRenderer.addChemicalSprites(event, MekanismAPI.infuseTypeRegistry());
        MekanismRenderer.addChemicalSprites(event, MekanismAPI.pigmentRegistry());
        MekanismRenderer.addChemicalSprites(event, MekanismAPI.slurryRegistry());
        ModelRenderer.resetCachedModels();
        RenderDigitalMiner.resetCachedVisuals();
        RenderFluidTank.resetCachedModels();
        RenderFluidTankItem.resetCachedModels();
        RenderMechanicalPipe.onStitch();
        RenderTickHandler.resetCached();
        RenderTeleporter.resetCachedModels();
        MekanismRenderer.parseColorAtlas(Mekanism.rl("textures/colormap/primary.png"));
        SpecialColors.GUI_OBJECTS.parse(Mekanism.rl("textures/colormap/gui_objects.png"));
        SpecialColors.GUI_TEXT.parse(Mekanism.rl("textures/colormap/gui_text.png"));
    }

    private static void parseColorAtlas(ResourceLocation rl) {
        EnumColor[] colors = EnumColor.values();
        List<Color> parsed = ColorAtlas.load(rl, colors.length);
        if (parsed.size() < colors.length) {
            Mekanism.logger.error("Failed to parse primary color atlas.");
            return;
        }
        for (int i = 0; i < colors.length; ++i) {
            colors[i].setColorFromAtlas(parsed.get(i).rgbArray());
        }
    }

    private static <CHEMICAL extends Chemical<CHEMICAL>> void addChemicalSprites(TextureStitchEvent.Pre event, IForgeRegistry<CHEMICAL> chemicalRegistry) {
        for (Chemical chemical : chemicalRegistry.getValues()) {
            event.addSprite(chemical.getIcon());
        }
    }

    @SubscribeEvent
    public static void onStitch(TextureStitchEvent.Post event) {
        AtlasTexture map = event.getMap();
        if (!map.func_229223_g_().equals((Object)AtlasTexture.field_110575_b)) {
            return;
        }
        for (TransmissionType type : EnumUtils.TRANSMISSION_TYPES) {
            overlays.put(type, map.func_195424_a(Mekanism.rl("block/overlay/" + type.getTransmission() + "_overlay")));
        }
        whiteIcon = map.func_195424_a(Mekanism.rl("block/overlay/overlay_white"));
        energyIcon = map.func_195424_a(Mekanism.rl("liquid/energy"));
        heatIcon = map.func_195424_a(Mekanism.rl("liquid/heat"));
        redstoneTorch = map.func_195424_a(new ResourceLocation("minecraft:block/redstone_torch"));
        redstonePulse = map.func_195424_a(Mekanism.rl("icon/redstone_control_pulse"));
        DigitalMinerBakedModel.onStitch(event);
        RenderLogisticalTransporter.onStitch(map);
        RenderTransmitterBase.onStitch();
    }

    static {
        overlays = new EnumMap<TransmissionType, TextureAtlasSprite>(TransmissionType.class);
    }

    public static class Model3D {
        public double minX;
        public double minY;
        public double minZ;
        public double maxX;
        public double maxY;
        public double maxZ;
        public final TextureAtlasSprite[] textures = new TextureAtlasSprite[6];
        public final boolean[] renderSides = new boolean[]{true, true, true, true, true, true, false};

        public double sizeX() {
            return this.maxX - this.minX;
        }

        public double sizeY() {
            return this.maxY - this.minY;
        }

        public double sizeZ() {
            return this.maxZ - this.minZ;
        }

        public void setSideRender(Direction side, boolean value) {
            this.renderSides[side.ordinal()] = value;
        }

        public boolean shouldSideRender(Direction side) {
            return this.renderSides[side.ordinal()];
        }

        public void setTexture(TextureAtlasSprite tex) {
            Arrays.fill(this.textures, tex);
        }

        public void setTextures(TextureAtlasSprite down, TextureAtlasSprite up, TextureAtlasSprite north, TextureAtlasSprite south, TextureAtlasSprite west, TextureAtlasSprite east) {
            this.textures[0] = down;
            this.textures[1] = up;
            this.textures[2] = north;
            this.textures[3] = south;
            this.textures[4] = west;
            this.textures[5] = east;
        }
    }

    public static enum FluidType {
        STILL,
        FLOWING;

    }
}

