/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.render;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.Arrays;
import mekanism.client.render.MekanismRenderer;
import mekanism.common.util.EnumUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.Direction;
import net.minecraft.util.math.vector.Matrix3f;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.util.math.vector.Vector3i;

public class RenderResizableCuboid {
    public static final RenderResizableCuboid INSTANCE = new RenderResizableCuboid();
    private static final Vector3f VEC_ZERO = new Vector3f(0.0f, 0.0f, 0.0f);
    private static final int U_MIN = 0;
    private static final int U_MAX = 1;
    private static final int V_MIN = 2;
    private static final int V_MAX = 3;
    protected EntityRendererManager manager = Minecraft.func_71410_x().func_175598_ae();

    private static Vector3f withValue(Vector3f vector, Direction.Axis axis, float value) {
        if (axis == Direction.Axis.X) {
            return new Vector3f(value, vector.func_195900_b(), vector.func_195902_c());
        }
        if (axis == Direction.Axis.Y) {
            return new Vector3f(vector.func_195899_a(), value, vector.func_195902_c());
        }
        if (axis == Direction.Axis.Z) {
            return new Vector3f(vector.func_195899_a(), vector.func_195900_b(), value);
        }
        throw new RuntimeException("Was given a null axis! That was probably not intentional, consider this a bug! (Vector = " + vector + ")");
    }

    public static double getValue(Vector3d vector, Direction.Axis axis) {
        if (axis == Direction.Axis.X) {
            return vector.field_72450_a;
        }
        if (axis == Direction.Axis.Y) {
            return vector.field_72448_b;
        }
        if (axis == Direction.Axis.Z) {
            return vector.field_72449_c;
        }
        throw new RuntimeException("Was given a null axis! That was probably not intentional, consider this a bug! (Vector = " + vector + ")");
    }

    public void renderCube(MekanismRenderer.Model3D cube, MatrixStack matrix, IVertexBuilder buffer, int argb, int light, int overlay) {
        float red = MekanismRenderer.getRed(argb);
        float green = MekanismRenderer.getGreen(argb);
        float blue = MekanismRenderer.getBlue(argb);
        float alpha = MekanismRenderer.getAlpha(argb);
        Vector3d size = new Vector3d(cube.sizeX(), cube.sizeY(), cube.sizeZ());
        matrix.func_227860_a_();
        matrix.func_227861_a_(cube.minX, cube.minY, cube.minZ);
        MatrixStack.Entry lastMatrix = matrix.func_227866_c_();
        Matrix4f matrix4f = lastMatrix.func_227870_a_();
        Matrix3f normal = lastMatrix.func_227872_b_();
        for (Direction face : EnumUtils.DIRECTIONS) {
            int ordinal;
            TextureAtlasSprite sprite;
            if (!cube.shouldSideRender(face) || (sprite = cube.textures[ordinal = face.ordinal()]) == null) continue;
            Direction.Axis u = face.func_176740_k() == Direction.Axis.X ? Direction.Axis.Z : Direction.Axis.X;
            Direction.Axis v = face.func_176740_k() == Direction.Axis.Y ? Direction.Axis.Z : Direction.Axis.Y;
            float other = face.func_176743_c() == Direction.AxisDirection.POSITIVE ? (float)RenderResizableCuboid.getValue(size, face.func_176740_k()) : 0.0f;
            face = face.func_176743_c() == Direction.AxisDirection.NEGATIVE ? face : face.func_176734_d();
            Direction opposite = face.func_176734_d();
            float minU = sprite.func_94209_e();
            float maxU = sprite.func_94212_f();
            float minV = sprite.func_94210_h();
            float maxV = sprite.func_94206_g();
            double sizeU = RenderResizableCuboid.getValue(size, u);
            double sizeV = RenderResizableCuboid.getValue(size, v);
            int uIndex = 0;
            while ((double)uIndex < sizeU) {
                float[] baseUV = new float[]{minU, maxU, minV, maxV};
                double addU = 1.0;
                if ((double)uIndex + addU > sizeU) {
                    addU = sizeU - (double)uIndex;
                    baseUV[1] = baseUV[0] + (baseUV[1] - baseUV[0]) * (float)addU;
                }
                int vIndex = 0;
                while ((double)vIndex < sizeV) {
                    float[] uv = Arrays.copyOf(baseUV, 4);
                    double addV = 1.0;
                    if ((double)vIndex + addV > sizeV) {
                        addV = sizeV - (double)vIndex;
                        uv[3] = uv[2] + (uv[3] - uv[2]) * (float)addV;
                    }
                    float[] xyz = new float[]{uIndex, (float)((double)uIndex + addU), vIndex, (float)((double)vIndex + addV)};
                    this.renderPoint(matrix4f, normal, buffer, face, u, v, other, uv, xyz, true, false, red, green, blue, alpha, light, overlay);
                    this.renderPoint(matrix4f, normal, buffer, face, u, v, other, uv, xyz, true, true, red, green, blue, alpha, light, overlay);
                    this.renderPoint(matrix4f, normal, buffer, face, u, v, other, uv, xyz, false, true, red, green, blue, alpha, light, overlay);
                    this.renderPoint(matrix4f, normal, buffer, face, u, v, other, uv, xyz, false, false, red, green, blue, alpha, light, overlay);
                    this.renderPoint(matrix4f, normal, buffer, opposite, u, v, other, uv, xyz, false, false, red, green, blue, alpha, light, overlay);
                    this.renderPoint(matrix4f, normal, buffer, opposite, u, v, other, uv, xyz, false, true, red, green, blue, alpha, light, overlay);
                    this.renderPoint(matrix4f, normal, buffer, opposite, u, v, other, uv, xyz, true, true, red, green, blue, alpha, light, overlay);
                    this.renderPoint(matrix4f, normal, buffer, opposite, u, v, other, uv, xyz, true, false, red, green, blue, alpha, light, overlay);
                    ++vIndex;
                }
                ++uIndex;
            }
        }
        matrix.func_227865_b_();
    }

    private void renderPoint(Matrix4f matrix4f, Matrix3f normal, IVertexBuilder buffer, Direction face, Direction.Axis u, Direction.Axis v, float other, float[] uv, float[] xyz, boolean minU, boolean minV, float red, float green, float blue, float alpha, int light, int overlay) {
        int U_ARRAY = minU ? 0 : 1;
        int V_ARRAY = minV ? 2 : 3;
        Vector3f vertex = RenderResizableCuboid.withValue(VEC_ZERO, u, xyz[U_ARRAY]);
        vertex = RenderResizableCuboid.withValue(vertex, v, xyz[V_ARRAY]);
        vertex = RenderResizableCuboid.withValue(vertex, face.func_176740_k(), other);
        Vector3i normalForFace = face.func_176730_m();
        float adjustment = 2.5f;
        Vector3f norm = new Vector3f((float)normalForFace.func_177958_n() + adjustment, (float)normalForFace.func_177956_o() + adjustment, (float)normalForFace.func_177952_p() + adjustment);
        norm.func_229194_d_();
        buffer.func_227888_a_(matrix4f, vertex.func_195899_a(), vertex.func_195900_b(), vertex.func_195902_c()).func_227885_a_(red, green, blue, alpha).func_225583_a_(uv[U_ARRAY], uv[V_ARRAY]).func_227891_b_(overlay).func_227886_a_(light).func_227887_a_(normal, norm.func_195899_a(), norm.func_195900_b(), norm.func_195902_c()).func_181675_d();
    }
}

