/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.base;

import com.mojang.authlib.GameProfile;
import java.lang.ref.WeakReference;
import java.util.UUID;
import java.util.function.Function;
import javax.annotation.Nonnull;
import mekanism.common.Mekanism;
import mekanism.common.util.MekanismUtils;
import net.minecraft.potion.EffectInstance;
import net.minecraft.world.IWorld;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.util.FakePlayer;

public class MekFakePlayer
extends FakePlayer {
    private static WeakReference<MekFakePlayer> INSTANCE;
    private UUID emulatingUUID = null;
    private final FakeGameProfile gameProfile = new FakeGameProfile();

    public MekFakePlayer(ServerWorld world) {
        super(world, Mekanism.gameProfile);
    }

    public boolean func_70687_e(@Nonnull EffectInstance effect) {
        return false;
    }

    public void setEmulatingUUID(UUID uuid) {
        this.emulatingUUID = uuid;
    }

    @Nonnull
    public UUID func_110124_au() {
        return this.emulatingUUID != null ? this.emulatingUUID : super.func_110124_au();
    }

    @Nonnull
    public GameProfile func_146103_bH() {
        return this.gameProfile;
    }

    public static <R> R withFakePlayer(ServerWorld world, Function<MekFakePlayer, R> fakePlayerConsumer) {
        MekFakePlayer actual;
        MekFakePlayer mekFakePlayer = actual = INSTANCE != null ? (MekFakePlayer)((Object)INSTANCE.get()) : null;
        if (actual == null) {
            actual = new MekFakePlayer(world);
            INSTANCE = new WeakReference<MekFakePlayer>(actual);
        }
        MekFakePlayer player = actual;
        player.field_70170_p = world;
        R result = fakePlayerConsumer.apply(player);
        player.emulatingUUID = null;
        player.field_70170_p = null;
        return result;
    }

    public static <R> R withFakePlayer(ServerWorld world, double x, double y, double z, Function<MekFakePlayer, R> fakePlayerConsumer) {
        return (R)MekFakePlayer.withFakePlayer(world, fakePlayer -> {
            fakePlayer.func_226288_n_(x, y, z);
            return fakePlayerConsumer.apply((MekFakePlayer)((Object)fakePlayer));
        });
    }

    public static void releaseInstance(IWorld world) {
        MekFakePlayer actual;
        MekFakePlayer mekFakePlayer = actual = INSTANCE != null ? (MekFakePlayer)((Object)INSTANCE.get()) : null;
        if (actual != null && actual.field_70170_p == world) {
            actual.field_70170_p = null;
        }
    }

    private class FakeGameProfile
    extends GameProfile {
        public FakeGameProfile() {
            super(Mekanism.gameProfile.getId(), Mekanism.gameProfile.getName());
        }

        public UUID getId() {
            return MekFakePlayer.this.emulatingUUID != null ? MekFakePlayer.this.emulatingUUID : super.getId();
        }

        public String getName() {
            return MekFakePlayer.this.emulatingUUID != null ? MekanismUtils.getLastKnownUsername(MekFakePlayer.this.emulatingUUID) : super.getName();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof GameProfile)) {
                return false;
            }
            GameProfile that = (GameProfile)o;
            if (this.getId() != null ? !this.getId().equals(that.getId()) : that.getId() != null) {
                return false;
            }
            return this.getName() != null ? this.getName().equals(that.getName()) : that.getName() == null;
        }

        public int hashCode() {
            int result = this.getId() != null ? this.getId().hashCode() : 0;
            result = 31 * result + (this.getName() != null ? this.getName().hashCode() : 0);
            return result;
        }
    }
}

