/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.capabilities.merged;

import java.util.Collections;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import mekanism.api.DataHandlerUtils;
import mekanism.api.chemical.gas.IGasTank;
import mekanism.api.chemical.infuse.IInfusionTank;
import mekanism.api.chemical.merged.MergedChemicalTank;
import mekanism.api.chemical.pigment.IPigmentTank;
import mekanism.api.chemical.slurry.ISlurryTank;
import mekanism.common.capabilities.Capabilities;
import mekanism.common.capabilities.CapabilityCache;
import mekanism.common.capabilities.ItemCapabilityWrapper;
import mekanism.common.capabilities.chemical.dynamic.DynamicChemicalHandler;
import mekanism.common.capabilities.resolver.basic.BasicCapabilityResolver;
import mekanism.common.util.ItemDataUtils;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraftforge.common.util.INBTSerializable;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public abstract class MergedTankContentsHandler<MERGED extends MergedChemicalTank>
extends ItemCapabilityWrapper.ItemCapability {
    protected MERGED mergedTank;
    protected DynamicChemicalHandler.DynamicGasHandler gasHandler;
    protected DynamicChemicalHandler.DynamicInfusionHandler infusionHandler;
    protected DynamicChemicalHandler.DynamicPigmentHandler pigmentHandler;
    protected DynamicChemicalHandler.DynamicSlurryHandler slurryHandler;
    protected List<ISlurryTank> slurryTanks;
    protected List<IPigmentTank> pigmentTanks;
    protected List<IInfusionTank> infusionTanks;
    protected List<IGasTank> gasTanks;

    @Override
    protected void init() {
        super.init();
        this.gasTanks = Collections.singletonList(((MergedChemicalTank)this.mergedTank).getGasTank());
        this.infusionTanks = Collections.singletonList(((MergedChemicalTank)this.mergedTank).getInfusionTank());
        this.pigmentTanks = Collections.singletonList(((MergedChemicalTank)this.mergedTank).getPigmentTank());
        this.slurryTanks = Collections.singletonList(((MergedChemicalTank)this.mergedTank).getSlurryTank());
    }

    @Override
    protected void load() {
        super.load();
        ItemStack stack = this.getStack();
        if (!stack.func_190926_b()) {
            DataHandlerUtils.readContainers(this.gasTanks, ItemDataUtils.getList(stack, "GasTanks"));
            DataHandlerUtils.readContainers(this.infusionTanks, ItemDataUtils.getList(stack, "InfusionTanks"));
            DataHandlerUtils.readContainers(this.pigmentTanks, ItemDataUtils.getList(stack, "PigmentTanks"));
            DataHandlerUtils.readContainers(this.slurryTanks, ItemDataUtils.getList(stack, "SlurryTanks"));
        }
    }

    protected void onContentsChanged(String key, List<? extends INBTSerializable<CompoundNBT>> containers) {
        ItemStack stack = this.getStack();
        if (!stack.func_190926_b()) {
            ItemDataUtils.setList(stack, key, DataHandlerUtils.writeContainers(containers));
        }
    }

    @Override
    protected void addCapabilityResolvers(CapabilityCache capabilityCache) {
        capabilityCache.addCapabilityResolver(BasicCapabilityResolver.constant(Capabilities.GAS_HANDLER_CAPABILITY, this.gasHandler));
        capabilityCache.addCapabilityResolver(BasicCapabilityResolver.constant(Capabilities.INFUSION_HANDLER_CAPABILITY, this.infusionHandler));
        capabilityCache.addCapabilityResolver(BasicCapabilityResolver.constant(Capabilities.PIGMENT_HANDLER_CAPABILITY, this.pigmentHandler));
        capabilityCache.addCapabilityResolver(BasicCapabilityResolver.constant(Capabilities.SLURRY_HANDLER_CAPABILITY, this.slurryHandler));
    }
}

