/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.command;

import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import mekanism.api.text.ILangEntry;
import mekanism.common.MekanismLang;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.Util;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.server.ServerChunkProvider;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.ChunkEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class ChunkCommand {
    private static final LongSet chunkWatchers = new LongOpenHashSet();

    private ChunkCommand() {
    }

    static ArgumentBuilder<CommandSource, ?> register() {
        MinecraftForge.EVENT_BUS.register(ChunkCommand.class);
        return ((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.func_197057_a((String)"chunk").then(WatchCommand.register())).then(UnwatchCommand.register())).then(ClearCommand.register())).then(FlushCommand.register());
    }

    @SubscribeEvent
    public static void onChunkLoad(ChunkEvent.Load event) {
        ChunkCommand.handleChunkEvent((ChunkEvent)event, MekanismLang.COMMAND_CHUNK_LOADED);
    }

    @SubscribeEvent
    public static void onChunkUnload(ChunkEvent.Unload event) {
        ChunkCommand.handleChunkEvent((ChunkEvent)event, MekanismLang.COMMAND_CHUNK_UNLOADED);
    }

    private static void handleChunkEvent(ChunkEvent event, ILangEntry direction) {
        if (event.getWorld() == null || event.getWorld().func_201670_d()) {
            return;
        }
        ChunkPos pos = event.getChunk().func_76632_l();
        if (chunkWatchers.contains(pos.func_201841_a())) {
            TranslationTextComponent message = MekanismLang.COMMAND_CHUNK.translate(direction, pos.field_77276_a, pos.field_77275_b);
            event.getWorld().func_217369_A().forEach(arg_0 -> ChunkCommand.lambda$handleChunkEvent$0((ITextComponent)message, arg_0));
        }
    }

    private static /* synthetic */ void lambda$handleChunkEvent$0(ITextComponent message, PlayerEntity player) {
        player.func_145747_a(message, Util.field_240973_b_);
    }

    private static class FlushCommand {
        private FlushCommand() {
        }

        static ArgumentBuilder<CommandSource, ?> register() {
            return ((LiteralArgumentBuilder)Commands.func_197057_a((String)"flush").requires(cs -> cs.func_197034_c(2))).executes(ctx -> {
                CommandSource source = (CommandSource)ctx.getSource();
                ServerChunkProvider sp = source.func_197023_e().func_72863_F();
                int startCount = sp.func_73152_e();
                sp.func_217207_a(() -> false);
                ((CommandSource)ctx.getSource()).func_197030_a((ITextComponent)MekanismLang.COMMAND_CHUNK_FLUSH.translate(startCount - sp.func_73152_e()), true);
                return 0;
            });
        }
    }

    private static class ClearCommand {
        private ClearCommand() {
        }

        static ArgumentBuilder<CommandSource, ?> register() {
            return ((LiteralArgumentBuilder)Commands.func_197057_a((String)"clear").requires(cs -> cs.func_197034_c(2))).executes(ctx -> {
                int count = chunkWatchers.size();
                chunkWatchers.clear();
                ((CommandSource)ctx.getSource()).func_197030_a((ITextComponent)MekanismLang.COMMAND_CHUNK_CLEAR.translate(count), true);
                return 0;
            });
        }
    }

    private static class UnwatchCommand {
        private UnwatchCommand() {
        }

        static ArgumentBuilder<CommandSource, ?> register() {
            return ((LiteralArgumentBuilder)Commands.func_197057_a((String)"unwatch").requires(cs -> cs.func_197034_c(2))).executes(ctx -> {
                CommandSource source = (CommandSource)ctx.getSource();
                Entity entity = source.func_197022_f();
                ChunkPos chunkPos = new ChunkPos(entity.func_233580_cy_());
                chunkWatchers.remove(ChunkPos.func_77272_a((int)chunkPos.field_77276_a, (int)chunkPos.field_77275_b));
                source.func_197030_a((ITextComponent)MekanismLang.COMMAND_CHUNK_UNWATCH.translate(chunkPos.field_77276_a, chunkPos.field_77275_b), true);
                return 0;
            });
        }
    }

    private static class WatchCommand {
        private WatchCommand() {
        }

        static ArgumentBuilder<CommandSource, ?> register() {
            return ((LiteralArgumentBuilder)Commands.func_197057_a((String)"watch").requires(cs -> cs.func_197034_c(2))).executes(ctx -> {
                CommandSource source = (CommandSource)ctx.getSource();
                Entity entity = source.func_197022_f();
                ChunkPos chunkPos = new ChunkPos(entity.func_233580_cy_());
                chunkWatchers.add(ChunkPos.func_77272_a((int)chunkPos.field_77276_a, (int)chunkPos.field_77275_b));
                source.func_197030_a((ITextComponent)MekanismLang.COMMAND_CHUNK_WATCH.translate(chunkPos.field_77276_a, chunkPos.field_77275_b), true);
                return 0;
            });
        }
    }
}

