/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.content.gear;

import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import mekanism.api.text.IHasTranslationKey;
import mekanism.api.text.ILangEntry;
import mekanism.common.Mekanism;
import mekanism.common.MekanismLang;
import mekanism.common.content.gear.IModuleContainerItem;
import mekanism.common.content.gear.Module;
import mekanism.common.content.gear.mekasuit.ModuleChargeDistributionUnit;
import mekanism.common.content.gear.mekasuit.ModuleJetpackUnit;
import mekanism.common.content.gear.mekasuit.ModuleLocomotiveBoostingUnit;
import mekanism.common.content.gear.mekasuit.ModuleMagneticAttractionUnit;
import mekanism.common.content.gear.mekasuit.ModuleMekaSuit;
import mekanism.common.content.gear.mekatool.ModuleExcavationEscalationUnit;
import mekanism.common.content.gear.mekatool.ModuleFarmingUnit;
import mekanism.common.content.gear.mekatool.ModuleMekaTool;
import mekanism.common.content.gear.mekatool.ModuleVeinMiningUnit;
import mekanism.common.content.gear.shared.ModuleEnergyUnit;
import mekanism.common.util.ItemDataUtils;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Rarity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public class Modules {
    private static final Map<String, ModuleData<?>> MODULES = new Object2ObjectOpenHashMap();
    private static final Map<Item, Set<ModuleData<?>>> SUPPORTED_MODULES = new Object2ObjectOpenHashMap();
    private static final Map<ModuleData<?>, Set<Item>> SUPPORTED_CONTAINERS = new Object2ObjectOpenHashMap();
    public static final ModuleData<ModuleEnergyUnit> ENERGY_UNIT = Modules.register("energy_unit", MekanismLang.MODULE_ENERGY_UNIT, MekanismLang.DESCRIPTION_ENERGY_UNIT, ModuleEnergyUnit::new, 8).rarity(Rarity.UNCOMMON).setNoDisable();
    public static final ModuleData<ModuleExcavationEscalationUnit> EXCAVATION_ESCALATION_UNIT = Modules.register("excavation_escalation_unit", MekanismLang.MODULE_EXCAVATION_ESCALATION_UNIT, MekanismLang.DESCRIPTION_EXCAVATION_ESCALATION_UNIT, ModuleExcavationEscalationUnit::new, 4).rarity(Rarity.UNCOMMON).setHandlesModeChange().setRendersHUD();
    public static final ModuleData<ModuleMekaTool.ModuleAttackAmplificationUnit> ATTACK_AMPLIFICATION_UNIT = Modules.register("attack_amplification_unit", MekanismLang.MODULE_ATTACK_AMPLIFICATION_UNIT, MekanismLang.DESCRIPTION_ATTACK_AMPLIFICATION_UNIT, ModuleMekaTool.ModuleAttackAmplificationUnit::new, 4).rarity(Rarity.UNCOMMON).setRendersHUD();
    public static final ModuleData<ModuleFarmingUnit> FARMING_UNIT = Modules.register("farming_unit", MekanismLang.MODULE_FARMING_UNIT, MekanismLang.DESCRIPTION_FARMING_UNIT, ModuleFarmingUnit::new, 4).rarity(Rarity.UNCOMMON).setExclusive();
    public static final ModuleData<ModuleMekaTool.ModuleSilkTouchUnit> SILK_TOUCH_UNIT = Modules.register("silk_touch_unit", MekanismLang.MODULE_SILK_TOUCH_UNIT, MekanismLang.DESCRIPTION_SILK_TOUCH_UNIT, ModuleMekaTool.ModuleSilkTouchUnit::new).rarity(Rarity.RARE);
    public static final ModuleData<ModuleVeinMiningUnit> VEIN_MINING_UNIT = Modules.register("vein_mining_unit", MekanismLang.MODULE_VEIN_MINING_UNIT, MekanismLang.DESCRIPTION_VEIN_MINING_UNIT, ModuleVeinMiningUnit::new, 4).rarity(Rarity.RARE).setRendersHUD();
    public static final ModuleData<ModuleMekaTool.ModuleTeleportationUnit> TELEPORTATION_UNIT = Modules.register("teleportation_unit", MekanismLang.MODULE_TELEPORTATION_UNIT, MekanismLang.DESCRIPTION_TELEPORTATION_UNIT, ModuleMekaTool.ModuleTeleportationUnit::new).rarity(Rarity.EPIC).setExclusive();
    public static final ModuleData<ModuleMekaSuit.ModuleElectrolyticBreathingUnit> ELECTROLYTIC_BREATHING_UNIT = Modules.register("electrolytic_breathing_unit", MekanismLang.MODULE_ELECTROLYTIC_BREATHING_UNIT, MekanismLang.DESCRIPTION_ELECTROLYTIC_BREATHING_UNIT, ModuleMekaSuit.ModuleElectrolyticBreathingUnit::new, 4).rarity(Rarity.UNCOMMON);
    public static final ModuleData<ModuleMekaSuit.ModuleRadiationShieldingUnit> RADIATION_SHIELDING_UNIT = Modules.register("radiation_shielding_unit", MekanismLang.MODULE_RADIATION_SHIELDING_UNIT, MekanismLang.DESCRIPTION_RADIATION_SHIELDING_UNIT, ModuleMekaSuit.ModuleRadiationShieldingUnit::new).rarity(Rarity.UNCOMMON);
    public static final ModuleData<ModuleMekaSuit.ModuleInhalationPurificationUnit> INHALATION_PURIFICATION_UNIT = Modules.register("inhalation_purification_unit", MekanismLang.MODULE_INHALATION_PURIFICATION_UNIT, MekanismLang.DESCRIPTION_INHALATION_PURIFICATION_UNIT, ModuleMekaSuit.ModuleInhalationPurificationUnit::new).rarity(Rarity.RARE);
    public static final ModuleData<ModuleMekaSuit.ModuleVisionEnhancementUnit> VISION_ENHANCEMENT_UNIT = Modules.register("vision_enhancement_unit", MekanismLang.MODULE_VISION_ENHANCEMENT_UNIT, MekanismLang.DESCRIPTION_VISION_ENHANCEMENT_UNIT, ModuleMekaSuit.ModuleVisionEnhancementUnit::new, 4).rarity(Rarity.RARE).setHandlesModeChange().setRendersHUD().setDisabledByDefault();
    public static final ModuleData<ModuleMekaSuit.ModuleSolarRechargingUnit> SOLAR_RECHARGING_UNIT = Modules.register("solar_recharging_unit", MekanismLang.MODULE_SOLAR_RECHARGING_UNIT, MekanismLang.DESCRIPTION_SOLAR_RECHARGING_UNIT, ModuleMekaSuit.ModuleSolarRechargingUnit::new, 8).rarity(Rarity.RARE);
    public static final ModuleData<ModuleMekaSuit.ModuleNutritionalInjectionUnit> NUTRITIONAL_INJECTION_UNIT = Modules.register("nutritional_injection_unit", MekanismLang.MODULE_NUTRITIONAL_INJECTION_UNIT, MekanismLang.DESCRIPTION_NUTRITIONAL_INJECTION_UNIT, ModuleMekaSuit.ModuleNutritionalInjectionUnit::new).rarity(Rarity.RARE).setRendersHUD();
    public static final ModuleData<ModuleMekaSuit.ModuleDosimeterUnit> DOSIMETER_UNIT = Modules.register("dosimeter_unit", MekanismLang.MODULE_DOSIMETER_UNIT, MekanismLang.DESCRIPTION_DOSIMETER_UNIT, ModuleMekaSuit.ModuleDosimeterUnit::new).rarity(Rarity.UNCOMMON).setRendersHUD();
    public static final ModuleData<ModuleJetpackUnit> JETPACK_UNIT = Modules.register("jetpack_unit", MekanismLang.MODULE_JETPACK_UNIT, MekanismLang.DESCRIPTION_JETPACK_UNIT, ModuleJetpackUnit::new).rarity(Rarity.RARE).setHandlesModeChange().setRendersHUD().setExclusive();
    public static final ModuleData<ModuleChargeDistributionUnit> CHARGE_DISTRIBUTION_UNIT = Modules.register("charge_distribution_unit", MekanismLang.MODULE_CHARGE_DISTRIBUTION_UNIT, MekanismLang.DESCRIPTION_CHARGE_DISTRIBUTION_UNIT, ModuleChargeDistributionUnit::new).rarity(Rarity.RARE);
    public static final ModuleData<ModuleMekaSuit.ModuleGravitationalModulatingUnit> GRAVITATIONAL_MODULATING_UNIT = Modules.register("gravitational_modulating_unit", MekanismLang.MODULE_GRAVITATIONAL_MODULATING_UNIT, MekanismLang.DESCRIPTION_GRAVITATIONAL_MODULATING_UNIT, ModuleMekaSuit.ModuleGravitationalModulatingUnit::new).rarity(Rarity.EPIC).setHandlesModeChange().setRendersHUD().setExclusive();
    public static final ModuleData<ModuleLocomotiveBoostingUnit> LOCOMOTIVE_BOOSTING_UNIT = Modules.register("locomotive_boosting_unit", MekanismLang.MODULE_LOCOMOTIVE_BOOSTING_UNIT, MekanismLang.DESCRIPTION_LOCOMOTIVE_BOOSTING_UNIT, ModuleLocomotiveBoostingUnit::new, 4).rarity(Rarity.RARE);
    public static final ModuleData<ModuleMekaSuit.ModuleHydraulicPropulsionUnit> HYDRAULIC_PROPULSION_UNIT = Modules.register("hydraulic_propulsion_unit", MekanismLang.MODULE_HYDRAULIC_PROPULSION_UNIT, MekanismLang.DESCRIPTION_HYDRAULIC_PROPULSION_UNIT, ModuleMekaSuit.ModuleHydraulicPropulsionUnit::new, 4).rarity(Rarity.RARE);
    public static final ModuleData<ModuleMagneticAttractionUnit> MAGNETIC_ATTRACTION_UNIT = Modules.register("magnetic_attraction_unit", MekanismLang.MODULE_MAGNETIC_ATTRACTION_UNIT, MekanismLang.DESCRIPTION_MAGNETIC_ATTRACTION_UNIT, ModuleMagneticAttractionUnit::new, 4).rarity(Rarity.RARE).setHandlesModeChange();

    private Modules() {
    }

    public static void setSupported(Item containerItem, ModuleData<?> ... types) {
        for (ModuleData<?> module : types) {
            SUPPORTED_MODULES.computeIfAbsent(containerItem, item -> new HashSet()).add(module);
        }
    }

    public static ModuleData<?> get(String name) {
        return MODULES.get(name);
    }

    public static Set<ModuleData<?>> getSupported(ItemStack container) {
        return SUPPORTED_MODULES.getOrDefault(container.func_77973_b(), new HashSet());
    }

    public static Set<Item> getSupported(ModuleData<?> type) {
        return SUPPORTED_CONTAINERS.getOrDefault(type, new HashSet());
    }

    public static boolean isEnabled(ItemStack container, ModuleData<?> type) {
        Object m = Modules.load(container, type);
        return m != null && ((Module)m).isEnabled();
    }

    public static <MODULE extends Module> MODULE load(ItemStack container, ModuleData<MODULE> type) {
        if (!(container.func_77973_b() instanceof IModuleContainerItem)) {
            return null;
        }
        CompoundNBT modulesTag = ItemDataUtils.getCompound(container, "modules");
        return Modules.load(container, type, modulesTag);
    }

    private static <MODULE extends Module> MODULE load(ItemStack container, ModuleData<MODULE> type, CompoundNBT modulesTag) {
        if (type == null || !modulesTag.func_74764_b(type.getName())) {
            return null;
        }
        MODULE module = type.get(container);
        if (module == null) {
            Mekanism.logger.error("Attempted to load unknown module type '{}' from container {}", type, (Object)container.func_77973_b());
        } else {
            ((Module)module).read(modulesTag.func_74775_l(type.getName()));
        }
        return module;
    }

    public static List<Module> loadAll(ItemStack container) {
        if (!(container.func_77973_b() instanceof IModuleContainerItem)) {
            return new ArrayList<Module>();
        }
        CompoundNBT modulesTag = ItemDataUtils.getCompound(container, "modules");
        return modulesTag.func_150296_c().stream().map(name -> Modules.load(container, MODULES.get(name), modulesTag)).collect(Collectors.toList());
    }

    private static <M extends Module> ModuleData<M> register(String name, ILangEntry langEntry, ILangEntry description, Supplier<M> moduleSupplier) {
        return Modules.register(name, langEntry, description, moduleSupplier, 1);
    }

    private static <M extends Module> ModuleData<M> register(String name, ILangEntry langEntry, ILangEntry description, Supplier<M> moduleSupplier, int maxStackSize) {
        ModuleData data = new ModuleData(name, langEntry, description, moduleSupplier, maxStackSize);
        MODULES.put(name, data);
        return data;
    }

    public static Collection<ModuleData<?>> getAll() {
        return MODULES.values();
    }

    public static void processSupportedContainers() {
        for (Map.Entry<Item, Set<ModuleData<?>>> entry : SUPPORTED_MODULES.entrySet()) {
            for (ModuleData<?> data : entry.getValue()) {
                SUPPORTED_CONTAINERS.computeIfAbsent(data, d -> new HashSet()).add(entry.getKey());
            }
        }
    }

    public static void resetSupportedContainers() {
        SUPPORTED_CONTAINERS.clear();
    }

    public static class ModuleData<MODULE extends Module>
    implements IHasTranslationKey {
        private final String name;
        private final ILangEntry langEntry;
        private final ILangEntry description;
        private final Supplier<MODULE> supplier;
        private final int maxStackSize;
        private ItemStack stack;
        private Rarity rarity = Rarity.COMMON;
        private boolean exclusive;
        private boolean handlesModeChange;
        private boolean rendersHUD;
        private boolean noDisable;
        private boolean disabledByDefault;

        private ModuleData(String name, ILangEntry langEntry, ILangEntry description, Supplier<MODULE> supplier, int maxStackSize) {
            this.name = name;
            this.langEntry = langEntry;
            this.description = description;
            this.supplier = supplier;
            this.maxStackSize = maxStackSize;
        }

        public int getMaxStackSize() {
            return this.maxStackSize;
        }

        public Rarity getRarity() {
            return this.rarity;
        }

        public ModuleData<MODULE> rarity(Rarity rarity) {
            this.rarity = rarity;
            return this;
        }

        public MODULE get(ItemStack container) {
            Module module = (Module)this.supplier.get();
            module.init(this, container);
            return (MODULE)module;
        }

        public void setStack(Item item) {
            this.stack = new ItemStack((IItemProvider)item);
        }

        public ItemStack getStack() {
            return this.stack;
        }

        public String getName() {
            return this.name;
        }

        public ITextComponent getDescription() {
            return new TranslationTextComponent(this.description.getTranslationKey());
        }

        public ILangEntry getLangEntry() {
            return this.langEntry;
        }

        public ModuleData<MODULE> setExclusive() {
            this.exclusive = true;
            return this;
        }

        public boolean isExclusive() {
            return this.exclusive;
        }

        public ModuleData<MODULE> setHandlesModeChange() {
            this.handlesModeChange = true;
            return this;
        }

        public boolean handlesModeChange() {
            return this.handlesModeChange;
        }

        public ModuleData<MODULE> setRendersHUD() {
            this.rendersHUD = true;
            return this;
        }

        public boolean rendersHUD() {
            return this.rendersHUD;
        }

        public ModuleData<MODULE> setNoDisable() {
            this.noDisable = true;
            return this;
        }

        public boolean isNoDisable() {
            return this.noDisable;
        }

        public ModuleData<MODULE> setDisabledByDefault() {
            this.disabledByDefault = true;
            return this;
        }

        public boolean isDisabledByDefault() {
            return this.disabledByDefault;
        }

        @Override
        public String getTranslationKey() {
            return this.langEntry.getTranslationKey();
        }
    }
}

