/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.content.network.transmitter;

import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mekanism.api.text.EnumColor;
import mekanism.common.MekanismLang;
import mekanism.common.lib.transmitter.ConnectionType;
import mekanism.common.lib.transmitter.DynamicNetwork;
import mekanism.common.lib.transmitter.TransmissionType;
import mekanism.common.lib.transmitter.TransmitterNetworkRegistry;
import mekanism.common.lib.transmitter.acceptor.AbstractAcceptorCache;
import mekanism.common.lib.transmitter.acceptor.AcceptorCache;
import mekanism.common.tile.interfaces.ITileWrapper;
import mekanism.common.tile.transmitter.TileEntityTransmitter;
import mekanism.common.util.EnumUtils;
import mekanism.common.util.NBTUtils;
import mekanism.common.util.WorldUtils;
import mekanism.common.util.text.BooleanStateDisplay;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.common.util.LazyOptional;

public abstract class Transmitter<ACCEPTOR, NETWORK extends DynamicNetwork<ACCEPTOR, NETWORK, TRANSMITTER>, TRANSMITTER extends Transmitter<ACCEPTOR, NETWORK, TRANSMITTER>>
implements ITileWrapper {
    public ConnectionType[] connectionTypes = new ConnectionType[]{ConnectionType.NORMAL, ConnectionType.NORMAL, ConnectionType.NORMAL, ConnectionType.NORMAL, ConnectionType.NORMAL, ConnectionType.NORMAL};
    private final AbstractAcceptorCache<ACCEPTOR, ?> acceptorCache;
    public byte currentTransmitterConnections = 0;
    private final TileEntityTransmitter transmitterTile;
    private final Set<TransmissionType> supportedTransmissionTypes;
    protected boolean redstoneReactive;
    private boolean redstonePowered;
    private boolean redstoneSet;
    private NETWORK theNetwork = null;
    private boolean orphaned = true;
    protected boolean isUpgrading;

    public static boolean connectionMapContainsSide(byte connections, Direction side) {
        byte tester = (byte)(1 << side.ordinal());
        return (connections & tester) > 0;
    }

    private static byte setConnectionBit(byte connections, boolean toSet, Direction side) {
        return (byte)(connections & ~((byte)(1 << side.ordinal())) | (byte)((toSet ? 1 : 0) << side.ordinal()));
    }

    public static ConnectionType getConnectionType(Direction side, byte allConnections, byte transmitterConnections, ConnectionType[] types) {
        if (!Transmitter.connectionMapContainsSide(allConnections, side)) {
            return ConnectionType.NONE;
        }
        if (Transmitter.connectionMapContainsSide(transmitterConnections, side)) {
            return ConnectionType.NORMAL;
        }
        return types[side.ordinal()];
    }

    public Transmitter(TileEntityTransmitter transmitterTile, TransmissionType ... transmissionTypes) {
        this.transmitterTile = transmitterTile;
        this.acceptorCache = this.createAcceptorCache();
        this.supportedTransmissionTypes = EnumSet.noneOf(TransmissionType.class);
        this.supportedTransmissionTypes.addAll(Arrays.asList(transmissionTypes));
    }

    protected AbstractAcceptorCache<ACCEPTOR, ?> createAcceptorCache() {
        return new AcceptorCache(this, this.getTransmitterTile());
    }

    public AbstractAcceptorCache<ACCEPTOR, ?> getAcceptorCache() {
        return this.acceptorCache;
    }

    public TileEntityTransmitter getTransmitterTile() {
        return this.transmitterTile;
    }

    @Override
    public BlockPos getTilePos() {
        return this.transmitterTile.func_174877_v();
    }

    @Override
    public World getTileWorld() {
        return this.transmitterTile.func_145831_w();
    }

    public boolean isRemote() {
        return this.transmitterTile.isRemote();
    }

    protected TRANSMITTER getTransmitter() {
        return (TRANSMITTER)this;
    }

    public NETWORK getTransmitterNetwork() {
        return this.theNetwork;
    }

    public void setTransmitterNetwork(NETWORK network) {
        this.setTransmitterNetwork(network, true);
    }

    public boolean setTransmitterNetwork(NETWORK network, boolean requestNow) {
        if (this.theNetwork == network) {
            return false;
        }
        if (this.isRemote() && this.theNetwork != null) {
            ((DynamicNetwork)this.theNetwork).removeTransmitter(this.getTransmitter());
        }
        this.theNetwork = network;
        boolean bl = this.orphaned = this.theNetwork == null;
        if (this.isRemote()) {
            if (this.theNetwork != null) {
                ((DynamicNetwork)this.theNetwork).addTransmitter(this.getTransmitter());
            }
        } else if (requestNow) {
            this.requestsUpdate();
        } else {
            return true;
        }
        return false;
    }

    public boolean hasTransmitterNetwork() {
        return !this.isOrphan() && this.getTransmitterNetwork() != null;
    }

    public abstract NETWORK createEmptyNetwork();

    public abstract NETWORK createEmptyNetworkWithID(UUID var1);

    public abstract NETWORK createNetworkByMerging(Collection<NETWORK> var1);

    public NETWORK getExternalNetwork(BlockPos from) {
        TileEntityTransmitter transmitter = WorldUtils.getTileEntity(TileEntityTransmitter.class, (IBlockReader)this.getTileWorld(), from);
        if (transmitter != null && this.supportsTransmissionType(transmitter)) {
            return (NETWORK)transmitter.getTransmitter().getTransmitterNetwork();
        }
        return null;
    }

    public boolean isValid() {
        return !this.getTransmitterTile().func_145837_r() && this.getTransmitterTile().isLoaded();
    }

    public boolean isOrphan() {
        return this.orphaned;
    }

    public void setOrphan(boolean nowOrphaned) {
        this.orphaned = nowOrphaned;
    }

    public Set<TransmissionType> getSupportedTransmissionTypes() {
        return this.supportedTransmissionTypes;
    }

    public boolean supportsTransmissionType(Transmitter<?, ?, ?> transmitter) {
        return transmitter.getSupportedTransmissionTypes().stream().anyMatch(this.supportedTransmissionTypes::contains);
    }

    public boolean supportsTransmissionType(TileEntityTransmitter transmitter) {
        return this.supportsTransmissionType(transmitter.getTransmitter());
    }

    @Nonnull
    public LazyOptional<ACCEPTOR> getAcceptor(Direction side) {
        return this.acceptorCache.getCachedAcceptor(side);
    }

    public boolean handlesRedstone() {
        return true;
    }

    public byte getPossibleTransmitterConnections() {
        byte connections = 0;
        if (this.handlesRedstone() && this.redstoneReactive && this.redstonePowered) {
            return connections;
        }
        for (Direction side : EnumUtils.DIRECTIONS) {
            Transmitter<?, ?, ?> transmitter;
            TileEntity tile = WorldUtils.getTileEntity((IBlockReader)this.getTileWorld(), this.getTilePos().func_177972_a(side));
            if (!this.canConnectMutual(side, tile) || !(tile instanceof TileEntityTransmitter) || !this.supportsTransmissionType(transmitter = ((TileEntityTransmitter)tile).getTransmitter()) || !this.isValidTransmitter(transmitter)) continue;
            connections = (byte)(connections | 1 << side.ordinal());
        }
        return connections;
    }

    private boolean getPossibleAcceptorConnection(Direction side) {
        if (this.handlesRedstone() && this.redstoneReactive && this.redstonePowered) {
            return false;
        }
        TileEntity tile = WorldUtils.getTileEntity((IBlockReader)this.getTileWorld(), this.getTilePos().func_177972_a(side));
        if (this.canConnectMutual(side, tile) && this.isValidAcceptor(tile, side)) {
            return true;
        }
        this.acceptorCache.invalidateCachedAcceptor(side);
        return false;
    }

    private boolean getPossibleTransmitterConnection(Direction side) {
        if (this.handlesRedstone() && this.redstoneReactive && this.redstonePowered) {
            return false;
        }
        TileEntity tile = WorldUtils.getTileEntity((IBlockReader)this.getTileWorld(), this.getTilePos().func_177972_a(side));
        if (this.canConnectMutual(side, tile) && tile instanceof TileEntityTransmitter) {
            Transmitter<?, ?, ?> transmitter = ((TileEntityTransmitter)tile).getTransmitter();
            return this.supportsTransmissionType(transmitter) && this.isValidTransmitter(transmitter);
        }
        return false;
    }

    public byte getPossibleAcceptorConnections() {
        byte connections = 0;
        if (this.handlesRedstone() && this.redstoneReactive && this.redstonePowered) {
            return connections;
        }
        for (Direction side : EnumUtils.DIRECTIONS) {
            BlockPos offset = this.getTilePos().func_177972_a(side);
            TileEntity tile = WorldUtils.getTileEntity((IBlockReader)this.getTileWorld(), offset);
            if (this.canConnectMutual(side, tile)) {
                if (!this.isRemote() && !WorldUtils.isBlockLoaded((IBlockReader)this.getTileWorld(), offset)) {
                    this.getTransmitterTile().setForceUpdate();
                    continue;
                }
                if (this.isValidAcceptor(tile, side)) {
                    connections = (byte)(connections | 1 << side.ordinal());
                    continue;
                }
            }
            this.acceptorCache.invalidateCachedAcceptor(side);
        }
        return connections;
    }

    public byte getAllCurrentConnections() {
        return (byte)(this.currentTransmitterConnections | this.acceptorCache.currentAcceptorConnections);
    }

    public boolean isValidTransmitter(Transmitter<?, ?, ?> transmitter) {
        return true;
    }

    public boolean canConnectToAcceptor(Direction side) {
        ConnectionType type = this.connectionTypes[side.ordinal()];
        return type == ConnectionType.NORMAL || type == ConnectionType.PUSH;
    }

    @Nullable
    public BlockPos getAdjacentConnectableTransmitterPos(Direction side) {
        Transmitter<?, ?, ?> transmitter;
        BlockPos sidePos = this.getTilePos().func_177972_a(side);
        TileEntity potentialTransmitterTile = WorldUtils.getTileEntity((IBlockReader)this.getTileWorld(), sidePos);
        if (this.canConnectMutual(side, potentialTransmitterTile) && potentialTransmitterTile instanceof TileEntityTransmitter && this.supportsTransmissionType(transmitter = ((TileEntityTransmitter)potentialTransmitterTile).getTransmitter()) && this.isValidTransmitter(transmitter)) {
            return sidePos;
        }
        return null;
    }

    public boolean isValidAcceptor(TileEntity tile, Direction side) {
        return !(tile instanceof TileEntityTransmitter) || !this.supportsTransmissionType((TileEntityTransmitter)tile);
    }

    public boolean canConnectMutual(Direction side, @Nullable TileEntity cachedTile) {
        if (!this.canConnect(side)) {
            return false;
        }
        if (cachedTile == null) {
            cachedTile = WorldUtils.getTileEntity((IBlockReader)this.getTileWorld(), this.getTilePos().func_177972_a(side));
        }
        return !(cachedTile instanceof TileEntityTransmitter) || ((TileEntityTransmitter)cachedTile).getTransmitter().canConnect(side.func_176734_d());
    }

    public boolean canConnect(Direction side) {
        if (this.connectionTypes[side.ordinal()] == ConnectionType.NONE) {
            return false;
        }
        if (this.handlesRedstone()) {
            if (!this.redstoneSet) {
                this.redstonePowered = this.redstoneReactive ? WorldUtils.isGettingPowered(this.getTileWorld(), this.getTilePos()) : false;
                this.redstoneSet = true;
            }
            return !this.redstoneReactive || !this.redstonePowered;
        }
        return true;
    }

    public void requestsUpdate() {
        this.getTransmitterTile().sendUpdatePacket();
    }

    @Nonnull
    public CompoundNBT getReducedUpdateTag(CompoundNBT updateTag) {
        updateTag.func_74774_a("connections", this.currentTransmitterConnections);
        updateTag.func_74774_a("acceptors", this.acceptorCache.currentAcceptorConnections);
        for (int i = 0; i < EnumUtils.DIRECTIONS.length; ++i) {
            updateTag.func_74768_a("side" + i, this.connectionTypes[i].ordinal());
        }
        if (this.hasTransmitterNetwork()) {
            updateTag.func_186854_a("network", ((DynamicNetwork)this.getTransmitterNetwork()).getUUID());
        }
        return updateTag;
    }

    public void handleUpdateTag(@Nonnull CompoundNBT tag) {
        NBTUtils.setByteIfPresent(tag, "connections", connections -> {
            this.currentTransmitterConnections = connections;
        });
        NBTUtils.setByteIfPresent(tag, "acceptors", acceptors -> {
            this.acceptorCache.currentAcceptorConnections = acceptors;
        });
        int i = 0;
        while (i < EnumUtils.DIRECTIONS.length) {
            int index = i++;
            NBTUtils.setEnumIfPresent(tag, "side" + index, ConnectionType::byIndexStatic, type -> {
                this.connectionTypes[index] = type;
            });
        }
        NBTUtils.setUUIDIfPresentElse(tag, "network", networkID -> {
            if (this.hasTransmitterNetwork() && ((DynamicNetwork)this.getTransmitterNetwork()).getUUID().equals(networkID)) {
                return;
            }
            DynamicNetwork<?, ?, ?> clientNetwork = TransmitterNetworkRegistry.getInstance().getClientNetwork((UUID)networkID);
            if (clientNetwork == null) {
                NETWORK network = this.createEmptyNetworkWithID((UUID)networkID);
                ((DynamicNetwork)network).register();
                this.setTransmitterNetwork(network);
                this.handleContentsUpdateTag(network, tag);
            } else {
                this.updateClientNetwork(clientNetwork);
            }
        }, () -> this.setTransmitterNetwork(null));
    }

    protected void updateClientNetwork(@Nonnull NETWORK network) {
        ((DynamicNetwork)network).register();
        this.setTransmitterNetwork(network);
    }

    protected void handleContentsUpdateTag(@Nonnull NETWORK network, @Nonnull CompoundNBT tag) {
    }

    public void read(@Nonnull CompoundNBT nbtTags) {
        this.redstoneReactive = nbtTags.func_74767_n("redstone");
        int i = 0;
        while (i < EnumUtils.DIRECTIONS.length) {
            int index = i++;
            NBTUtils.setEnumIfPresent(nbtTags, "connection" + index, ConnectionType::byIndexStatic, color -> {
                this.connectionTypes[index] = color;
            });
        }
    }

    @Nonnull
    public CompoundNBT write(@Nonnull CompoundNBT nbtTags) {
        nbtTags.func_74757_a("redstone", this.redstoneReactive);
        for (int i = 0; i < EnumUtils.DIRECTIONS.length; ++i) {
            nbtTags.func_74768_a("connection" + i, this.connectionTypes[i].ordinal());
        }
        return nbtTags;
    }

    private void recheckRedstone() {
        if (this.handlesRedstone()) {
            boolean previouslyPowered = this.redstonePowered;
            this.redstonePowered = this.redstoneReactive ? WorldUtils.isGettingPowered(this.getTileWorld(), this.getTilePos()) : false;
            if (previouslyPowered != this.redstonePowered) {
                this.markDirtyTransmitters();
            }
            this.redstoneSet = true;
        }
    }

    public void refreshConnections() {
        if (!this.isRemote()) {
            this.recheckRedstone();
            byte possibleTransmitters = this.getPossibleTransmitterConnections();
            byte possibleAcceptors = this.getPossibleAcceptorConnections();
            byte newlyEnabledTransmitters = 0;
            boolean sendDesc = false;
            if ((possibleTransmitters | possibleAcceptors) != this.getAllCurrentConnections()) {
                sendDesc = true;
                if (possibleTransmitters != this.currentTransmitterConnections) {
                    newlyEnabledTransmitters = (byte)(possibleTransmitters ^ this.currentTransmitterConnections);
                    newlyEnabledTransmitters = (byte)(newlyEnabledTransmitters & ~this.currentTransmitterConnections);
                }
            }
            this.currentTransmitterConnections = possibleTransmitters;
            this.acceptorCache.currentAcceptorConnections = possibleAcceptors;
            if (newlyEnabledTransmitters != 0) {
                this.recheckConnections(newlyEnabledTransmitters);
            }
            if (sendDesc) {
                this.getTransmitterTile().sendUpdatePacket();
            }
        }
    }

    public void refreshConnections(Direction side) {
        if (!this.isRemote()) {
            boolean possibleTransmitter = this.getPossibleTransmitterConnection(side);
            boolean possibleAcceptor = this.getPossibleAcceptorConnection(side);
            boolean transmitterChanged = false;
            boolean sendDesc = false;
            if ((possibleTransmitter || possibleAcceptor) != Transmitter.connectionMapContainsSide(this.getAllCurrentConnections(), side)) {
                sendDesc = true;
                if (possibleTransmitter != Transmitter.connectionMapContainsSide(this.currentTransmitterConnections, side)) {
                    transmitterChanged = possibleTransmitter;
                }
            }
            this.currentTransmitterConnections = Transmitter.setConnectionBit(this.currentTransmitterConnections, possibleTransmitter, side);
            this.acceptorCache.currentAcceptorConnections = Transmitter.setConnectionBit(this.acceptorCache.currentAcceptorConnections, possibleAcceptor, side);
            if (transmitterChanged) {
                this.recheckConnection(side);
            }
            if (sendDesc) {
                this.getTransmitterTile().sendUpdatePacket();
            }
        }
    }

    protected void recheckConnections(byte newlyEnabledTransmitters) {
        if (!this.hasTransmitterNetwork()) {
            for (Direction side : EnumUtils.DIRECTIONS) {
                TileEntityTransmitter tile;
                if (!Transmitter.connectionMapContainsSide(newlyEnabledTransmitters, side) || (tile = WorldUtils.getTileEntity(TileEntityTransmitter.class, (IBlockReader)this.getTileWorld(), this.getTilePos().func_177972_a(side))) == null) continue;
                tile.getTransmitter().refreshConnections(side.func_176734_d());
            }
        }
    }

    protected void recheckConnection(Direction side) {
    }

    public void onModeChange(Direction side) {
        this.markDirtyAcceptor(side);
        if (this.getPossibleTransmitterConnections() != this.currentTransmitterConnections) {
            this.markDirtyTransmitters();
        }
        this.getTransmitterTile().markDirty(false);
    }

    public void onNeighborTileChange(Direction side) {
        this.refreshConnections(side);
    }

    public void onNeighborBlockChange(Direction side) {
        if (this.handlesRedstone() && this.redstoneReactive) {
            this.refreshConnections();
        } else {
            this.refreshConnections(side);
        }
    }

    protected void markDirtyTransmitters() {
        this.notifyTileChange();
        if (this.hasTransmitterNetwork()) {
            TransmitterNetworkRegistry.invalidateTransmitter(this.getTransmitter());
        }
    }

    public void markDirtyAcceptor(Direction side) {
        if (this.hasTransmitterNetwork()) {
            ((DynamicNetwork)this.getTransmitterNetwork()).acceptorChanged(this.getTransmitter(), side);
        }
    }

    public void remove() {
        this.acceptorCache.clear();
    }

    public void onChunkUnload() {
        this.acceptorCache.clear();
    }

    public ConnectionType getConnectionType(Direction side) {
        return Transmitter.getConnectionType(side, this.getAllCurrentConnections(), this.currentTransmitterConnections, this.connectionTypes);
    }

    public Set<Direction> getConnections(ConnectionType type) {
        EnumSet<Direction> sides = EnumSet.noneOf(Direction.class);
        for (Direction side : EnumUtils.DIRECTIONS) {
            if (this.getConnectionType(side) != type) continue;
            sides.add(side);
        }
        return sides;
    }

    public ActionResultType onConfigure(PlayerEntity player, Direction side) {
        return ActionResultType.PASS;
    }

    public ActionResultType onRightClick(PlayerEntity player, Direction side) {
        if (this.handlesRedstone()) {
            this.redstoneReactive ^= true;
            this.refreshConnections();
            this.notifyTileChange();
            player.func_145747_a((ITextComponent)MekanismLang.LOG_FORMAT.translateColored(EnumColor.DARK_BLUE, MekanismLang.MEKANISM, MekanismLang.REDSTONE_SENSITIVITY.translateColored(EnumColor.GRAY, EnumColor.INDIGO, BooleanStateDisplay.OnOff.of(this.redstoneReactive))), Util.field_240973_b_);
        }
        return ActionResultType.SUCCESS;
    }

    public void notifyTileChange() {
        WorldUtils.notifyLoadedNeighborsOfTileChange(this.getTileWorld(), this.getTilePos());
    }

    public abstract void takeShare();

    public void startUpgrading() {
        this.isUpgrading = true;
        this.takeShare();
        this.setTransmitterNetwork(null);
    }
}

