/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.content.qio;

import it.unimi.dsi.fastutil.objects.Object2LongMap;
import mekanism.common.content.qio.QIODriveData;
import mekanism.common.lib.inventory.HashedItem;
import mekanism.common.util.ItemDataUtils;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;

public interface IQIODriveItem {
    default public boolean hasStoredItemMap(ItemStack stack) {
        return ItemDataUtils.hasData(stack, "qioItemMap", 9);
    }

    default public void loadItemMap(ItemStack stack, QIODriveData data) {
        if (this.hasStoredItemMap(stack)) {
            ListNBT list = ItemDataUtils.getList(stack, "qioItemMap");
            for (int i = 0; i < list.size(); ++i) {
                CompoundNBT tag = list.func_150305_b(i);
                ItemStack itemType = ItemStack.func_199557_a((CompoundNBT)tag.func_74775_l("Item"));
                if (itemType.func_190926_b()) continue;
                long count = tag.func_74763_f("amount");
                data.getItemMap().put((Object)new HashedItem(itemType), count);
            }
        }
    }

    default public void writeItemMap(ItemStack stack, QIODriveData map) {
        ListNBT list = new ListNBT();
        for (Object2LongMap.Entry entry : map.getItemMap().object2LongEntrySet()) {
            CompoundNBT tag = new CompoundNBT();
            tag.func_218657_a("Item", (INBT)((HashedItem)entry.getKey()).getStack().func_77955_b(new CompoundNBT()));
            tag.func_74772_a("amount", entry.getLongValue());
            list.add((Object)tag);
        }
        ItemDataUtils.setList(stack, "qioItemMap", list);
    }

    public long getCountCapacity(ItemStack var1);

    public int getTypeCapacity(ItemStack var1);

    public static class DriveMetadata {
        private final long count;
        private final int types;

        public DriveMetadata(long count, int types) {
            this.count = count;
            this.types = types;
        }

        public void write(ItemStack stack) {
            ItemDataUtils.setLong(stack, "qioMetaCount", this.count);
            ItemDataUtils.setInt(stack, "qioMetaTypes", this.types);
        }

        public static DriveMetadata load(ItemStack stack) {
            return new DriveMetadata(ItemDataUtils.getLong(stack, "qioMetaCount"), ItemDataUtils.getInt(stack, "qioMetaTypes"));
        }

        public long getCount() {
            return this.count;
        }

        public int getTypes() {
            return this.types;
        }
    }
}

