/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.content.qio;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.SetMultimap;
import it.unimi.dsi.fastutil.objects.Object2LongMap;
import it.unimi.dsi.fastutil.objects.Object2LongOpenHashMap;
import java.text.NumberFormat;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nullable;
import mekanism.api.text.EnumColor;
import mekanism.common.CommonWorldTickHandler;
import mekanism.common.Mekanism;
import mekanism.common.base.TagCache;
import mekanism.common.content.qio.IQIODriveHolder;
import mekanism.common.content.qio.IQIODriveItem;
import mekanism.common.content.qio.QIODriveData;
import mekanism.common.inventory.container.QIOItemViewerContainer;
import mekanism.common.lib.BiMultimap;
import mekanism.common.lib.WildcardMatcher;
import mekanism.common.lib.frequency.Frequency;
import mekanism.common.lib.frequency.FrequencyType;
import mekanism.common.lib.inventory.HashedItem;
import mekanism.common.network.PacketQIOItemViewerGuiSync;
import mekanism.common.util.NBTUtils;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;

public class QIOFrequency
extends Frequency {
    public static final NumberFormat intFormatter = NumberFormat.getIntegerInstance();
    private static final Random rand = new Random();
    private final Map<QIODriveData.QIODriveKey, QIODriveData> driveMap = new LinkedHashMap<QIODriveData.QIODriveKey, QIODriveData>();
    private final Map<HashedItem, QIOItemTypeData> itemDataMap = new LinkedHashMap<HashedItem, QIOItemTypeData>();
    private final Set<IQIODriveHolder> driveHolders = new HashSet<IQIODriveHolder>();
    private final BiMultimap<String, HashedItem> tagLookupMap = new BiMultimap();
    private final BiMap<HashedItem, UUID> itemTypeLookup = HashBiMap.create();
    private final SetMultimap<String, String> tagWildcardCache = HashMultimap.create();
    private final Set<HashedItem.UUIDAwareHashedItem> updatedItems = new HashSet<HashedItem.UUIDAwareHashedItem>();
    private final Set<ServerPlayerEntity> playersViewingItems = new HashSet<ServerPlayerEntity>();
    private boolean needsUpdate;
    private boolean isDirty;
    private long totalCount;
    private long totalCountCapacity;
    private int totalTypeCapacity;
    private int clientTypes;
    private EnumColor color = EnumColor.INDIGO;

    public QIOFrequency(String n, UUID uuid) {
        super(FrequencyType.QIO, n, uuid);
    }

    public QIOFrequency() {
        super(FrequencyType.QIO);
    }

    public Map<HashedItem, QIOItemTypeData> getItemDataMap() {
        return this.itemDataMap;
    }

    @Nullable
    public HashedItem getTypeByUUID(@Nullable UUID uuid) {
        return uuid == null ? null : (HashedItem)this.itemTypeLookup.inverse().get((Object)uuid);
    }

    @Nullable
    public UUID getUUIDForType(HashedItem item) {
        return (UUID)this.itemTypeLookup.get((Object)item);
    }

    public ItemStack addItem(ItemStack stack) {
        HashedItem type = new HashedItem(stack);
        if (this.totalCount == this.totalCountCapacity || !this.itemDataMap.containsKey(type) && this.itemDataMap.size() == this.totalTypeCapacity) {
            return stack;
        }
        QIOItemTypeData data = this.itemDataMap.computeIfAbsent(type, t -> {
            this.tagLookupMap.putAll((Collection<String>)TagCache.getItemTags(stack), (HashedItem)t);
            this.tagWildcardCache.clear();
            this.itemTypeLookup.put(t, (Object)UUID.randomUUID());
            return new QIOItemTypeData((HashedItem)t);
        });
        return type.createStack((int)data.add(stack.func_190916_E()));
    }

    public ItemStack removeItem(int amount) {
        return this.removeByType(null, amount);
    }

    public ItemStack removeItem(ItemStack stack, int amount) {
        return this.removeByType(new HashedItem(stack), amount);
    }

    public ItemStack removeByType(@Nullable HashedItem itemType, int amount) {
        QIOItemTypeData data;
        if (this.itemDataMap.isEmpty()) {
            return ItemStack.field_190927_a;
        }
        if (itemType == null) {
            Map.Entry<HashedItem, QIOItemTypeData> entry = this.itemDataMap.entrySet().iterator().next();
            itemType = entry.getKey();
            data = entry.getValue();
        } else {
            data = this.itemDataMap.get(itemType);
            if (data == null) {
                return ItemStack.field_190927_a;
            }
        }
        ItemStack removed = data.remove(amount);
        if (data.count == 0L) {
            this.itemDataMap.remove(data.itemType);
            this.tagLookupMap.removeValue(data.itemType);
            this.itemTypeLookup.remove((Object)data.itemType);
            this.tagWildcardCache.clear();
        }
        return removed;
    }

    public Object2LongMap<HashedItem> getStacksByTag(String tag) {
        Set<HashedItem> items = this.tagLookupMap.getValues(tag);
        Object2LongOpenHashMap ret = new Object2LongOpenHashMap();
        items.forEach(arg_0 -> this.lambda$getStacksByTag$1((Object2LongMap)ret, arg_0));
        return ret;
    }

    public Object2LongMap<HashedItem> getStacksByWildcard(String wildcard) {
        if (!this.tagWildcardCache.containsKey((Object)wildcard)) {
            this.buildWildcardMapping(wildcard);
        }
        Set matchingTags = this.tagWildcardCache.get((Object)wildcard);
        Object2LongOpenHashMap ret = new Object2LongOpenHashMap();
        matchingTags.forEach(arg_0 -> this.lambda$getStacksByWildcard$2((Object2LongMap)ret, arg_0));
        return ret;
    }

    private void buildWildcardMapping(String wildcard) {
        for (String tag : this.tagLookupMap.getAllKeys()) {
            if (!WildcardMatcher.matches(wildcard, tag)) continue;
            this.tagWildcardCache.put((Object)wildcard, (Object)tag);
        }
    }

    public void openItemViewer(ServerPlayerEntity player) {
        this.playersViewingItems.add(player);
        Object2LongOpenHashMap map = new Object2LongOpenHashMap();
        this.itemDataMap.values().forEach(arg_0 -> this.lambda$openItemViewer$3((Object2LongMap)map, arg_0));
        Mekanism.packetHandler.sendTo(PacketQIOItemViewerGuiSync.batch((Object2LongMap<HashedItem.UUIDAwareHashedItem>)map, this.totalCountCapacity, this.totalTypeCapacity), player);
    }

    public void closeItemViewer(ServerPlayerEntity player) {
        this.playersViewingItems.remove(player);
    }

    public EnumColor getColor() {
        return this.color;
    }

    public void setColor(EnumColor color) {
        this.color = color;
    }

    public long getTotalItemCount() {
        return this.totalCount;
    }

    public long getTotalItemCountCapacity() {
        return this.totalCountCapacity;
    }

    public int getTotalItemTypes(boolean remote) {
        return remote ? this.clientTypes : this.itemDataMap.size();
    }

    public int getTotalItemTypeCapacity() {
        return this.totalTypeCapacity;
    }

    public long getStored(HashedItem itemType) {
        QIOItemTypeData data = this.itemDataMap.get(itemType);
        return data != null ? data.count : 0L;
    }

    public QIODriveData getDriveData(QIODriveData.QIODriveKey key) {
        return this.driveMap.get(key);
    }

    @Override
    public void tick() {
        super.tick();
        if (!this.updatedItems.isEmpty() || this.needsUpdate) {
            Object2LongOpenHashMap map = new Object2LongOpenHashMap();
            this.updatedItems.forEach(arg_0 -> this.lambda$tick$4((Object2LongMap)map, arg_0));
            this.playersViewingItems.removeIf(player -> !(player.field_71070_bA instanceof QIOItemViewerContainer));
            this.playersViewingItems.forEach(arg_0 -> this.lambda$tick$6((Object2LongMap)map, arg_0));
            this.updatedItems.clear();
            this.needsUpdate = false;
        }
        if (this.isDirty && rand.nextInt(100) == 0) {
            this.saveAll();
            this.isDirty = false;
        }
        if (CommonWorldTickHandler.flushTagAndRecipeCaches) {
            this.tagLookupMap.clear();
            this.tagWildcardCache.clear();
            this.itemDataMap.values().forEach(item -> this.tagLookupMap.putAll(TagCache.getItemTags(((QIOItemTypeData)item).itemType.getStack()), ((QIOItemTypeData)item).itemType));
        }
    }

    @Override
    public void onDeactivate(TileEntity tile) {
        super.onDeactivate(tile);
        if (tile instanceof IQIODriveHolder) {
            IQIODriveHolder holder = (IQIODriveHolder)tile;
            for (int i = 0; i < holder.getDriveSlots().size(); ++i) {
                QIODriveData.QIODriveKey key = new QIODriveData.QIODriveKey(holder, i);
                this.removeDrive(key, true);
                this.driveMap.remove(key);
            }
        }
    }

    @Override
    public void update(TileEntity tile) {
        IQIODriveHolder holder;
        super.update(tile);
        if (tile instanceof IQIODriveHolder && !this.driveHolders.contains(holder = (IQIODriveHolder)tile)) {
            this.addHolder(holder);
        }
    }

    @Override
    public void onRemove() {
        super.onRemove();
        HashSet<QIODriveData.QIODriveKey> keys = new HashSet<QIODriveData.QIODriveKey>(this.driveMap.keySet());
        keys.forEach(key -> this.removeDrive((QIODriveData.QIODriveKey)key, false));
        this.driveMap.clear();
        this.playersViewingItems.forEach(player -> Mekanism.packetHandler.sendTo(PacketQIOItemViewerGuiSync.kill(), (ServerPlayerEntity)player));
    }

    @Override
    public int getSyncHash() {
        int code = super.getSyncHash();
        code = 31 * code + Long.hashCode(this.totalCount);
        code = 31 * code + Long.hashCode(this.totalCountCapacity);
        code = 31 * code + this.itemDataMap.size();
        code = 31 * code + this.totalTypeCapacity;
        code = 31 * code + this.color.ordinal();
        return code;
    }

    @Override
    public void write(PacketBuffer buf) {
        super.write(buf);
        buf.func_179254_b(this.totalCount);
        buf.func_179254_b(this.totalCountCapacity);
        buf.func_150787_b(this.itemDataMap.size());
        buf.func_150787_b(this.totalTypeCapacity);
        buf.func_179249_a((Enum)this.color);
    }

    @Override
    public void read(PacketBuffer buf) {
        super.read(buf);
        this.totalCount = buf.func_179260_f();
        this.totalCountCapacity = buf.func_179260_f();
        this.clientTypes = buf.func_150792_a();
        this.totalTypeCapacity = buf.func_150792_a();
        this.color = (EnumColor)buf.func_179257_a(EnumColor.class);
    }

    @Override
    public void write(CompoundNBT nbtTags) {
        super.write(nbtTags);
        nbtTags.func_74768_a("color", this.color.ordinal());
    }

    @Override
    protected void read(CompoundNBT nbtTags) {
        super.read(nbtTags);
        NBTUtils.setEnumIfPresent(nbtTags, "color", EnumColor::byIndexStatic, value -> {
            this.color = value;
        });
    }

    public void addDrive(QIODriveData.QIODriveKey key) {
        if (key.getDriveStack().func_77973_b() instanceof IQIODriveItem) {
            if (this.driveMap.containsKey(key)) {
                this.removeDrive(key, true);
            }
            QIODriveData data = new QIODriveData(key);
            this.totalCountCapacity += data.getCountCapacity();
            this.totalTypeCapacity += data.getTypeCapacity();
            this.driveMap.put(key, data);
            data.getItemMap().forEach((storedKey, value) -> {
                this.itemDataMap.computeIfAbsent((HashedItem)storedKey, e -> {
                    this.tagWildcardCache.clear();
                    this.tagLookupMap.putAll((Collection<String>)TagCache.getItemTags(e.getStack()), (HashedItem)e);
                    this.itemTypeLookup.put(e, (Object)UUID.randomUUID());
                    return new QIOItemTypeData((HashedItem)e);
                }).addFromDrive(data, value);
                this.updatedItems.add(new HashedItem.UUIDAwareHashedItem((HashedItem)storedKey, this.getUUIDForType((HashedItem)storedKey)));
            });
            this.setNeedsUpdate();
        }
    }

    public void removeDrive(QIODriveData.QIODriveKey key, boolean updateItemMap) {
        if (!this.driveMap.containsKey(key)) {
            return;
        }
        QIODriveData data = this.driveMap.get(key);
        if (updateItemMap) {
            data.getItemMap().forEach((storedKey, value) -> {
                QIOItemTypeData itemData = this.itemDataMap.get(storedKey);
                if (itemData != null) {
                    itemData.containingDrives.remove(key);
                    QIOItemTypeData qIOItemTypeData = itemData;
                    qIOItemTypeData.count = qIOItemTypeData.count - value;
                    this.totalCount -= value.longValue();
                    if (itemData.containingDrives.isEmpty() || itemData.count == 0L) {
                        this.itemDataMap.remove(storedKey);
                        this.tagWildcardCache.clear();
                    }
                    this.updatedItems.add(new HashedItem.UUIDAwareHashedItem((HashedItem)storedKey, this.getUUIDForType((HashedItem)storedKey)));
                }
            });
            this.setNeedsUpdate();
        }
        this.totalCountCapacity -= data.getCountCapacity();
        this.totalTypeCapacity -= data.getTypeCapacity();
        this.driveMap.remove(key);
        key.updateMetadata(data);
        key.save(data);
    }

    public void saveAll() {
        this.driveMap.forEach((key, value) -> {
            key.updateMetadata((QIODriveData)value);
            key.save((QIODriveData)value);
        });
    }

    private void addHolder(IQIODriveHolder holder) {
        this.driveHolders.add(holder);
        for (int i = 0; i < holder.getDriveSlots().size(); ++i) {
            this.addDrive(new QIODriveData.QIODriveKey(holder, i));
        }
    }

    private void setNeedsUpdate(@Nullable HashedItem changedItem) {
        this.needsUpdate = true;
        this.isDirty = true;
        if (changedItem != null) {
            this.updatedItems.add(new HashedItem.UUIDAwareHashedItem(changedItem, this.getUUIDForType(changedItem)));
        }
    }

    private void setNeedsUpdate() {
        this.setNeedsUpdate(null);
    }

    private /* synthetic */ void lambda$tick$6(Object2LongMap map, ServerPlayerEntity player) {
        Mekanism.packetHandler.sendTo(PacketQIOItemViewerGuiSync.update((Object2LongMap<HashedItem.UUIDAwareHashedItem>)map, this.totalCountCapacity, this.totalTypeCapacity), player);
    }

    private /* synthetic */ void lambda$tick$4(Object2LongMap map, HashedItem.UUIDAwareHashedItem type) {
        QIOItemTypeData data = this.itemDataMap.get(type);
        map.put((Object)type, data == null ? 0L : data.count);
    }

    private /* synthetic */ void lambda$openItemViewer$3(Object2LongMap map, QIOItemTypeData d) {
        map.put((Object)new HashedItem.UUIDAwareHashedItem(d.itemType, this.getUUIDForType(d.itemType)), d.count);
    }

    private /* synthetic */ void lambda$getStacksByWildcard$2(Object2LongMap ret, String tag) {
        ret.putAll(this.getStacksByTag(tag));
    }

    private /* synthetic */ void lambda$getStacksByTag$1(Object2LongMap ret, HashedItem item) {
        ret.put((Object)item, this.getStored(item));
    }

    public class QIOItemTypeData {
        private final HashedItem itemType;
        private long count = 0L;
        private final Set<QIODriveData.QIODriveKey> containingDrives = new HashSet<QIODriveData.QIODriveKey>();

        public QIOItemTypeData(HashedItem itemType) {
            this.itemType = itemType;
        }

        private void addFromDrive(QIODriveData data, long toAdd) {
            this.count += toAdd;
            QIOFrequency.this.totalCount = QIOFrequency.this.totalCount + toAdd;
            this.containingDrives.add(data.getKey());
            QIOFrequency.this.setNeedsUpdate();
        }

        private long add(long amount) {
            long toAdd = amount;
            for (QIODriveData.QIODriveKey key : this.containingDrives) {
                if ((toAdd = this.addItemsToDrive(toAdd, (QIODriveData)QIOFrequency.this.driveMap.get(key))) != 0L) continue;
                break;
            }
            if (toAdd > 0L) {
                QIODriveData data;
                Iterator<QIODriveData.QIODriveKey> iterator = QIOFrequency.this.driveMap.values().iterator();
                while (iterator.hasNext() && (this.containingDrives.contains((data = (QIODriveData)((Object)iterator.next())).getKey()) || (toAdd = this.addItemsToDrive(toAdd, data)) != 0L)) {
                }
            }
            this.count += amount - toAdd;
            QIOFrequency.this.totalCount = QIOFrequency.this.totalCount + (amount - toAdd);
            QIOFrequency.this.setNeedsUpdate(this.itemType);
            return toAdd;
        }

        private long addItemsToDrive(long toAdd, QIODriveData data) {
            long rejects = data.add(this.itemType, toAdd);
            if (rejects < toAdd) {
                this.containingDrives.add(data.getKey());
            }
            return rejects;
        }

        private ItemStack remove(int amount) {
            ItemStack ret = ItemStack.field_190927_a;
            Iterator<QIODriveData.QIODriveKey> iter = this.containingDrives.iterator();
            while (iter.hasNext()) {
                QIODriveData data = (QIODriveData)QIOFrequency.this.driveMap.get(iter.next());
                ItemStack stack = data.remove(this.itemType, amount - ret.func_190916_E());
                if (ret.func_190926_b()) {
                    ret = stack;
                } else {
                    ret.func_190917_f(stack.func_190916_E());
                }
                if (data.getStored(this.itemType) == 0L) {
                    iter.remove();
                }
                if (ret.func_190916_E() != amount) continue;
                break;
            }
            this.count -= (long)ret.func_190916_E();
            QIOFrequency.this.totalCount = QIOFrequency.this.totalCount - (long)ret.func_190916_E();
            QIOFrequency.this.setNeedsUpdate(this.itemType);
            return ret;
        }

        public long getCount() {
            return this.count;
        }
    }
}

