/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.integration.lookingat.theoneprobe;

import java.util.function.Function;
import mcjty.theoneprobe.api.CompoundText;
import mcjty.theoneprobe.api.IElement;
import mcjty.theoneprobe.api.IProbeConfig;
import mcjty.theoneprobe.api.IProbeConfigProvider;
import mcjty.theoneprobe.api.IProbeHitData;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.IProbeInfoProvider;
import mcjty.theoneprobe.api.ITheOneProbe;
import mcjty.theoneprobe.api.ProbeMode;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.chemical.gas.GasStack;
import mekanism.api.chemical.infuse.InfusionStack;
import mekanism.api.chemical.pigment.PigmentStack;
import mekanism.api.chemical.slurry.SlurryStack;
import mekanism.api.math.FloatingLong;
import mekanism.common.Mekanism;
import mekanism.common.block.BlockBounding;
import mekanism.common.integration.lookingat.LookingAtHelper;
import mekanism.common.integration.lookingat.LookingAtUtils;
import mekanism.common.integration.lookingat.theoneprobe.ProbeConfigProvider;
import mekanism.common.integration.lookingat.theoneprobe.TOPChemicalElement;
import mekanism.common.integration.lookingat.theoneprobe.TOPEnergyElement;
import mekanism.common.integration.lookingat.theoneprobe.TOPFluidElement;
import mekanism.common.util.WorldUtils;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;

public class TOPProvider
implements IProbeInfoProvider,
Function<ITheOneProbe, Void> {
    private boolean displayFluidTanks;
    private IProbeConfig.ConfigMode tankMode = IProbeConfig.ConfigMode.EXTENDED;
    static int ENERGY_ELEMENT_ID;
    static int FLUID_ELEMENT_ID;
    static int GAS_ELEMENT_ID;
    static int INFUSION_ELEMENT_ID;
    static int PIGMENT_ELEMENT_ID;
    static int SLURRY_ELEMENT_ID;

    @Override
    public Void apply(ITheOneProbe probe) {
        probe.registerProvider((IProbeInfoProvider)this);
        probe.registerProbeConfigProvider((IProbeConfigProvider)ProbeConfigProvider.INSTANCE);
        ENERGY_ELEMENT_ID = probe.registerElementFactory(TOPEnergyElement::new);
        FLUID_ELEMENT_ID = probe.registerElementFactory(TOPFluidElement::new);
        GAS_ELEMENT_ID = probe.registerElementFactory(TOPChemicalElement.GasElement::new);
        INFUSION_ELEMENT_ID = probe.registerElementFactory(TOPChemicalElement.InfuseTypeElement::new);
        PIGMENT_ELEMENT_ID = probe.registerElementFactory(TOPChemicalElement.PigmentElement::new);
        SLURRY_ELEMENT_ID = probe.registerElementFactory(TOPChemicalElement.SlurryElement::new);
        IProbeConfig probeConfig = probe.createProbeConfig();
        this.displayFluidTanks = probeConfig.getTankMode() > 0;
        this.tankMode = probeConfig.getShowTankSetting();
        return null;
    }

    public String getID() {
        return Mekanism.rl("chemicals").toString();
    }

    public void addProbeInfo(ProbeMode mode, IProbeInfo info, PlayerEntity player, World world, BlockState blockState, IProbeHitData data) {
        TileEntity tile;
        BlockPos mainPos;
        BlockPos pos = data.getPos();
        if (blockState.func_177230_c() instanceof BlockBounding && (mainPos = BlockBounding.getMainBlockPos((IBlockReader)world, pos)) != null) {
            pos = mainPos;
        }
        if ((tile = WorldUtils.getTileEntity((IBlockReader)world, pos)) != null) {
            LookingAtUtils.addInfo(new TOPLookingAtHelper(info), tile, this.displayTanks(mode), this.displayFluidTanks);
        }
    }

    private boolean displayTanks(ProbeMode mode) {
        if (this.tankMode == IProbeConfig.ConfigMode.NOT) {
            return false;
        }
        if (this.tankMode == IProbeConfig.ConfigMode.NORMAL) {
            return mode == ProbeMode.NORMAL;
        }
        return mode == ProbeMode.EXTENDED;
    }

    private static class TOPLookingAtHelper
    implements LookingAtHelper {
        private final IProbeInfo info;

        public TOPLookingAtHelper(IProbeInfo info) {
            this.info = info;
        }

        @Override
        public void addText(ITextComponent text) {
            this.info.text(CompoundText.create().name(text).get());
        }

        @Override
        public void addEnergyElement(FloatingLong energy, FloatingLong maxEnergy) {
            this.info.element((IElement)new TOPEnergyElement(energy, maxEnergy));
        }

        @Override
        public void addFluidElement(FluidStack stored, int capacity) {
            this.info.element((IElement)new TOPFluidElement(stored, capacity));
        }

        @Override
        public void addChemicalElement(ChemicalStack<?> stored, long capacity) {
            if (stored instanceof GasStack) {
                this.info.element((IElement)new TOPChemicalElement.GasElement((GasStack)stored, capacity));
            } else if (stored instanceof InfusionStack) {
                this.info.element((IElement)new TOPChemicalElement.InfuseTypeElement((InfusionStack)stored, capacity));
            } else if (stored instanceof PigmentStack) {
                this.info.element((IElement)new TOPChemicalElement.PigmentElement((PigmentStack)stored, capacity));
            } else if (stored instanceof SlurryStack) {
                this.info.element((IElement)new TOPChemicalElement.SlurryElement((SlurryStack)stored, capacity));
            }
        }
    }
}

