/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.inventory.container;

import it.unimi.dsi.fastutil.objects.Object2LongMap;
import it.unimi.dsi.fastutil.objects.Object2LongOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nonnull;
import mekanism.api.math.MathUtils;
import mekanism.api.text.ILangEntry;
import mekanism.common.Mekanism;
import mekanism.common.MekanismLang;
import mekanism.common.config.MekanismConfig;
import mekanism.common.content.qio.QIOFrequency;
import mekanism.common.content.qio.SearchQueryParser;
import mekanism.common.inventory.GuiComponents;
import mekanism.common.inventory.ISlotClickHandler;
import mekanism.common.inventory.container.MekanismContainer;
import mekanism.common.inventory.container.slot.InventoryContainerSlot;
import mekanism.common.lib.inventory.HashedItem;
import mekanism.common.network.PacketGuiItemDataRequest;
import mekanism.common.network.PacketQIOItemViewerSlotInteract;
import mekanism.common.registration.impl.ContainerTypeRegistryObject;
import mekanism.common.util.InventoryUtils;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.StackUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;

public abstract class QIOItemViewerContainer
extends MekanismContainer
implements ISlotClickHandler {
    public static final int SLOTS_X_MIN = 8;
    public static final int SLOTS_X_MAX = 16;
    public static final int SLOTS_Y_MIN = 2;
    public static final int SLOTS_Y_MAX = 48;
    public static final int SLOTS_START_Y = 43;
    private static final int DOUBLE_CLICK_TRANSFER_DURATION = 20;
    private ListSortType sortType;
    private SortDirection sortDirection;
    private Object2LongMap<HashedItem.UUIDAwareHashedItem> cachedInventory;
    private long cachedCountCapacity;
    private int cachedTypeCapacity;
    private long totalItems;
    private List<ISlotClickHandler.IScrollableSlot> itemList;
    private List<ISlotClickHandler.IScrollableSlot> searchList;
    private Map<String, List<ISlotClickHandler.IScrollableSlot>> searchCache;
    private String searchQuery;
    private int doubleClickTransferTicks;
    private int lastSlot;
    private ItemStack lastStack;

    public static int getSlotsYMax() {
        int maxY = (int)Math.ceil((double)Minecraft.func_71410_x().func_228018_at_().func_198087_p() * 0.05 - 8.0) + 1;
        return Math.max(Math.min(maxY, 48), 2);
    }

    protected QIOItemViewerContainer(ContainerTypeRegistryObject<?> type, int id, PlayerInventory inv, boolean remote) {
        super(type, id, inv);
        this.sortType = (ListSortType)MekanismConfig.client.qioItemViewerSortType.get();
        this.sortDirection = (SortDirection)MekanismConfig.client.qioItemViewerSortDirection.get();
        this.cachedInventory = new Object2LongOpenHashMap();
        this.searchCache = new Object2ObjectOpenHashMap();
        this.searchQuery = "";
        this.doubleClickTransferTicks = 0;
        this.lastSlot = -1;
        this.lastStack = ItemStack.field_190927_a;
        if (remote) {
            int maxY = QIOItemViewerContainer.getSlotsYMax();
            if (MekanismConfig.client.qioItemViewerSlotsY.get() > maxY) {
                MekanismConfig.client.qioItemViewerSlotsY.set(maxY);
                MekanismConfig.client.getConfigSpec().save();
            }
        }
    }

    public abstract QIOFrequency getFrequency();

    public abstract QIOItemViewerContainer recreate();

    protected void sync(QIOItemViewerContainer container) {
        container.sortType = this.sortType;
        container.cachedInventory = this.cachedInventory;
        container.cachedCountCapacity = this.cachedCountCapacity;
        container.cachedTypeCapacity = this.cachedTypeCapacity;
        container.totalItems = this.totalItems;
        container.itemList = this.itemList;
        container.searchList = this.searchList;
        container.searchCache = this.searchCache;
        container.searchQuery = this.searchQuery;
    }

    @Override
    protected int getInventoryYOffset() {
        return 43 + MekanismConfig.client.qioItemViewerSlotsY.get() * 18 + 15;
    }

    @Override
    protected int getInventoryXOffset() {
        return super.getInventoryXOffset() + (MekanismConfig.client.qioItemViewerSlotsX.get() - 8) * 18 / 2;
    }

    @Override
    protected void openInventory(@Nonnull PlayerInventory inv) {
        super.openInventory(inv);
        if (inv.field_70458_d.field_70170_p.func_201670_d()) {
            Mekanism.packetHandler.sendToServer(PacketGuiItemDataRequest.qioItemViewer());
        }
    }

    @Override
    protected void closeInventory(PlayerEntity player) {
        super.closeInventory(player);
        QIOFrequency freq = this.getFrequency();
        if (!this.inv.field_70458_d.field_70170_p.func_201670_d() && freq != null) {
            freq.closeItemViewer((ServerPlayerEntity)this.inv.field_70458_d);
        }
    }

    @Override
    public void func_75142_b() {
        super.func_75142_b();
        if (this.doubleClickTransferTicks > 0) {
            --this.doubleClickTransferTicks;
        } else {
            this.resetTransferTracker();
        }
    }

    private void resetTransferTracker() {
        this.doubleClickTransferTicks = 0;
        this.lastSlot = -1;
        this.lastStack = ItemStack.field_190927_a;
    }

    private void setTransferTracker(ItemStack stack, int slot) {
        this.doubleClickTransferTicks = 20;
        this.lastSlot = slot;
        this.lastStack = stack;
    }

    private void doDoubleClickTransfer(PlayerEntity player) {
        QIOFrequency freq = this.getFrequency();
        this.mainInventorySlots.forEach(slot -> {
            if (slot.func_75216_d() && slot.func_82869_a(player) && InventoryUtils.areItemsStackable(this.lastStack, slot.func_75211_c())) {
                this.updateSlot(player, (Slot)slot, freq.addItem(slot.func_75211_c()));
            }
        });
        this.hotBarSlots.forEach(slot -> {
            if (slot.func_75216_d() && slot.func_82869_a(player) && InventoryUtils.areItemsStackable(this.lastStack, slot.func_75211_c())) {
                this.updateSlot(player, (Slot)slot, freq.addItem(slot.func_75211_c()));
            }
        });
    }

    @Override
    @Nonnull
    public ItemStack func_82846_b(@Nonnull PlayerEntity player, int slotID) {
        Slot currentSlot = (Slot)this.field_75151_b.get(slotID);
        if (currentSlot == null) {
            return ItemStack.field_190927_a;
        }
        ItemStack slotStack = currentSlot.func_75211_c().func_77946_l();
        if (!(currentSlot instanceof InventoryContainerSlot)) {
            QIOFrequency frequency;
            if (!player.field_70170_p.func_201670_d() && (frequency = this.getFrequency()) != null) {
                if (!slotStack.func_190926_b()) {
                    ItemStack ret = frequency.addItem(slotStack);
                    if (slotStack.func_190916_E() == ret.func_190916_E()) {
                        return ItemStack.field_190927_a;
                    }
                    this.setTransferTracker(slotStack, slotID);
                    return this.updateSlot(player, currentSlot, ret);
                }
                if (slotID == this.lastSlot && !this.lastStack.func_190926_b()) {
                    this.doDoubleClickTransfer(player);
                }
                this.resetTransferTracker();
                return ItemStack.field_190927_a;
            }
            return ItemStack.field_190927_a;
        }
        return super.func_82846_b(player, slotID);
    }

    private ItemStack updateSlot(PlayerEntity player, Slot currentSlot, ItemStack ret) {
        int difference = currentSlot.func_75211_c().func_190916_E() - ret.func_190916_E();
        currentSlot.func_75209_a(difference);
        ItemStack newStack = StackUtils.size(currentSlot.func_75211_c(), difference);
        currentSlot.func_190901_a(player, newStack);
        return newStack;
    }

    public void handleBatchUpdate(Object2LongMap<HashedItem.UUIDAwareHashedItem> itemMap, long countCapacity, int typeCapacity) {
        this.cachedInventory = itemMap;
        this.cachedCountCapacity = countCapacity;
        this.cachedTypeCapacity = typeCapacity;
        this.syncItemList();
    }

    public void handleUpdate(Object2LongMap<HashedItem.UUIDAwareHashedItem> itemMap, long countCapacity, int typeCapacity) {
        itemMap.object2LongEntrySet().forEach(entry -> {
            long value = entry.getLongValue();
            if (value == 0L) {
                this.cachedInventory.removeLong(entry.getKey());
            } else {
                this.cachedInventory.put(entry.getKey(), value);
            }
        });
        this.cachedCountCapacity = countCapacity;
        this.cachedTypeCapacity = typeCapacity;
        this.syncItemList();
    }

    public void handleKill() {
        this.itemList = null;
        this.searchList = null;
        this.cachedInventory.clear();
    }

    private void syncItemList() {
        if (this.itemList == null) {
            this.itemList = new ArrayList<ISlotClickHandler.IScrollableSlot>();
        }
        this.itemList.clear();
        this.searchCache.clear();
        this.totalItems = 0L;
        this.cachedInventory.forEach((key, value) -> {
            this.itemList.add(new ItemSlotData((HashedItem)key, key.getUUID(), (long)value));
            this.totalItems += value.longValue();
        });
        this.sortItemList();
        if (!this.searchQuery.isEmpty()) {
            this.updateSearch(this.searchQuery);
        }
    }

    private void sortItemList() {
        if (this.itemList == null) {
            return;
        }
        this.sortType.sort(this.itemList, this.sortDirection);
    }

    public void setSortDirection(SortDirection sortDirection) {
        this.sortDirection = sortDirection;
        MekanismConfig.client.qioItemViewerSortDirection.set(sortDirection);
        MekanismConfig.client.getConfigSpec().save();
        this.sortItemList();
    }

    public SortDirection getSortDirection() {
        return this.sortDirection;
    }

    public void setSortType(ListSortType sortType) {
        this.sortType = sortType;
        MekanismConfig.client.qioItemViewerSortType.set(sortType);
        MekanismConfig.client.getConfigSpec().save();
        this.sortItemList();
    }

    public ListSortType getSortType() {
        return this.sortType;
    }

    public List<ISlotClickHandler.IScrollableSlot> getQIOItemList() {
        return !this.searchQuery.isEmpty() ? this.searchList : this.itemList;
    }

    public long getCountCapacity() {
        return this.cachedCountCapacity;
    }

    public int getTypeCapacity() {
        return this.cachedTypeCapacity;
    }

    public long getTotalItems() {
        return this.totalItems;
    }

    public int getTotalTypes() {
        return this.itemList != null ? this.itemList.size() : 0;
    }

    public ItemStack insertIntoPlayerInventory(ItemStack stack) {
        stack = this.insertItem(this.hotBarSlots, stack, true);
        stack = this.insertItem(this.mainInventorySlots, stack, true);
        stack = this.insertItem(this.hotBarSlots, stack, false);
        stack = this.insertItem(this.mainInventorySlots, stack, false);
        return stack;
    }

    public void updateSearch(String queryText) {
        if (!this.inv.field_70458_d.field_70170_p.func_201670_d() || this.itemList == null) {
            return;
        }
        List<ISlotClickHandler.IScrollableSlot> list = this.searchCache.get(queryText);
        if (list != null) {
            this.searchList = list;
            this.searchQuery = queryText;
            return;
        }
        list = new ArrayList<ISlotClickHandler.IScrollableSlot>();
        SearchQueryParser.ISearchQuery query = SearchQueryParser.parse(queryText);
        for (ISlotClickHandler.IScrollableSlot slot : this.itemList) {
            if (!query.matches(slot.getItem().getStack())) continue;
            list.add(slot);
        }
        this.searchList = list;
        this.searchQuery = queryText;
        this.searchCache.put(queryText, this.searchList);
    }

    @Override
    public void onClick(ISlotClickHandler.IScrollableSlot slot, int button, boolean hasShiftDown, ItemStack heldItem) {
        if (hasShiftDown) {
            if (slot != null) {
                Mekanism.packetHandler.sendToServer(PacketQIOItemViewerSlotInteract.shiftTake(slot.getItemUUID()));
            }
            return;
        }
        if (button == 0) {
            if (heldItem.func_190926_b() && slot != null) {
                int toTake = Math.min(slot.getItem().getStack().func_77976_d(), MathUtils.clampToInt(slot.getCount()));
                Mekanism.packetHandler.sendToServer(PacketQIOItemViewerSlotInteract.take(slot.getItemUUID(), toTake));
            } else if (!heldItem.func_190926_b()) {
                Mekanism.packetHandler.sendToServer(PacketQIOItemViewerSlotInteract.put(heldItem.func_190916_E()));
            }
        } else if (button == 1) {
            if (heldItem.func_190926_b() && slot != null) {
                int toTake = Math.min(slot.getItem().getStack().func_77976_d(), Math.max(1, MathUtils.clampToInt(slot.getCount() / 2L)));
                Mekanism.packetHandler.sendToServer(PacketQIOItemViewerSlotInteract.take(slot.getItemUUID(), toTake));
            } else if (!heldItem.func_190926_b()) {
                Mekanism.packetHandler.sendToServer(PacketQIOItemViewerSlotInteract.put(1));
            }
        }
    }

    public static enum ListSortType implements GuiComponents.IDropdownEnum<ListSortType>
    {
        NAME(MekanismLang.LIST_SORT_NAME, MekanismLang.LIST_SORT_NAME_DESC, (a, b) -> a.getDisplayName().compareTo(b.getDisplayName())),
        SIZE(MekanismLang.LIST_SORT_COUNT, MekanismLang.LIST_SORT_COUNT_DESC, (a, b) -> Long.compare(a.getCount(), b.getCount())),
        MOD(MekanismLang.LIST_SORT_MOD, MekanismLang.LIST_SORT_MOD_DESC, (a, b) -> a.getModID().compareTo(b.getModID()));

        private final ILangEntry name;
        private final ILangEntry tooltip;
        private final Comparator<ISlotClickHandler.IScrollableSlot> comparator;

        private ListSortType(ILangEntry name, ILangEntry tooltip, Comparator<ISlotClickHandler.IScrollableSlot> comparator) {
            this.name = name;
            this.tooltip = tooltip;
            this.comparator = comparator;
        }

        public void sort(List<ISlotClickHandler.IScrollableSlot> list, SortDirection direction) {
            list.sort(direction.isAscending() ? this.comparator : this.comparator.reversed());
        }

        @Override
        public ITextComponent getTooltip() {
            return this.tooltip.translate(new Object[0]);
        }

        @Override
        public ITextComponent getShortName() {
            return this.name.translate(new Object[0]);
        }
    }

    public static enum SortDirection implements GuiComponents.IToggleEnum<SortDirection>
    {
        ASCENDING(MekanismUtils.getResource(MekanismUtils.ResourceType.GUI, "arrow_up.png"), MekanismLang.LIST_SORT_ASCENDING_DESC),
        DESCENDING(MekanismUtils.getResource(MekanismUtils.ResourceType.GUI, "arrow_down.png"), MekanismLang.LIST_SORT_DESCENDING_DESC);

        private final ResourceLocation icon;
        private final ILangEntry tooltip;

        private SortDirection(ResourceLocation icon, ILangEntry tooltip) {
            this.icon = icon;
            this.tooltip = tooltip;
        }

        @Override
        public ResourceLocation getIcon() {
            return this.icon;
        }

        @Override
        public ITextComponent getTooltip() {
            return this.tooltip.translate(new Object[0]);
        }

        public boolean isAscending() {
            return this == ASCENDING;
        }
    }

    public static class ItemSlotData
    implements ISlotClickHandler.IScrollableSlot {
        private final HashedItem itemType;
        private final UUID typeUUID;
        private final long count;

        private ItemSlotData(HashedItem itemType, UUID typeUUID, long count) {
            this.itemType = itemType;
            this.typeUUID = typeUUID;
            this.count = count;
        }

        @Override
        public HashedItem getItem() {
            return this.itemType;
        }

        @Override
        public UUID getItemUUID() {
            return this.typeUUID;
        }

        @Override
        public long getCount() {
            return this.count;
        }

        @Override
        public String getModID() {
            return MekanismUtils.getModId(this.getItem().getStack());
        }

        @Override
        public String getDisplayName() {
            return this.getItem().getStack().func_200301_q().getString();
        }
    }
}

