/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.inventory.slot;

import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import mekanism.api.Action;
import mekanism.api.annotations.FieldsAreNonnullByDefault;
import mekanism.api.inventory.AutomationType;
import mekanism.api.inventory.IMekanismInventory;
import mekanism.common.content.qio.IQIODriveHolder;
import mekanism.common.content.qio.IQIODriveItem;
import mekanism.common.content.qio.QIODriveData;
import mekanism.common.content.qio.QIOFrequency;
import mekanism.common.inventory.slot.BasicInventorySlot;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;

@FieldsAreNonnullByDefault
@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class QIODriveSlot
extends BasicInventorySlot {
    private final IQIODriveHolder driveHolder;
    private final QIODriveData.QIODriveKey key;

    public <TILE extends IMekanismInventory & IQIODriveHolder> QIODriveSlot(TILE inventory, int slot, int x, int y) {
        super(notExternal, notExternal, (ItemStack stack) -> stack.func_77973_b() instanceof IQIODriveItem, inventory, x, y);
        this.key = new QIODriveData.QIODriveKey(inventory, slot);
        this.driveHolder = inventory;
    }

    @Override
    public void setStack(ItemStack stack) {
        if (!this.isRemote() && !this.isEmpty()) {
            this.removeDrive();
        }
        super.setStack(stack);
        if (!this.isRemote() && !this.isEmpty()) {
            this.addDrive(this.getStack());
        }
    }

    @Override
    public ItemStack insertItem(ItemStack stack, Action action, AutomationType automationType) {
        ItemStack ret = super.insertItem(stack, action, automationType);
        if (!this.isRemote() && action.execute() && ret.func_190926_b()) {
            this.addDrive(stack);
        }
        return ret;
    }

    @Override
    public ItemStack extractItem(int amount, Action action, AutomationType automationType) {
        ItemStack ret;
        if (!this.isRemote() && action.execute() && !(ret = super.extractItem(amount, Action.SIMULATE, automationType)).func_190926_b()) {
            this.removeDrive();
        }
        return super.extractItem(amount, action, automationType);
    }

    public QIODriveData.QIODriveKey getKey() {
        return this.key;
    }

    private boolean isRemote() {
        return ((TileEntity)this.driveHolder).func_145831_w().func_201670_d();
    }

    private void addDrive(ItemStack stack) {
        QIOFrequency frequency = this.driveHolder.getQIOFrequency();
        if (frequency != null) {
            frequency.addDrive(this.key);
        }
    }

    private void removeDrive() {
        QIOFrequency frequency = this.driveHolder.getQIOFrequency();
        if (frequency != null) {
            frequency.removeDrive(this.key, true);
        }
    }
}

