/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.item;

import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import mekanism.api.IConfigCardAccess;
import mekanism.api.text.EnumColor;
import mekanism.api.text.TextComponentUtil;
import mekanism.common.MekanismLang;
import mekanism.common.capabilities.Capabilities;
import mekanism.common.tile.base.TileEntityMekanism;
import mekanism.common.tile.interfaces.IRedstoneControl;
import mekanism.common.tile.interfaces.ISideConfiguration;
import mekanism.common.util.CapabilityUtils;
import mekanism.common.util.ItemDataUtils;
import mekanism.common.util.SecurityUtils;
import mekanism.common.util.WorldUtils;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.item.Rarity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.ICapabilityProvider;

public class ItemConfigurationCard
extends Item {
    public ItemConfigurationCard(Item.Properties properties) {
        super(properties.func_200917_a(1).func_208103_a(Rarity.UNCOMMON));
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(@Nonnull ItemStack stack, World world, List<ITextComponent> tooltip, @Nonnull ITooltipFlag flag) {
        tooltip.add((ITextComponent)MekanismLang.CONFIG_CARD_HAS_DATA.translateColored(EnumColor.GRAY, EnumColor.INDIGO, TextComponentUtil.translate(this.getDataType(stack), new Object[0])));
    }

    @Nonnull
    public ActionResultType func_195939_a(ItemUseContext context) {
        PlayerEntity player = context.func_195999_j();
        World world = context.func_195991_k();
        if (!world.field_72995_K && player != null) {
            BlockPos pos = context.func_195995_a();
            Direction side = context.func_196000_l();
            TileEntity tile = WorldUtils.getTileEntity((IBlockReader)world, pos);
            if (CapabilityUtils.getCapability((ICapabilityProvider)tile, Capabilities.CONFIG_CARD_CAPABILITY, side).isPresent()) {
                if (SecurityUtils.canAccess(player, tile)) {
                    ItemStack stack = player.func_184586_b(context.func_221531_n());
                    if (player.func_225608_bj_()) {
                        CompoundNBT data;
                        Optional configData = CapabilityUtils.getCapability((ICapabilityProvider)tile, Capabilities.SPECIAL_CONFIG_DATA_CAPABILITY, side).resolve();
                        CompoundNBT compoundNBT = data = configData.isPresent() ? ((IConfigCardAccess.ISpecialConfigData)configData.get()).getConfigurationData(this.getBaseData(tile)) : this.getBaseData(tile);
                        if (data != null) {
                            data.func_74778_a("dataType", this.getNameFromTile(tile, side));
                            this.setData(stack, data);
                            player.func_145747_a((ITextComponent)MekanismLang.LOG_FORMAT.translateColored(EnumColor.DARK_BLUE, MekanismLang.MEKANISM, MekanismLang.CONFIG_CARD_GOT.translateColored(EnumColor.GRAY, EnumColor.INDIGO, TextComponentUtil.translate(data.func_74779_i("dataType"), new Object[0]))), Util.field_240973_b_);
                        }
                        return ActionResultType.SUCCESS;
                    }
                    CompoundNBT data = this.getData(stack);
                    if (data != null) {
                        if (this.getNameFromTile(tile, side).equals(this.getDataType(stack))) {
                            this.setBaseData(data, tile);
                            CapabilityUtils.getCapability((ICapabilityProvider)tile, Capabilities.SPECIAL_CONFIG_DATA_CAPABILITY, side).ifPresent(special -> special.setConfigurationData(data));
                            if (tile instanceof TileEntityMekanism) {
                                TileEntityMekanism mekanismTile = (TileEntityMekanism)tile;
                                mekanismTile.invalidateCachedCapabilities();
                                mekanismTile.sendUpdatePacket();
                                WorldUtils.notifyLoadedNeighborsOfTileChange(world, pos);
                            }
                            player.func_145747_a((ITextComponent)MekanismLang.LOG_FORMAT.translateColored(EnumColor.DARK_BLUE, MekanismLang.MEKANISM, MekanismLang.CONFIG_CARD_SET.translateColored(EnumColor.DARK_GREEN, EnumColor.INDIGO, TextComponentUtil.translate(this.getDataType(stack), new Object[0]))), Util.field_240973_b_);
                        } else {
                            player.func_145747_a((ITextComponent)MekanismLang.LOG_FORMAT.translateColored(EnumColor.DARK_BLUE, MekanismLang.MEKANISM, EnumColor.RED, MekanismLang.CONFIG_CARD_UNEQUAL), Util.field_240973_b_);
                        }
                        return ActionResultType.SUCCESS;
                    }
                } else {
                    SecurityUtils.displayNoAccess(player);
                }
            }
        }
        return ActionResultType.PASS;
    }

    private CompoundNBT getBaseData(TileEntity tile) {
        CompoundNBT nbtTags = new CompoundNBT();
        if (tile instanceof IRedstoneControl) {
            nbtTags.func_74768_a("controlType", ((IRedstoneControl)tile).getControlType().ordinal());
        }
        if (tile instanceof ISideConfiguration) {
            ((ISideConfiguration)tile).getConfig().write(nbtTags);
            ((ISideConfiguration)tile).getEjector().write(nbtTags);
        }
        return nbtTags;
    }

    private void setBaseData(CompoundNBT nbtTags, TileEntity tile) {
        if (tile instanceof IRedstoneControl) {
            ((IRedstoneControl)tile).setControlType(IRedstoneControl.RedstoneControl.byIndexStatic(nbtTags.func_74762_e("controlType")));
        }
        if (tile instanceof ISideConfiguration) {
            ((ISideConfiguration)tile).getConfig().read(nbtTags);
            ((ISideConfiguration)tile).getEjector().read(nbtTags);
        }
    }

    private String getNameFromTile(TileEntity tile, Direction side) {
        Optional capability = CapabilityUtils.getCapability((ICapabilityProvider)tile, Capabilities.SPECIAL_CONFIG_DATA_CAPABILITY, side).resolve();
        if (capability.isPresent()) {
            return ((IConfigCardAccess.ISpecialConfigData)capability.get()).getDataType();
        }
        String ret = Integer.toString(tile.hashCode());
        if (tile instanceof TileEntityMekanism) {
            ret = ((TileEntityMekanism)tile).getBlockType().func_149739_a();
        }
        return ret;
    }

    private void setData(ItemStack stack, CompoundNBT data) {
        if (data == null) {
            ItemDataUtils.removeData(stack, "data");
        } else {
            ItemDataUtils.setCompound(stack, "data", data);
        }
    }

    private CompoundNBT getData(ItemStack stack) {
        CompoundNBT data = ItemDataUtils.getCompound(stack, "data");
        if (data.isEmpty()) {
            return null;
        }
        return ItemDataUtils.getCompound(stack, "data");
    }

    public String getDataType(ItemStack stack) {
        CompoundNBT data = this.getData(stack);
        if (data == null) {
            return MekanismLang.NONE.getTranslationKey();
        }
        return data.func_74779_i("dataType");
    }
}

