/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.item.block;

import javax.annotation.Nonnull;
import mekanism.common.item.block.ItemBlockMekanism;
import mekanism.common.registration.impl.ItemDeferredRegister;
import mekanism.common.util.WorldUtils;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.SoundType;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;

public abstract class ItemBlockMultipartAble<BLOCK extends Block>
extends ItemBlockMekanism<BLOCK> {
    public ItemBlockMultipartAble(BLOCK block) {
        super(block, ItemDeferredRegister.getMekBaseProperties());
    }

    @Nonnull
    public ActionResultType func_195939_a(ItemUseContext context) {
        BlockPos pos;
        PlayerEntity player = context.func_195999_j();
        if (player == null) {
            return ActionResultType.PASS;
        }
        ItemStack stack = player.func_184586_b(context.func_221531_n());
        if (stack.func_190926_b()) {
            return ActionResultType.FAIL;
        }
        World world = context.func_195991_k();
        if (!WorldUtils.isValidReplaceableBlock((IBlockReader)world, pos = context.func_195995_a())) {
            pos = pos.func_177972_a(context.func_196000_l());
        }
        if (player.func_175151_a(pos, context.func_196000_l(), stack)) {
            BlockItemUseContext blockItemUseContext = new BlockItemUseContext(context);
            BlockState state = this.func_195945_b(blockItemUseContext);
            if (state == null) {
                return ActionResultType.FAIL;
            }
            if (this.func_195941_b(blockItemUseContext, state)) {
                state = world.func_180495_p(pos);
                SoundType soundtype = state.getSoundType((IWorldReader)world, pos, (Entity)player);
                world.func_184133_a(player, pos, soundtype.func_185841_e(), SoundCategory.BLOCKS, (soundtype.func_185843_a() + 1.0f) / 2.0f, soundtype.func_185847_b() * 0.8f);
                stack.func_190918_g(1);
            }
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.FAIL;
    }

    public boolean func_195941_b(@Nonnull BlockItemUseContext context, @Nonnull BlockState state) {
        if (WorldUtils.isValidReplaceableBlock((IBlockReader)context.func_195991_k(), context.func_195995_a())) {
            return super.func_195941_b(context, state);
        }
        return false;
    }
}

