/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.item.gear;

import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import mekanism.common.capabilities.ItemCapabilityWrapper;
import mekanism.common.capabilities.radiation.item.RadiationShieldingHandler;
import mekanism.common.item.gear.BaseSpecialArmorMaterial;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ArmorItem;
import net.minecraft.item.IArmorMaterial;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Rarity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraftforge.common.capabilities.ICapabilityProvider;

public class ItemHazmatSuitArmor
extends ArmorItem {
    private static final HazmatMaterial HAZMAT_MATERIAL = new HazmatMaterial();

    public ItemHazmatSuitArmor(EquipmentSlotType slot, Item.Properties properties) {
        super((IArmorMaterial)HAZMAT_MATERIAL, slot, properties.func_208103_a(Rarity.UNCOMMON));
    }

    public static double getShieldingByArmor(EquipmentSlotType type) {
        if (type == EquipmentSlotType.HEAD) {
            return 0.25;
        }
        if (type == EquipmentSlotType.CHEST) {
            return 0.4;
        }
        if (type == EquipmentSlotType.LEGS) {
            return 0.2;
        }
        if (type == EquipmentSlotType.FEET) {
            return 0.15;
        }
        return 0.0;
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, CompoundNBT nbt) {
        if (stack.func_77978_p() == null) {
            stack.func_77982_d(new CompoundNBT());
        }
        stack.func_77978_p().func_74768_a("HideFlags", 2);
        return new ItemCapabilityWrapper(stack, RadiationShieldingHandler.create(item -> ItemHazmatSuitArmor.getShieldingByArmor(this.field_77881_a)));
    }

    public boolean isBookEnchantable(ItemStack stack, ItemStack book) {
        return this.field_200882_e.func_200900_a() > 0;
    }

    @ParametersAreNonnullByDefault
    @MethodsReturnNonnullByDefault
    protected static class HazmatMaterial
    extends BaseSpecialArmorMaterial {
        protected HazmatMaterial() {
        }

        public String func_200897_d() {
            return "mekanism:hazmat";
        }
    }
}

