/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.item.gear;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mekanism.api.Action;
import mekanism.api.energy.IEnergyContainer;
import mekanism.api.inventory.AutomationType;
import mekanism.api.math.FloatingLong;
import mekanism.api.text.EnumColor;
import mekanism.api.text.ILangEntry;
import mekanism.client.MekKeyHandler;
import mekanism.client.MekanismKeyHandler;
import mekanism.common.Mekanism;
import mekanism.common.MekanismLang;
import mekanism.common.block.BlockBounding;
import mekanism.common.config.MekanismConfig;
import mekanism.common.content.gear.IModuleContainerItem;
import mekanism.common.content.gear.Module;
import mekanism.common.content.gear.Modules;
import mekanism.common.content.gear.mekatool.ModuleExcavationEscalationUnit;
import mekanism.common.content.gear.mekatool.ModuleMekaTool;
import mekanism.common.content.gear.mekatool.ModuleVeinMiningUnit;
import mekanism.common.content.gear.shared.ModuleEnergyUnit;
import mekanism.common.item.ItemEnergized;
import mekanism.common.item.interfaces.IItemHUDProvider;
import mekanism.common.item.interfaces.IModeItem;
import mekanism.common.network.PacketPortalFX;
import mekanism.common.tags.MekanismTags;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.StorageUtils;
import mekanism.common.util.WorldUtils;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.FlowingFluidBlock;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.item.Rarity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.stats.Stats;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.GameType;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fluids.IFluidBlock;

public class ItemMekaTool
extends ItemEnergized
implements IModuleContainerItem,
IModeItem,
IItemHUDProvider {
    private final Multimap<Attribute, AttributeModifier> attributes;

    public ItemMekaTool(Item.Properties properties) {
        super(MekanismConfig.gear.mekaToolBaseChargeRate, MekanismConfig.gear.mekaToolBaseEnergyCapacity, properties.func_208103_a(Rarity.EPIC).setNoRepair());
        Modules.setSupported(this, Modules.ENERGY_UNIT, Modules.ATTACK_AMPLIFICATION_UNIT, Modules.SILK_TOUCH_UNIT, Modules.VEIN_MINING_UNIT, Modules.FARMING_UNIT, Modules.TELEPORTATION_UNIT, Modules.EXCAVATION_ESCALATION_UNIT);
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        builder.put((Object)Attributes.field_233825_h_, (Object)new AttributeModifier(field_185050_h, "Weapon modifier", -2.4, AttributeModifier.Operation.ADDITION));
        this.attributes = builder.build();
    }

    public boolean func_150897_b(@Nonnull BlockState state) {
        return true;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(@Nonnull ItemStack stack, World world, @Nonnull List<ITextComponent> tooltip, @Nonnull ITooltipFlag flag) {
        if (MekKeyHandler.getIsKeyPressed(MekanismKeyHandler.detailsKey)) {
            for (Module module : Modules.loadAll(stack)) {
                ILangEntry langEntry = module.getData().getLangEntry();
                if (module.getInstalledCount() > 1) {
                    TranslationTextComponent amount = MekanismLang.GENERIC_FRACTION.translate(module.getInstalledCount(), module.getData().getMaxStackSize());
                    tooltip.add((ITextComponent)MekanismLang.GENERIC_WITH_PARENTHESIS.translateColored(EnumColor.GRAY, langEntry, amount));
                    continue;
                }
                tooltip.add((ITextComponent)langEntry.translateColored(EnumColor.GRAY, new Object[0]));
            }
        } else {
            StorageUtils.addStoredEnergy(stack, tooltip, true);
            tooltip.add((ITextComponent)MekanismLang.HOLD_FOR_MODULES.translateColored(EnumColor.GRAY, EnumColor.INDIGO, MekanismKeyHandler.detailsKey.func_238171_j_()));
        }
    }

    @Nonnull
    public ActionResultType func_195939_a(ItemUseContext context) {
        for (Module module : Modules.loadAll(context.func_195996_i())) {
            ActionResultType result;
            if (!module.isEnabled() || !(module instanceof ModuleMekaTool) || (result = ((ModuleMekaTool)module).onItemUse(context)) == ActionResultType.PASS) continue;
            return result;
        }
        return ActionResultType.PASS;
    }

    public float func_150893_a(@Nonnull ItemStack stack, @Nonnull BlockState state) {
        IEnergyContainer energyContainer = StorageUtils.getEnergyContainer(stack, 0);
        ModuleExcavationEscalationUnit module = Modules.load(stack, Modules.EXCAVATION_ESCALATION_UNIT);
        double efficiency = module == null || !module.isEnabled() ? (double)MekanismConfig.gear.mekaToolBaseEfficiency.get() : module.getEfficiency();
        return energyContainer == null || energyContainer.isEmpty() ? 1.0f : (float)efficiency;
    }

    public boolean func_179218_a(@Nonnull ItemStack stack, @Nonnull World world, @Nonnull BlockState state, @Nonnull BlockPos pos, @Nonnull LivingEntity entityliving) {
        IEnergyContainer energyContainer = StorageUtils.getEnergyContainer(stack, 0);
        if (energyContainer != null) {
            energyContainer.extract(this.getDestroyEnergy(stack, state.func_185887_b((IBlockReader)world, pos), false), Action.EXECUTE, AutomationType.MANUAL);
        }
        return true;
    }

    public boolean func_77644_a(@Nonnull ItemStack stack, @Nonnull LivingEntity target, @Nonnull LivingEntity attacker) {
        int minDamage;
        IEnergyContainer energyContainer = StorageUtils.getEnergyContainer(stack, 0);
        FloatingLong energy = energyContainer == null ? FloatingLong.ZERO : energyContainer.getEnergy();
        FloatingLong energyCost = FloatingLong.ZERO;
        int maxDamage = minDamage = MekanismConfig.gear.mekaToolBaseDamage.get();
        if (this.isModuleEnabled(stack, Modules.ATTACK_AMPLIFICATION_UNIT)) {
            maxDamage = Modules.load(stack, Modules.ATTACK_AMPLIFICATION_UNIT).getDamage();
            if (maxDamage > minDamage) {
                energyCost = ((FloatingLong)MekanismConfig.gear.mekaToolEnergyUsageWeapon.get()).multiply((float)(maxDamage - minDamage) / 4.0f);
            }
            minDamage = Math.min(minDamage, maxDamage);
        }
        int damageDifference = maxDamage - minDamage;
        double percent = 1.0;
        if (energy.smallerThan(energyCost)) {
            percent = energy.divideToLevel(energyCost);
        }
        float damage = (float)((double)minDamage + (double)damageDifference * percent);
        if (attacker instanceof PlayerEntity) {
            target.func_70097_a(DamageSource.func_76365_a((PlayerEntity)((PlayerEntity)attacker)), damage);
        } else {
            target.func_70097_a(DamageSource.func_76358_a((LivingEntity)attacker), damage);
        }
        if (energyContainer != null && !energy.isZero()) {
            energyContainer.extract(energyCost, Action.EXECUTE, AutomationType.MANUAL);
        }
        return false;
    }

    public boolean onBlockStartBreak(ItemStack stack, BlockPos pos, PlayerEntity player) {
        World world = player.field_70170_p;
        if (!world.field_72995_K && !player.func_184812_l_()) {
            BlockState state = world.func_180495_p(pos);
            IEnergyContainer energyContainer = StorageUtils.getEnergyContainer(stack, 0);
            if (energyContainer == null) {
                return super.onBlockStartBreak(stack, pos, player);
            }
            boolean silk = this.isModuleEnabled(stack, Modules.SILK_TOUCH_UNIT);
            if (silk && !this.breakBlock(stack, world, pos, (ServerPlayerEntity)player, energyContainer, true)) {
                return super.onBlockStartBreak(stack, pos, player);
            }
            if (this.isModuleEnabled(stack, Modules.VEIN_MINING_UNIT)) {
                ModuleVeinMiningUnit module = Modules.load(stack, Modules.VEIN_MINING_UNIT);
                boolean extended = module.isExtended();
                if (state.func_177230_c() instanceof BlockBounding) {
                    return silk;
                }
                if (extended || state.func_235714_a_(MekanismTags.Blocks.ATOMIC_DISASSEMBLER_ORE)) {
                    ServerPlayerEntity serverPlayerEntity = (ServerPlayerEntity)player;
                    Set<BlockPos> found = ModuleVeinMiningUnit.findPositions(state, pos, world, extended ? module.getExcavationRange() : -1);
                    for (BlockPos foundPos : found) {
                        if (pos.equals((Object)foundPos)) continue;
                        this.breakBlock(stack, world, foundPos, serverPlayerEntity, energyContainer, silk);
                    }
                }
            }
        }
        return super.onBlockStartBreak(stack, pos, player);
    }

    private boolean breakBlock(ItemStack stack, World world, BlockPos pos, ServerPlayerEntity player, IEnergyContainer energyContainer, boolean silk) {
        BlockState state = world.func_180495_p(pos);
        FloatingLong destroyEnergy = this.getDestroyEnergy(stack, state.func_185887_b((IBlockReader)world, pos), silk);
        if (energyContainer.extract(destroyEnergy, Action.SIMULATE, AutomationType.MANUAL).smallerThan(destroyEnergy)) {
            return false;
        }
        int exp = ForgeHooks.onBlockBreakEvent((World)world, (GameType)player.field_71134_c.func_73081_b(), (ServerPlayerEntity)player, (BlockPos)pos);
        if (exp == -1) {
            return false;
        }
        Block block = state.func_177230_c();
        TileEntity tileEntity = WorldUtils.getTileEntity((IBlockReader)world, pos);
        boolean removed = state.removedByPlayer(world, pos, (PlayerEntity)player, true, state.func_204520_s());
        if (removed) {
            block.func_176206_d((IWorld)world, pos, state);
            ItemStack harvestTool = stack.func_77946_l();
            if (silk) {
                harvestTool.func_77966_a(Enchantments.field_185306_r, 1);
                exp = state.getExpDrop((IWorldReader)world, pos, 0, 1);
            }
            block.func_180657_a(world, (PlayerEntity)player, pos, state, tileEntity, harvestTool);
            player.func_71029_a(Stats.field_75929_E.func_199076_b((Object)this));
            if (exp > 0) {
                block.func_180637_b((ServerWorld)world, pos, exp);
            }
            energyContainer.extract(destroyEnergy, Action.EXECUTE, AutomationType.MANUAL);
        }
        return true;
    }

    private FloatingLong getDestroyEnergy(ItemStack itemStack, float hardness, boolean silk) {
        FloatingLong destroyEnergy = silk ? (FloatingLong)MekanismConfig.gear.mekaToolEnergyUsageSilk.get() : (FloatingLong)MekanismConfig.gear.mekaToolEnergyUsage.get();
        ModuleExcavationEscalationUnit module = Modules.load(itemStack, Modules.EXCAVATION_ESCALATION_UNIT);
        double efficiency = module == null || !module.isEnabled() ? (double)MekanismConfig.gear.mekaToolBaseEfficiency.get() : module.getEfficiency();
        destroyEnergy = destroyEnergy.multiply(efficiency);
        return hardness == 0.0f ? destroyEnergy.divide(2L) : destroyEnergy;
    }

    @Nonnull
    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(@Nonnull EquipmentSlotType slot, @Nonnull ItemStack stack) {
        return slot == EquipmentSlotType.MAINHAND ? this.attributes : super.getAttributeModifiers(slot, stack);
    }

    @Nonnull
    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, @Nonnull Hand hand) {
        BlockPos pos;
        BlockRayTraceResult result;
        ItemStack stack = player.func_184586_b(hand);
        if (!world.func_201670_d() && this.isModuleEnabled(stack, Modules.TELEPORTATION_UNIT) && (result = MekanismUtils.rayTrace(player, MekanismConfig.gear.mekaToolMaxTeleportReach.get())).func_216346_c() != RayTraceResult.Type.MISS && this.isValidDestinationBlock(world, (pos = result.func_216350_a()).func_177984_a()) && this.isValidDestinationBlock(world, pos.func_177981_b(2))) {
            double distance = player.func_70092_e((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p());
            if (distance < 5.0) {
                return new ActionResult(ActionResultType.PASS, (Object)stack);
            }
            IEnergyContainer energyContainer = StorageUtils.getEnergyContainer(stack, 0);
            FloatingLong energyNeeded = ((FloatingLong)MekanismConfig.gear.mekaToolEnergyUsageTeleport.get()).multiply(distance / 10.0);
            if (energyContainer == null || energyContainer.getEnergy().smallerThan(energyNeeded)) {
                return new ActionResult(ActionResultType.FAIL, (Object)stack);
            }
            energyContainer.extract(energyNeeded, Action.EXECUTE, AutomationType.MANUAL);
            player.func_70634_a((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 1.5, (double)pos.func_177952_p() + 0.5);
            player.field_70143_R = 0.0f;
            Mekanism.packetHandler.sendToAllTracking(new PacketPortalFX(pos.func_177984_a()), world, pos);
            world.func_184148_a(null, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), SoundEvents.field_187534_aX, SoundCategory.PLAYERS, 1.0f, 1.0f);
            return new ActionResult(ActionResultType.SUCCESS, (Object)stack);
        }
        return new ActionResult(ActionResultType.PASS, (Object)stack);
    }

    private boolean isValidDestinationBlock(World world, BlockPos pos) {
        BlockState blockState = world.func_180495_p(pos);
        return blockState.isAir((IBlockReader)world, pos) || blockState.func_177230_c() instanceof FlowingFluidBlock || blockState.func_177230_c() instanceof IFluidBlock;
    }

    @Override
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundNBT nbt) {
        if (stack.func_77978_p() == null) {
            stack.func_77982_d(new CompoundNBT());
        }
        stack.func_77978_p().func_74768_a("HideFlags", 2);
        return super.initCapabilities(stack, nbt);
    }

    @Override
    public void addHUDStrings(List<ITextComponent> list, ItemStack stack, EquipmentSlotType slotType) {
        for (Module module : Modules.loadAll(stack)) {
            if (!module.renderHUD()) continue;
            module.addHUDStrings(list);
        }
    }

    @Override
    public void changeMode(@Nonnull PlayerEntity player, @Nonnull ItemStack stack, int shift, boolean displayChangeMessage) {
        for (Module module : Modules.loadAll(stack)) {
            if (!module.handlesModeChange()) continue;
            module.changeMode(player, stack, shift, displayChangeMessage);
            return;
        }
    }

    @Override
    protected FloatingLong getMaxEnergy(ItemStack stack) {
        ModuleEnergyUnit module = Modules.load(stack, Modules.ENERGY_UNIT);
        return module != null ? module.getEnergyCapacity() : (FloatingLong)MekanismConfig.gear.mekaToolBaseEnergyCapacity.get();
    }

    @Override
    protected FloatingLong getChargeRate(ItemStack stack) {
        ModuleEnergyUnit module = Modules.load(stack, Modules.ENERGY_UNIT);
        return module != null ? module.getChargeRate() : (FloatingLong)MekanismConfig.gear.mekaToolBaseChargeRate.get();
    }
}

