/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.lib.frequency;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import mekanism.common.inventory.container.MekanismContainer;
import mekanism.common.inventory.container.sync.SyncableFrequency;
import mekanism.common.inventory.container.sync.list.SyncableFrequencyList;
import mekanism.common.lib.frequency.Frequency;
import mekanism.common.lib.frequency.FrequencyManager;
import mekanism.common.lib.frequency.FrequencyManagerWrapper;
import mekanism.common.lib.frequency.FrequencyType;
import mekanism.common.tile.base.TileEntityMekanism;
import mekanism.common.tile.component.ITileComponent;
import mekanism.common.util.WorldUtils;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;

public class TileComponentFrequency
implements ITileComponent {
    private final TileEntityMekanism tile;
    private final Map<FrequencyType<?>, Frequency> heldFrequencies = new LinkedHashMap();
    private final Map<FrequencyType<?>, FrequencyTrackingData> supportedFrequencies = new LinkedHashMap();
    private final Map<FrequencyType<?>, List<? extends Frequency>> publicCache = new LinkedHashMap();
    private final Map<FrequencyType<?>, List<? extends Frequency>> privateCache = new LinkedHashMap();
    private boolean needsNotify;

    public TileComponentFrequency(TileEntityMekanism tile) {
        this.tile = tile;
        tile.addComponent(this);
    }

    @Override
    public void tick() {
        if (!this.tile.isRemote()) {
            for (FrequencyType<?> type : this.heldFrequencies.keySet()) {
                this.updateFrequency(type);
            }
            if (this.needsNotify) {
                this.tile.invalidateCachedCapabilities();
                WorldUtils.notifyLoadedNeighborsOfTileChange(this.tile.func_145831_w(), this.tile.func_174877_v());
                this.tile.markDirty(false);
                this.needsNotify = false;
            }
        }
    }

    public void track(FrequencyType<?> type, boolean needsSync, boolean needsListCache, boolean notifyNeighbors) {
        this.supportedFrequencies.put(type, new FrequencyTrackingData(needsSync, needsListCache, notifyNeighbors));
    }

    public <FREQ extends Frequency> FREQ getFrequency(FrequencyType<FREQ> type) {
        return (FREQ)this.heldFrequencies.get(type);
    }

    public void setFrequency(FrequencyType<?> type, Frequency freq) {
        this.heldFrequencies.put(type, freq);
    }

    public <FREQ extends Frequency> List<FREQ> getPublicCache(FrequencyType<FREQ> type) {
        return this.publicCache.computeIfAbsent(type, t -> new ArrayList());
    }

    public <FREQ extends Frequency> List<FREQ> getPrivateCache(FrequencyType<FREQ> type) {
        return this.privateCache.computeIfAbsent(type, t -> new ArrayList());
    }

    public <FREQ extends Frequency> void setFrequencyFromData(FrequencyType<FREQ> type, Frequency.FrequencyIdentity data) {
        FrequencyManager<FREQ> manager = this.getManager(type, data);
        manager.deactivate((Frequency)this.getFrequency(type), this.tile);
        FREQ freq = manager.getOrCreateFrequency(data, this.tile.getOwnerUUID());
        ((Frequency)freq).update(this.tile);
        this.setFrequency(type, (Frequency)freq);
        this.setNeedsNotify(type);
    }

    public void removeFrequencyFromData(FrequencyType<?> type, Frequency.FrequencyIdentity data) {
        FrequencyManager<?> manager = this.getManager(type, data);
        if (manager != null) {
            manager.remove(data.getKey(), this.tile.getOwnerUUID());
            this.setNeedsNotify(type);
        }
    }

    private <FREQ extends Frequency> void updateFrequency(FrequencyType<FREQ> type) {
        FREQ frequency;
        FREQ lastFreq = frequency = this.getFrequency(type);
        FrequencyManager<FREQ> manager = this.getManager(type, frequency);
        if (manager != null) {
            if (frequency != null && !((Frequency)frequency).isValid()) {
                frequency = manager.validateFrequency(this.tile, frequency);
                this.setNeedsNotify(type);
            }
            if (frequency != null && (frequency = manager.update(this.tile, frequency)) == null) {
                this.setNeedsNotify(type);
            }
        } else {
            frequency = null;
            if (lastFreq != null) {
                this.setNeedsNotify(type);
            }
        }
        if (frequency != lastFreq) {
            this.setFrequency(type, (Frequency)frequency);
        }
    }

    private void setNeedsNotify(FrequencyType<?> type) {
        if (this.supportedFrequencies.get(type).notifyNeighbors) {
            this.needsNotify = true;
        }
    }

    private void unload() {
        if (!this.tile.isRemote()) {
            this.heldFrequencies.forEach((key, value) -> this.deactivate((FrequencyType)key));
        }
    }

    private <FREQ extends Frequency> void deactivate(FrequencyType<FREQ> type) {
        FrequencyManager<FREQ> manager;
        FREQ freq = this.getFrequency(type);
        if (freq != null && (manager = this.getManager(type, freq)) != null) {
            manager.deactivate((Frequency)freq, this.tile);
        }
    }

    private <FREQ extends Frequency> FrequencyManager<FREQ> getManager(FrequencyType<FREQ> type, FREQ freq) {
        if (this.tile.getOwnerUUID() == null || freq == null) {
            return null;
        }
        return type.getFrequencyManager(freq);
    }

    private <FREQ extends Frequency> FrequencyManager<FREQ> getManager(FrequencyType<FREQ> type, Frequency.FrequencyIdentity data) {
        FrequencyManagerWrapper<FREQ> wrapper = type.getManagerWrapper();
        return data.isPublic() ? wrapper.getPublicManager() : wrapper.getPrivateManager(this.tile.getOwnerUUID());
    }

    @Override
    public void read(CompoundNBT nbtTags) {
        for (FrequencyType<?> type : this.supportedFrequencies.keySet()) {
            if (!nbtTags.func_150297_b(type.getName(), 10)) continue;
            Object frequency = type.create(nbtTags.func_74775_l(type.getName()));
            ((Frequency)frequency).setValid(false);
            this.heldFrequencies.put(type, (Frequency)frequency);
        }
    }

    @Override
    public void write(CompoundNBT nbtTags) {
        for (Frequency frequency : this.heldFrequencies.values()) {
            if (frequency == null) continue;
            CompoundNBT frequencyTag = new CompoundNBT();
            frequency.write(frequencyTag);
            nbtTags.func_218657_a(frequency.getType().getName(), (INBT)frequencyTag);
        }
    }

    @Override
    public void invalidate() {
        this.unload();
    }

    @Override
    public void onChunkUnload() {
        this.unload();
    }

    @Override
    public void trackForMainContainer(MekanismContainer container) {
        for (Map.Entry<FrequencyType<?>, FrequencyTrackingData> entry : this.supportedFrequencies.entrySet()) {
            if (entry.getValue().needsContainerSync) {
                container.track(SyncableFrequency.create(() -> this.heldFrequencies.get(entry.getKey()), value -> this.heldFrequencies.put((FrequencyType<?>)entry.getKey(), (Frequency)value)));
            }
            if (!entry.getValue().needsListCache) continue;
            this.track(container, entry.getKey());
        }
    }

    private <FREQ extends Frequency> void track(MekanismContainer container, FrequencyType<FREQ> type) {
        container.track(SyncableFrequencyList.create(() -> type.getManagerWrapper().getPublicFrequencies(this.tile, this.getPublicCache(type)), value -> this.publicCache.put(type, (List<Frequency>)value)));
        container.track(SyncableFrequencyList.create(() -> type.getManagerWrapper().getPrivateFrequencies(this.tile, this.getPrivateCache(type)), value -> this.privateCache.put(type, (List<Frequency>)value)));
    }

    @Override
    public void addToUpdateTag(CompoundNBT updateTag) {
    }

    @Override
    public void readFromUpdateTag(CompoundNBT updateTag) {
    }

    private static class FrequencyTrackingData {
        private final boolean needsContainerSync;
        private final boolean needsListCache;
        private final boolean notifyNeighbors;

        public FrequencyTrackingData(boolean needsContainerSync, boolean needsListCache, boolean notifyNeighbors) {
            this.needsContainerSync = needsContainerSync;
            this.needsListCache = needsListCache;
            this.notifyNeighbors = notifyNeighbors;
        }
    }
}

