/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.lib.multiblock;

import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.Set;
import java.util.UUID;
import java.util.function.Predicate;
import mekanism.api.text.EnumColor;
import mekanism.api.text.ILangEntry;
import mekanism.common.MekanismLang;
import mekanism.common.lib.multiblock.IMultiblock;
import mekanism.common.lib.multiblock.IStructureValidator;
import mekanism.common.lib.multiblock.IValveHandler;
import mekanism.common.lib.multiblock.MultiblockCache;
import mekanism.common.lib.multiblock.MultiblockData;
import mekanism.common.lib.multiblock.MultiblockManager;
import mekanism.common.lib.multiblock.Structure;
import mekanism.common.util.EnumUtils;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.chunk.IChunk;

public class FormationProtocol<T extends MultiblockData> {
    public static final int MAX_SIZE = 18;
    private final IMultiblock<T> pointer;
    private final Structure structure;
    private final MultiblockManager<T> manager;
    public final Set<BlockPos> locations = new ObjectOpenHashSet();
    public final Set<BlockPos> innerNodes = new ObjectOpenHashSet();
    public final Set<IValveHandler.ValveData> valves = new ObjectOpenHashSet();
    public final Set<UUID> idsFound = new ObjectOpenHashSet();

    public FormationProtocol(IMultiblock<T> tile, Structure structure) {
        this.pointer = tile;
        this.structure = structure;
        this.manager = tile.getManager();
    }

    public StructureResult buildStructure(IStructureValidator<T> validator) {
        T structure = this.pointer.createMultiblock();
        if (!((MultiblockData)structure).setShape(validator.getShape())) {
            return this.fail(FormationResult.FAIL);
        }
        Long2ObjectOpenHashMap chunkMap = new Long2ObjectOpenHashMap();
        FormationResult result = validator.validate(this, (Long2ObjectMap<IChunk>)chunkMap);
        if (!result.isFormed()) {
            return this.fail(result);
        }
        ((MultiblockData)structure).locations = this.locations;
        ((MultiblockData)structure).innerNodes = this.innerNodes;
        ((MultiblockData)structure).valves = this.valves;
        result = validator.postcheck(structure, this.innerNodes, (Long2ObjectMap<IChunk>)chunkMap);
        return result.isFormed() ? this.form(structure, this.idsFound) : this.fail(result);
    }

    public FormationResult doUpdate() {
        IStructureValidator<T> validator = this.manager.createValidator();
        validator.init(this.pointer.getTileWorld(), this.manager, this.structure);
        if (!validator.precheck()) {
            return FormationResult.FAIL;
        }
        StructureResult result = this.buildStructure(validator);
        MultiblockData structureFound = result.structureFound;
        if (structureFound != null && structureFound.locations.contains(this.pointer.getTilePos())) {
            this.pointer.setMultiblockData(this.manager, structureFound);
            structureFound.setFormedForce(true);
            MultiblockCache<T> cache = this.manager.createCache();
            UUID idToUse = null;
            if (result.idsFound.isEmpty()) {
                idToUse = this.manager.getUniqueInventoryID();
            } else {
                ArrayList<ItemStack> rejectedItems = new ArrayList<ItemStack>();
                for (UUID id : result.idsFound) {
                    if (this.manager.inventories.get(id) == null) continue;
                    cache.merge(this.manager.pullInventory(this.pointer.getTileWorld(), id), rejectedItems);
                    idToUse = id;
                }
            }
            cache.apply(structureFound);
            structureFound.inventoryID = idToUse;
            structureFound.onCreated(this.pointer.getTileWorld());
            return FormationResult.SUCCESS;
        }
        this.pointer.getStructure().removeMultiblock(this.pointer.getTileWorld());
        return result.getFormationResult();
    }

    protected static ITextComponent text(BlockPos pos) {
        return MekanismLang.GENERIC_PARENTHESIS.translate(MekanismLang.GENERIC_BLOCK_POS.translate(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p()));
    }

    public static int explore(BlockPos start, Predicate<BlockPos> checker) {
        return FormationProtocol.explore(start, checker, 5832);
    }

    public static int explore(BlockPos start, Predicate<BlockPos> checker, int maxCount) {
        if (!checker.test(start)) {
            return 0;
        }
        LinkedList<BlockPos> openSet = new LinkedList<BlockPos>();
        ObjectOpenHashSet traversed = new ObjectOpenHashSet();
        openSet.add(start);
        traversed.add(start);
        while (!openSet.isEmpty()) {
            BlockPos ptr = (BlockPos)openSet.poll();
            if (traversed.size() >= maxCount) {
                return traversed.size();
            }
            for (Direction side : EnumUtils.DIRECTIONS) {
                BlockPos offset = ptr.func_177972_a(side);
                if (traversed.contains(offset) || !checker.test(offset)) continue;
                openSet.add(offset);
                traversed.add(offset);
            }
        }
        return traversed.size();
    }

    private StructureResult fail(FormationResult result) {
        return new StructureResult(this, result, null, null);
    }

    private StructureResult form(T structureFound, Set<UUID> idsFound) {
        return new StructureResult(this, FormationResult.SUCCESS, (MultiblockData)structureFound, idsFound);
    }

    public static enum StructureRequirement {
        IGNORED,
        FRAME,
        OTHER,
        INNER;

        public static final StructureRequirement[] REQUIREMENTS;

        boolean needsFrame() {
            return this == FRAME;
        }

        boolean isCasing() {
            return this != INNER;
        }

        static {
            REQUIREMENTS = StructureRequirement.values();
        }
    }

    public static enum CasingType {
        FRAME,
        VALVE,
        OTHER,
        INVALID;


        boolean isFrame() {
            return this == FRAME;
        }

        boolean isValve() {
            return this == VALVE;
        }
    }

    private static class StructureResult {
        private final FormationResult result;
        private final T structureFound;
        private final Set<UUID> idsFound;
        final /* synthetic */ FormationProtocol this$0;

        private StructureResult(FormationResult result, T structureFound, Set<UUID> idsFound) {
            this.this$0 = var1_1;
            this.result = result;
            this.structureFound = structureFound;
            this.idsFound = idsFound;
        }

        private FormationResult getFormationResult() {
            return this.result;
        }
    }

    public static class FormationResult {
        public static final FormationResult SUCCESS = new FormationResult(true, null);
        public static final FormationResult FAIL = new FormationResult(false, null);
        private final ITextComponent resultText;
        private final boolean formed;

        private FormationResult(boolean formed, ITextComponent resultText) {
            this.formed = formed;
            this.resultText = resultText;
        }

        public static FormationResult fail(ILangEntry text, BlockPos pos) {
            return FormationResult.fail((ITextComponent)text.translateColored(EnumColor.GRAY, EnumColor.INDIGO, FormationProtocol.text(pos)));
        }

        public static FormationResult fail(ILangEntry text) {
            return FormationResult.fail((ITextComponent)text.translateColored(EnumColor.GRAY, new Object[0]));
        }

        public static FormationResult fail(ITextComponent text) {
            return new FormationResult(false, text);
        }

        public boolean isFormed() {
            return this.formed;
        }

        public ITextComponent getResultText() {
            return this.resultText;
        }
    }
}

