/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.lib.transmitter;

import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mekanism.api.Range3D;
import mekanism.common.content.network.transmitter.BufferedTransmitter;
import mekanism.common.content.network.transmitter.Transmitter;
import mekanism.common.lib.transmitter.DynamicNetwork;
import mekanism.common.util.WorldUtils;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraftforge.eventbus.api.Event;

public abstract class DynamicBufferedNetwork<ACCEPTOR, NETWORK extends DynamicBufferedNetwork<ACCEPTOR, NETWORK, BUFFER, TRANSMITTER>, BUFFER, TRANSMITTER extends BufferedTransmitter<ACCEPTOR, NETWORK, BUFFER, TRANSMITTER>>
extends DynamicNetwork<ACCEPTOR, NETWORK, TRANSMITTER> {
    protected final Set<ChunkPos> chunks = new ObjectOpenHashSet();
    @Nullable
    protected Range3D packetRange;
    protected long capacity;
    protected boolean needsUpdate;
    private boolean forceScaleUpdate;
    private long lastSaveShareWriteTime;
    private long lastMarkDirtyTime;
    public float currentScale;

    protected DynamicBufferedNetwork() {
    }

    protected DynamicBufferedNetwork(UUID networkID) {
        super(networkID);
    }

    protected abstract float computeContentScale();

    @Override
    public void onUpdate() {
        super.onUpdate();
        float scale = this.computeContentScale();
        if (scale != this.currentScale) {
            this.currentScale = scale;
            this.needsUpdate = true;
        }
    }

    @Override
    public void addNewTransmitters(Collection<TRANSMITTER> newTransmitters) {
        super.addNewTransmitters(newTransmitters);
        if (!this.forceScaleUpdate) {
            this.forceScaleUpdate = this.isEmpty();
        }
    }

    @Override
    protected void addTransmitterFromCommit(TRANSMITTER transmitter) {
        this.updateCapacity(transmitter);
        this.absorbBuffer(transmitter);
        super.addTransmitterFromCommit(transmitter);
        this.chunks.add(new ChunkPos(((Transmitter)transmitter).getTilePos()));
    }

    @Override
    protected void validTransmittersAdded() {
        super.validTransmittersAdded();
        this.clampBuffer();
        if (this.forceScaleUpdate) {
            this.forceScaleUpdate = false;
            this.forceScaleUpdate();
        }
        this.needsUpdate = true;
        this.packetRange = null;
    }

    @Override
    public List<TRANSMITTER> adoptTransmittersAndAcceptorsFrom(NETWORK net) {
        List transmittersToUpdate = super.adoptTransmittersAndAcceptorsFrom(net);
        this.updateCapacity();
        return transmittersToUpdate;
    }

    @Override
    protected void removeInvalid(@Nullable TRANSMITTER triggerTransmitter) {
        super.removeInvalid(triggerTransmitter);
        this.clampBuffer();
        this.updateSaveShares(triggerTransmitter);
    }

    protected abstract void forceScaleUpdate();

    @Nonnull
    public abstract BUFFER getBuffer();

    public abstract void absorbBuffer(TRANSMITTER var1);

    public abstract void clampBuffer();

    public boolean compatibleWithBuffer(BUFFER buffer) {
        return true;
    }

    public boolean isCompatibleWith(NETWORK other) {
        return true;
    }

    protected synchronized void updateCapacity(TRANSMITTER transmitter) {
        long transmitterCapacity = ((BufferedTransmitter)transmitter).getCapacity();
        this.capacity = transmitterCapacity > Long.MAX_VALUE - this.capacity ? Long.MAX_VALUE : (this.capacity += transmitterCapacity);
    }

    public synchronized void updateCapacity() {
        long sum = 0L;
        for (BufferedTransmitter transmitter : this.transmitters) {
            long transmitterCapacity = transmitter.getCapacity();
            if (transmitterCapacity > Long.MAX_VALUE - this.capacity) {
                sum = Long.MAX_VALUE;
                break;
            }
            sum += transmitterCapacity;
        }
        if (this.capacity != sum) {
            this.capacity = sum;
        }
    }

    public long getCapacity() {
        return this.capacity;
    }

    @Override
    public Object getNetworkReaderCapacity() {
        return this.getCapacity();
    }

    protected void updateSaveShares(@Nullable TRANSMITTER triggerTransmitter) {
    }

    public final void validateSaveShares(@Nonnull TRANSMITTER triggerTransmitter) {
        if (this.world == null) {
            this.world = ((Transmitter)triggerTransmitter).getTileWorld();
        }
        if (this.world != null && this.world.func_82737_E() != this.lastSaveShareWriteTime) {
            this.lastSaveShareWriteTime = this.world.func_82737_E();
            this.updateSaveShares(triggerTransmitter);
        }
    }

    public void markDirty() {
        if (this.world != null && !this.world.field_72995_K && this.world.func_82737_E() != this.lastMarkDirtyTime) {
            this.lastMarkDirtyTime = this.world.func_82737_E();
            this.chunks.forEach(chunk -> WorldUtils.markChunkDirty(this.world, chunk.func_206849_h()));
        }
    }

    public Range3D getPacketRange() {
        if (this.packetRange == null) {
            this.packetRange = this.genPacketRange();
        }
        return this.packetRange;
    }

    private Range3D genPacketRange() {
        if (this.isEmpty()) {
            this.deregister();
            return null;
        }
        boolean initialized = false;
        int minX = 0;
        int minZ = 0;
        int maxX = 0;
        int maxZ = 0;
        for (BufferedTransmitter transmitter : this.transmitters) {
            BlockPos pos = transmitter.getTilePos();
            if (initialized) {
                if (pos.func_177958_n() < minX) {
                    minX = pos.func_177958_n();
                } else if (pos.func_177958_n() > maxX) {
                    maxX = pos.func_177958_n();
                }
                if (pos.func_177952_p() < minZ) {
                    minZ = pos.func_177952_p();
                    continue;
                }
                if (pos.func_177952_p() <= maxZ) continue;
                maxZ = pos.func_177952_p();
                continue;
            }
            minX = pos.func_177958_n();
            minZ = pos.func_177952_p();
            maxX = minX;
            maxZ = minZ;
            initialized = true;
        }
        return new Range3D(minX, minZ, maxX, maxZ, (RegistryKey<World>)this.world.func_234923_W_());
    }

    public static class TransferEvent<NETWORK extends DynamicBufferedNetwork<?, NETWORK, ?, ?>>
    extends Event {
        public final NETWORK network;

        public TransferEvent(NETWORK network) {
            this.network = network;
        }
    }
}

