/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.network;

import java.util.function.Supplier;
import mekanism.api.text.EnumColor;
import mekanism.common.Mekanism;
import mekanism.common.content.qio.QIOFrequency;
import mekanism.common.item.ItemPortableQIODashboard;
import mekanism.common.lib.frequency.Frequency;
import mekanism.common.lib.frequency.FrequencyType;
import mekanism.common.network.PacketFrequencyItemGuiUpdate;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.network.NetworkEvent;

public class PacketQIOSetColor {
    private final Type type;
    private final int extra;
    private final Frequency.FrequencyIdentity identity;
    private final BlockPos tilePosition;
    private final Hand currentHand;

    private PacketQIOSetColor(Type type, int extra, Frequency.FrequencyIdentity identity, BlockPos tilePosition, Hand currentHand) {
        this.type = type;
        this.extra = extra;
        this.identity = identity;
        this.tilePosition = tilePosition;
        this.currentHand = currentHand;
    }

    public static PacketQIOSetColor create(BlockPos tilePosition, QIOFrequency freq, int extra) {
        return new PacketQIOSetColor(Type.TILE, extra, freq.getIdentity(), tilePosition, null);
    }

    public static PacketQIOSetColor create(Hand currentHand, QIOFrequency freq, int extra) {
        return new PacketQIOSetColor(Type.ITEM, extra, freq.getIdentity(), null, currentHand);
    }

    public static void handle(PacketQIOSetColor message, Supplier<NetworkEvent.Context> context) {
        NetworkEvent.Context ctx = context.get();
        ctx.enqueueWork(() -> {
            QIOFrequency freq;
            ServerPlayerEntity player = ctx.getSender();
            if (player != null && (freq = FrequencyType.QIO.getFrequency(message.identity, player.func_110124_au())) != null && freq.getOwner().equals(player.func_110124_au())) {
                freq.setColor(message.extra == 0 ? (EnumColor)freq.getColor().getNext() : (EnumColor)freq.getColor().getPrevious());
                if (message.type == Type.ITEM) {
                    ItemStack stack = player.func_184582_a(EquipmentSlotType.MAINHAND);
                    if (stack.func_77973_b() instanceof ItemPortableQIODashboard) {
                        ((ItemPortableQIODashboard)stack.func_77973_b()).setColor(stack, freq.getColor());
                    }
                    Mekanism.packetHandler.sendTo(PacketFrequencyItemGuiUpdate.update(message.currentHand, FrequencyType.QIO, player.func_110124_au(), freq), player);
                }
            }
        });
        ctx.setPacketHandled(true);
    }

    public static void encode(PacketQIOSetColor pkt, PacketBuffer buf) {
        buf.func_179249_a((Enum)pkt.type);
        buf.func_150787_b(pkt.extra);
        FrequencyType.QIO.getIdentitySerializer().write(buf, pkt.identity);
        if (pkt.type == Type.TILE) {
            buf.func_179255_a(pkt.tilePosition);
        } else {
            buf.func_179249_a((Enum)pkt.currentHand);
        }
    }

    public static PacketQIOSetColor decode(PacketBuffer buf) {
        Type type = (Type)buf.func_179257_a(Type.class);
        int extra = buf.func_150792_a();
        Frequency.FrequencyIdentity identity = FrequencyType.QIO.getIdentitySerializer().read(buf);
        BlockPos pos = type == Type.TILE ? buf.func_179259_c() : null;
        Hand hand = type == Type.ITEM ? (Hand)buf.func_179257_a(Hand.class) : null;
        return new PacketQIOSetColor(type, extra, identity, pos, hand);
    }

    public static enum Type {
        TILE,
        ITEM;

    }
}

