/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.network;

import java.util.function.Supplier;
import mekanism.api.text.EnumColor;
import mekanism.common.Mekanism;
import mekanism.common.content.teleporter.TeleporterFrequency;
import mekanism.common.lib.frequency.Frequency;
import mekanism.common.lib.frequency.FrequencyType;
import mekanism.common.network.PacketFrequencyItemGuiUpdate;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.network.NetworkEvent;

public class PacketTeleporterSetColor {
    private final Type type;
    private final int extra;
    private final Frequency.FrequencyIdentity identity;
    private final BlockPos tilePosition;
    private final Hand currentHand;

    private PacketTeleporterSetColor(Type type, int extra, Frequency.FrequencyIdentity identity, BlockPos tilePosition, Hand currentHand) {
        this.type = type;
        this.extra = extra;
        this.identity = identity;
        this.tilePosition = tilePosition;
        this.currentHand = currentHand;
    }

    public static PacketTeleporterSetColor create(BlockPos tilePosition, TeleporterFrequency freq, int extra) {
        return new PacketTeleporterSetColor(Type.TILE, extra, freq.getIdentity(), tilePosition, null);
    }

    public static PacketTeleporterSetColor create(Hand currentHand, TeleporterFrequency freq, int extra) {
        return new PacketTeleporterSetColor(Type.ITEM, extra, freq.getIdentity(), null, currentHand);
    }

    public static void handle(PacketTeleporterSetColor message, Supplier<NetworkEvent.Context> context) {
        NetworkEvent.Context ctx = context.get();
        ctx.enqueueWork(() -> {
            TeleporterFrequency freq;
            ServerPlayerEntity player = ctx.getSender();
            if (player != null && (freq = FrequencyType.TELEPORTER.getFrequency(message.identity, player.func_110124_au())) != null && freq.getOwner().equals(player.func_110124_au())) {
                freq.setColor(message.extra == 0 ? (EnumColor)freq.getColor().getNext() : (EnumColor)freq.getColor().getPrevious());
                if (message.type == Type.ITEM) {
                    Mekanism.packetHandler.sendTo(PacketFrequencyItemGuiUpdate.update(message.currentHand, FrequencyType.TELEPORTER, player.func_110124_au(), freq), player);
                }
            }
        });
        ctx.setPacketHandled(true);
    }

    public static void encode(PacketTeleporterSetColor pkt, PacketBuffer buf) {
        buf.func_179249_a((Enum)pkt.type);
        buf.func_150787_b(pkt.extra);
        FrequencyType.TELEPORTER.getIdentitySerializer().write(buf, pkt.identity);
        if (pkt.type == Type.TILE) {
            buf.func_179255_a(pkt.tilePosition);
        } else {
            buf.func_179249_a((Enum)pkt.currentHand);
        }
    }

    public static PacketTeleporterSetColor decode(PacketBuffer buf) {
        Type type = (Type)buf.func_179257_a(Type.class);
        int extra = buf.func_150792_a();
        Frequency.FrequencyIdentity identity = FrequencyType.TELEPORTER.getIdentitySerializer().read(buf);
        BlockPos pos = type == Type.TILE ? buf.func_179259_c() : null;
        Hand hand = type == Type.ITEM ? (Hand)buf.func_179257_a(Hand.class) : null;
        return new PacketTeleporterSetColor(type, extra, identity, pos, hand);
    }

    public static enum Type {
        TILE,
        ITEM;

    }
}

