/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tile.component;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import mekanism.api.Action;
import mekanism.api.RelativeSide;
import mekanism.api.inventory.AutomationType;
import mekanism.api.inventory.IInventorySlot;
import mekanism.api.text.EnumColor;
import mekanism.common.config.MekanismConfig;
import mekanism.common.inventory.container.MekanismContainer;
import mekanism.common.inventory.container.sync.ISyncableData;
import mekanism.common.inventory.container.sync.SyncableBoolean;
import mekanism.common.inventory.container.sync.SyncableInt;
import mekanism.common.lib.inventory.TileTransitRequest;
import mekanism.common.lib.inventory.TransitRequest;
import mekanism.common.lib.transmitter.TransmissionType;
import mekanism.common.tile.base.TileEntityMekanism;
import mekanism.common.tile.component.ITileComponent;
import mekanism.common.tile.component.TileComponentConfig;
import mekanism.common.tile.component.config.ConfigInfo;
import mekanism.common.tile.component.config.DataType;
import mekanism.common.tile.component.config.slot.ChemicalSlotInfo;
import mekanism.common.tile.component.config.slot.FluidSlotInfo;
import mekanism.common.tile.component.config.slot.ISlotInfo;
import mekanism.common.tile.component.config.slot.InventorySlotInfo;
import mekanism.common.tile.transmitter.TileEntityLogisticalTransporterBase;
import mekanism.common.util.ChemicalUtil;
import mekanism.common.util.EnumUtils;
import mekanism.common.util.FluidUtils;
import mekanism.common.util.NBTUtils;
import mekanism.common.util.TransporterUtils;
import mekanism.common.util.WorldUtils;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.world.IBlockReader;

public class TileComponentEjector
implements ITileComponent,
MekanismContainer.ISpecificContainerTracker {
    private final TileEntityMekanism tile;
    private final Map<TransmissionType, ConfigInfo> configInfo = new EnumMap<TransmissionType, ConfigInfo>(TransmissionType.class);
    private final EnumColor[] inputColors = new EnumColor[]{null, null, null, null, null, null};
    private boolean strictInput;
    private EnumColor outputColor;
    private int tickDelay = 0;

    public TileComponentEjector(TileEntityMekanism tile) {
        this.tile = tile;
        tile.addComponent(this);
    }

    public TileComponentEjector setOutputData(TileComponentConfig config, TransmissionType ... types) {
        for (TransmissionType type : types) {
            ConfigInfo info = config.getConfig(type);
            if (info == null) continue;
            this.configInfo.put(type, info);
        }
        return this;
    }

    @Override
    public void tick() {
        if (!this.tile.isRemote()) {
            if (this.tickDelay == 0) {
                this.outputItems();
            } else {
                --this.tickDelay;
            }
            this.eject(TransmissionType.GAS);
            this.eject(TransmissionType.INFUSION);
            this.eject(TransmissionType.SLURRY);
            this.eject(TransmissionType.PIGMENT);
            this.eject(TransmissionType.FLUID);
        }
    }

    private void eject(TransmissionType type) {
        ConfigInfo info = this.configInfo.get(type);
        if (info != null && info.isEjecting()) {
            for (DataType dataType : info.getSupportedDataTypes()) {
                ISlotInfo slotInfo;
                if (!dataType.canOutput() || (slotInfo = info.getSlotInfo(dataType)) == null) continue;
                Set<Direction> outputSides = info.getSidesForData(dataType);
                if (type.isChemical() && slotInfo instanceof ChemicalSlotInfo) {
                    ((ChemicalSlotInfo)slotInfo).getTanks().forEach(tank -> ChemicalUtil.emit(outputSides, tank, this.tile, MekanismConfig.general.chemicalAutoEjectRate.get()));
                    continue;
                }
                if (type != TransmissionType.FLUID || !(slotInfo instanceof FluidSlotInfo)) continue;
                ((FluidSlotInfo)slotInfo).getTanks().forEach(tank -> FluidUtils.emit(outputSides, tank, this.tile, MekanismConfig.general.fluidAutoEjectRate.get()));
            }
        }
    }

    private void outputItems() {
        ConfigInfo info = this.configInfo.get(TransmissionType.ITEM);
        if (info == null || !info.isEjecting()) {
            return;
        }
        block0: for (DataType dataType : info.getSupportedDataTypes()) {
            TransitRequest ejectMap;
            if (!dataType.canOutput()) continue;
            ISlotInfo slotInfo = info.getSlotInfo(dataType);
            if (!(slotInfo instanceof InventorySlotInfo)) {
                return;
            }
            Set<Direction> outputs = info.getSidesForData(dataType);
            if (outputs.isEmpty() || (ejectMap = this.getEjectItemMap((InventorySlotInfo)slotInfo, outputs.iterator().next())).isEmpty()) continue;
            for (Direction side : outputs) {
                TransitRequest.TransitResponse response;
                TileEntity tile = WorldUtils.getTileEntity((IBlockReader)this.tile.func_145831_w(), this.tile.func_174877_v().func_177972_a(side));
                if (tile == null || (response = tile instanceof TileEntityLogisticalTransporterBase ? ((TileEntityLogisticalTransporterBase)tile).getTransmitter().insert(this.tile, ejectMap, this.outputColor, true, 0) : ejectMap.addToInventory(tile, side, false)).isEmpty()) continue;
                response.useAll();
                if (!ejectMap.isEmpty()) continue;
                continue block0;
            }
        }
        this.tickDelay = 10;
    }

    private TransitRequest getEjectItemMap(InventorySlotInfo slotInfo, Direction side) {
        TileTransitRequest request = new TileTransitRequest(this.tile, side);
        List<IInventorySlot> slots = slotInfo.getSlots();
        ArrayList<IInventorySlot> shuffled = new ArrayList<IInventorySlot>(slots);
        Collections.shuffle(shuffled);
        for (IInventorySlot slot : shuffled) {
            ItemStack simulatedExtraction = slot.extractItem(slot.getCount(), Action.SIMULATE, AutomationType.EXTERNAL);
            if (simulatedExtraction.func_190926_b()) continue;
            request.addItem(simulatedExtraction, slots.indexOf(slot));
        }
        return request;
    }

    public boolean hasStrictInput() {
        return this.strictInput;
    }

    public void setStrictInput(boolean strict) {
        this.strictInput = strict;
        WorldUtils.saveChunk(this.tile);
    }

    public EnumColor getOutputColor() {
        return this.outputColor;
    }

    public void setOutputColor(EnumColor color) {
        this.outputColor = color;
        WorldUtils.saveChunk(this.tile);
    }

    public void setInputColor(RelativeSide side, EnumColor color) {
        this.inputColors[side.ordinal()] = color;
        WorldUtils.saveChunk(this.tile);
    }

    public EnumColor getInputColor(RelativeSide side) {
        return this.inputColors[side.ordinal()];
    }

    @Override
    public void read(CompoundNBT nbtTags) {
        if (nbtTags.func_150297_b("componentEjector", 10)) {
            CompoundNBT ejectorNBT = nbtTags.func_74775_l("componentEjector");
            this.strictInput = ejectorNBT.func_74767_n("strictInput");
            NBTUtils.setEnumIfPresent(ejectorNBT, "color", TransporterUtils::readColor, color -> {
                this.outputColor = color;
            });
            int i = 0;
            while (i < EnumUtils.DIRECTIONS.length) {
                int index = i++;
                NBTUtils.setEnumIfPresent(ejectorNBT, "color" + index, TransporterUtils::readColor, color -> {
                    this.inputColors[index] = color;
                });
            }
        }
    }

    @Override
    public void write(CompoundNBT nbtTags) {
        CompoundNBT ejectorNBT = new CompoundNBT();
        ejectorNBT.func_74757_a("strictInput", this.strictInput);
        if (this.outputColor != null) {
            ejectorNBT.func_74768_a("color", TransporterUtils.getColorIndex(this.outputColor));
        }
        for (int i = 0; i < EnumUtils.DIRECTIONS.length; ++i) {
            ejectorNBT.func_74768_a("color" + i, TransporterUtils.getColorIndex(this.inputColors[i]));
        }
        nbtTags.func_218657_a("componentEjector", (INBT)ejectorNBT);
    }

    @Override
    public void trackForMainContainer(MekanismContainer container) {
    }

    @Override
    public void addToUpdateTag(CompoundNBT updateTag) {
    }

    @Override
    public void readFromUpdateTag(CompoundNBT updateTag) {
    }

    @Override
    public List<ISyncableData> getSpecificSyncableData() {
        ArrayList<ISyncableData> list = new ArrayList<ISyncableData>();
        list.add(SyncableBoolean.create(this::hasStrictInput, input -> {
            this.strictInput = input;
        }));
        list.add(SyncableInt.create(() -> TransporterUtils.getColorIndex(this.outputColor), index -> {
            this.outputColor = TransporterUtils.readColor(index);
        }));
        int i = 0;
        while (i < EnumUtils.DIRECTIONS.length) {
            int idx = i++;
            list.add(SyncableInt.create(() -> TransporterUtils.getColorIndex(this.inputColors[idx]), index -> {
                this.inputColors[idx] = TransporterUtils.readColor(index);
            }));
        }
        return list;
    }
}

