/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tile.factory;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mekanism.api.inventory.IInventorySlot;
import mekanism.api.providers.IBlockProvider;
import mekanism.api.recipes.ItemStackToItemStackRecipe;
import mekanism.api.recipes.cache.CachedRecipe;
import mekanism.api.recipes.cache.ItemStackToItemStackCachedRecipe;
import mekanism.common.recipe.MekanismRecipeType;
import mekanism.common.tile.component.ITileComponent;
import mekanism.common.tile.factory.TileEntityItemToItemFactory;
import mekanism.common.upgrade.IUpgradeData;
import mekanism.common.upgrade.MachineUpgradeData;
import mekanism.common.util.MekanismUtils;
import net.minecraft.item.ItemStack;
import net.minecraftforge.items.ItemHandlerHelper;

public class TileEntityItemStackToItemStackFactory
extends TileEntityItemToItemFactory<ItemStackToItemStackRecipe> {
    public TileEntityItemStackToItemStackFactory(IBlockProvider blockProvider) {
        super(blockProvider);
    }

    @Override
    public boolean isValidInputItem(@Nonnull ItemStack stack) {
        return this.containsRecipe(recipe -> recipe.getInput().testType(stack));
    }

    @Override
    public boolean inputProducesOutput(int process, @Nonnull ItemStack fallbackInput, @Nonnull IInventorySlot outputSlot, @Nullable IInventorySlot secondaryOutputSlot, boolean updateCache) {
        if (outputSlot.isEmpty()) {
            return true;
        }
        CachedRecipe cached = this.getCachedRecipe(process);
        if (cached != null && ((ItemStackToItemStackRecipe)cached.getRecipe()).getInput().testType(fallbackInput)) {
            return true;
        }
        ItemStack output = outputSlot.getStack();
        ItemStackToItemStackRecipe foundRecipe = (ItemStackToItemStackRecipe)this.findFirstRecipe(recipe -> recipe.getInput().testType(fallbackInput) && ItemHandlerHelper.canItemStacksStack((ItemStack)recipe.getOutput(fallbackInput), (ItemStack)output));
        if (foundRecipe == null) {
            return false;
        }
        if (updateCache) {
            CachedRecipe<ItemStackToItemStackRecipe> newCachedRecipe = this.createNewCachedRecipe(foundRecipe, process);
            if (newCachedRecipe == null) {
                return false;
            }
            this.updateCachedRecipe(newCachedRecipe, process);
        }
        return true;
    }

    @Override
    @Nonnull
    public MekanismRecipeType<ItemStackToItemStackRecipe> getRecipeType() {
        switch (this.field_200663_e) {
            case ENRICHING: {
                return MekanismRecipeType.ENRICHING;
            }
            case CRUSHING: {
                return MekanismRecipeType.CRUSHING;
            }
        }
        return MekanismRecipeType.SMELTING;
    }

    @Override
    @Nullable
    public ItemStackToItemStackRecipe getRecipe(int cacheIndex) {
        ItemStack stack = (ItemStack)this.inputHandlers[cacheIndex].getInput();
        if (stack.func_190926_b()) {
            return null;
        }
        return (ItemStackToItemStackRecipe)this.findFirstRecipe(recipe -> recipe.test(stack));
    }

    @Override
    public CachedRecipe<ItemStackToItemStackRecipe> createNewCachedRecipe(@Nonnull ItemStackToItemStackRecipe recipe, int cacheIndex) {
        return new ItemStackToItemStackCachedRecipe(recipe, this.inputHandlers[cacheIndex], this.outputHandlers[cacheIndex]).setCanHolderFunction(() -> MekanismUtils.canFunction(this)).setActive(active -> this.setActiveState(active, cacheIndex)).setEnergyRequirements(this.energyContainer::getEnergyPerTick, this.energyContainer).setRequiredTicks(() -> this.ticksRequired).setOnFinish(() -> this.markDirty(false)).setOperatingTicksChanged(operatingTicks -> {
            this.progress[cacheIndex] = operatingTicks;
        });
    }

    @Override
    public void parseUpgradeData(@Nonnull IUpgradeData upgradeData) {
        if (upgradeData instanceof MachineUpgradeData) {
            int i;
            MachineUpgradeData data = (MachineUpgradeData)upgradeData;
            this.redstone = data.redstone;
            this.setControlType(data.controlType);
            this.getEnergyContainer().setEnergy(data.energyContainer.getEnergy());
            this.sorting = data.sorting;
            this.energySlot.setStack(data.energySlot.getStack());
            System.arraycopy(data.progress, 0, this.progress, 0, data.progress.length);
            for (i = 0; i < data.inputSlots.size(); ++i) {
                ((IInventorySlot)this.inputSlots.get(i)).setStack(data.inputSlots.get(i).getStack());
            }
            for (i = 0; i < data.outputSlots.size(); ++i) {
                ((IInventorySlot)this.outputSlots.get(i)).setStack(data.outputSlots.get(i).getStack());
            }
            for (ITileComponent component : this.getComponents()) {
                component.read(data.components);
            }
        } else {
            super.parseUpgradeData(upgradeData);
        }
    }

    @Override
    @Nonnull
    public MachineUpgradeData getUpgradeData() {
        return new MachineUpgradeData(this.redstone, this.getControlType(), this.getEnergyContainer(), this.progress, this.energySlot, this.inputSlots, this.outputSlots, this.isSorting(), this.getComponents());
    }
}

